package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBrand extends ApiBaseModel {
	@NotNull
	public ApiText name;
	public List<ApiBrand.Sector> sectors;
	public String website;
	public List<String> social;
	public String logo;
	public ApiContent content;
	public List<ApiBrand.Activity> activities;
	@JsonProperty("channel_services")
	public List<ApiBrand.ChannelService> channelServices;
	public ApiBrand.Operation operations;
	public ApiBrand.Segment segment;
	public List<String> term;
	public List<ApiBrand.Terms> terms;
	public List<String> branches;
	@JsonProperty("physical_store_available")
	public Boolean physicalStoreAvailable;
	

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class ChannelService{
		public String id;
		public String code;
		public ApiText name;
		public String address;
		public String logo;
		public List<ApiBrand.Sub> sub;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sub{
		public String id;
		public String code;
		public ApiText name;
		public String logo;
		public String address;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sector{
		public String id;
		public String code;
		public ApiText name;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Activity{
		public String id;
		public String code;
		public ApiText name;
		@JsonProperty("isic_code")
		public String isicCode;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Operation{
		@JsonProperty("start_date")
		public String startDate;
		public Sales sales;
		@JsonProperty("customer_base")
		public ApiBrand.CustomerBase customerBase;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sales{
		public String id;
		public String code;
		public ApiText name;
		public String period;
		public String currency;
		public Range range;
		public List<SubRange> sub;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Range{
		public long from;
		public long to;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class SubRange{
		public String id;
		public ApiText name;
		public Range range;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class CustomerBase{
		public String id;
		public String code;
		public ApiText name;
		public String period;
		public Range range;
		public List<SubRange> sub;
		public List<Location> locations;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Location{
		public String id;
		public String code;
		public ApiText name;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Terms{
		public String term;
		public boolean agree;
		@JsonProperty("agreed_at")
		public long agreedAt;
	}
	
	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Segment {
		public String id;
		public String code;
		public ApiText name;
	}
}
