package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id","status","created","object","live_mode","api_version","feature_version",
        "fulfilment_id","carrier_provider_id","carrier_id","business_id","business_entity_id","order_id",
        "customer_id","address","shipper"})
public class ApiShipment extends ApiBaseModel {
    @JsonProperty("order_id")
    public String orderId;
    @JsonProperty("customer_id")
    public String customerId;
    public String currency;
    public Double amount;
    public ApiText description;
    @JsonProperty("address")
    public ApiAddress address;
    public Carrier shipper;
    @JsonProperty("fulfilment_id")
    public String fulfilmentId;
    @JsonProperty("carrier_provider_id")
    public String carrierProviderId;
    //can be carrierId or carrierAggregatorId
    @JsonProperty("carrier_id")
    public String carrierId;
    @JsonProperty("business_entity_id")
    public String entityId;

    @Data
    @EqualsAndHashCode(callSuper = true)
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Carrier extends ApiBaseModel{
        public String name;
        public String service;
        public String reference;
        public List<Log> logs;
    }
    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Log {
        public String status;
        public long created;
    }
}
