package company.tap.commondependencies.Cipher;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

@Log4j2
@Service
class DataCipherAes implements IDataCipherAes {

    private static final String CIPHER = "cipher";
    private static final String SECRET_KEY = "secretKey";
    private static final String IV = "iv";


    private Map<String, Object> init(String uniqueKey) throws NoSuchAlgorithmException, NoSuchPaddingException {
        uniqueKey = Base64.getEncoder().encodeToString(uniqueKey.getBytes(StandardCharsets.UTF_8));
        MessageDigest md = MessageDigest.getInstance("SHA-256"); // SHA-256, MD5
        byte[] keyArray = md.digest(uniqueKey.getBytes(StandardCharsets.UTF_8));
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        uniqueKey = Base64.getEncoder().encodeToString(uniqueKey.getBytes(StandardCharsets.UTF_8));
        byte[] iv = Arrays.copyOf(uniqueKey.getBytes(StandardCharsets.UTF_16BE), 16);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        keyArray = Arrays.copyOf(keyArray, 32);
        Key secretKey = new SecretKeySpec(keyArray, "AES");

        Map<String, Object> map = new ConcurrentHashMap<>(5);
        map.put(CIPHER, cipher);
        map.put(SECRET_KEY, secretKey);
        map.put(IV, ivParameterSpec);

        return map;
    }

    public String Encrypt(String key, String strToEncrypt) {

        try {
            Map<String, Object> initMap = init(key);

            Cipher cipher = (Cipher) initMap.get(CIPHER);
            Key secretKey = (Key) initMap.get(SECRET_KEY);
            IvParameterSpec ivParameterSpec = (IvParameterSpec) initMap.get(IV);

            cipher.init(Cipher.ENCRYPT_MODE, secretKey, ivParameterSpec);
            return URLEncoder.encode(Base64.getEncoder().encodeToString(cipher.doFinal(strToEncrypt.getBytes())), StandardCharsets.UTF_8);
        } catch (Exception e) {
            log.error("[Exception]:", e);
            return strToEncrypt;
        }
    }

    public String Decrypt(String key, String encryptedMessage) {
        try {

            Map<String, Object> initMap = init(key);

            Cipher cipher = (Cipher) initMap.get(CIPHER);
            Key secretKey = (Key) initMap.get(SECRET_KEY);
            IvParameterSpec ivParameterSpec = (IvParameterSpec) initMap.get(IV);

            cipher.init(Cipher.DECRYPT_MODE, secretKey, ivParameterSpec);
            byte[] decodedMessage = Base64.getDecoder()
                    .decode(URLDecoder.decode(encryptedMessage, StandardCharsets.UTF_8));
            return new String(cipher.doFinal(decodedMessage));

        } catch (Exception e) {
            log.error("[Exception]:", e);
        }
        return null;
    }


}
