/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import company.tap.commondependencies.ApiModels.ApiBaseModel;
import company.tap.commondependencies.ApiModels.ApiUserRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@JsonPropertyOrder({"object", "live_mode", "api_version", "feature_version", "business_id",
        "user"})
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiUserResponse extends ApiBaseModel {
    @JsonProperty("business_id")
    public String businessId;
    @JsonProperty("user")
    public ApiUserRequest user;
}
