package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.HashMap;
import java.util.List;


@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiGlobalUser extends ApiBaseModel {
    @NotNull
    public ApiContactName name;
    @NotNull
    public ApiContactInfo contact_info;
    @JsonProperty("date_of_birth")
    public Date dateOfBirth;
    @JsonProperty("is_authorized")
    public boolean isAuthorized;
    @JsonProperty("is_verified")
    public boolean isVerified;
    public List<String> identifications;
    public List<String> documents;
    public List<String> entities;
    public String nationality;
    public List<String> authorization;
    @JsonProperty("identification")
    public Identification identification;
    @JsonProperty("review_info")
    public boolean reviewInfo;
    @JsonProperty("send_invite")
    public boolean sendInvite;
    @JsonProperty("metadata")
    public HashMap<String, String> metaData;
    public ApiEntity.Relations relations;


    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Identification {
        @JsonProperty("id")
        public String id;
        @JsonProperty("issued_country_code")
        public String issueCountryCode;
        @JsonProperty("type")
        public String type;
        @JsonProperty("expiry")
        public Long expiry;
    }
}
