package company.tap.commondependencies.Customer;

import company.tap.commondependencies.ApiModels.ApiCustomer;
import company.tap.commondependencies.ApiModels.ApiCustomerList;
import company.tap.commondependencies.ApiModels.ApiList;
import company.tap.commondependencies.Country.ICountryServices;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class CustomerServices implements ICustomerServices {

    final
    IErrorServices _errorServices;

    final
    ICountryServices _countryServices;

    private final String TapApi = DataUtilities.getInstance().getUrlTapApiV2();

    public CustomerServices(IErrorServices _errorServices, ICountryServices _countryServices) {
        this._errorServices = _errorServices;
        this._countryServices = _countryServices;
    }

    public ApiCustomer GetCustomerInfo(String customerId, String authorization) throws HttpClientErrorException {
        HttpHeaders headersCA = new HttpHeaders();
        headersCA.setContentType(APPLICATION_JSON);
        headersCA.set("Authorization", "Bearer " + authorization);
        HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
        return RestAPI.getInstance()
                .exchange(TapApi + "customers/" + customerId, HttpMethod.GET, entityToken, ApiCustomer.class)
                .getBody();
    }

    public ApiCustomerList GetCustomerList(ApiList list, String authorization) throws HttpClientErrorException {
        HttpHeaders headersCA = new HttpHeaders();
        headersCA.setContentType(APPLICATION_JSON);
        headersCA.set("Authorization", "Bearer " + authorization);
        HttpEntity<ApiList> entityToken = new HttpEntity<>(list, headersCA);
        return RestAPI.getInstance()
                .exchange(TapApi + "customers/list", HttpMethod.POST, entityToken, ApiCustomerList.class)
                .getBody();
    }
}
