package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
@JsonPropertyOrder({"status", "provider", "type", "number", "additional_info", "issuing_date", "expiry_date"})
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiLicense {
    public String status;
    public String provider;
    public String type;
    public String number;
    @JsonProperty("additional_info")
    public Map<String, String> additionalInfo;
    @JsonProperty("issuing_date")
    public Long issuingDate;
    @JsonProperty("expiry_date")
    public Long expiryDate;
}
