/*
 * Copyright (c) 2022. Tap Payments
 * Author: Charan Dommara
 * Created On: 31 8 2022
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"id", "status", "created", "object", "live_mode", "api_version", "feature_version", "count", "page",
        "has_more", "individual_id", "name", "gender", "birth", "contact_info", "verification", "additional_info"})
public class ApiIndividualInfo extends ApiBaseModel {

    @JsonProperty("individual_id")
    public String individualId;

    public ApiContactName name;

    public ApiContactInfo contact_info;
    public String gender;
    @JsonProperty("birth")
    public DateOfBirth dateOfBirth;

    public Map<String, ApiVerification> verification;
    @JsonProperty("additional_info")
    public List<IndividualInfo> additionalInfo;

    @JsonProperty("identification_info")
    private Map<String, Identification> identificationInfo;

    public ApiIndividualAdditionalInfo info;

    @JsonProperty("is_login_available")
    public boolean isLoginAvailable;

    @Data
    @NoArgsConstructor
    public static class IndividualInfo {
        @JsonProperty("service_name")
        private String serviceName;
        @JsonProperty("service_type")
        private String serviceType;
        @JsonProperty("citizen_info")
        private Object citizenInfo;
        @JsonProperty("request_sent_at")
        private Date requestSentAt;
        @JsonProperty("citizen_addresses")
        private List<Object> citizenAddresses;
    }

    @Data
    @NoArgsConstructor
    public static class Identification {
        @JsonProperty("country_code")
        private String countryCode;
        @JsonProperty("id_number")
        private String idNumber;
        @JsonProperty("id_type")
        private String idType;
        @JsonProperty("is_nationality")
        private boolean isNationality;
        @JsonProperty("is_verified")
        private boolean isVerified;
        private Long expiry;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class DateOfBirth {
        public long date;
        public String city;
        public String country;
    }
}
