/*
 * Copyright (c) 2022. Tap Payments
 * Author: Charan Dommara
 * Created On: 4 9 2022
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiIndividualAdditionalInfo extends ApiBaseModel {
    @JsonProperty("source_income")
    public List<String> sourceOfIncome;
    @JsonProperty("actual_income")
    public String actualIncome;
    @JsonProperty("employer_name")
    public String employerName;
    @JsonProperty("employer_city")
    public String employerCity;
    @JsonProperty("employer_country")
    public String employerCountry;
    @JsonProperty("is_relative_PEP")
    public Boolean isRelativePEP;
    @JsonProperty("is_influencer")
    public Boolean isInfluencer;
    public String occupation;
    @JsonProperty("lead_id")
    public String leadId;
}
