package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBrand extends ApiBaseModel {
	@NotNull
	public ApiText name;
	@NotNull
	public List<String> sector;
	public String logo;
	public ApiContent content;
	public String website;
	public List<String> social;
	@JsonProperty("channel_services")
	public List<ApiBrand.ChannelService> channelServices;
	@JsonProperty("physical_store_available")
	public Boolean physicalStoreAvailable;
	public ApiBrand.Operation operations;
	public List<String> term;
	public ApiBrand.Terms terms;
	public List<String> branches;
	public List<String> activities;

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class ChannelService{
		public String channel;
		public String address;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Operation{
		@JsonProperty("start_date")
		public String startDate;
		public Sales sales;
		@JsonProperty("customer_base")
		public ApiBrand.CustomerBase customerRange;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Sales{
		public String period;
		public String range;
		public String currency;
		
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class CustomerBase{
		public String range;
		public String period;
		public List<String> location;
	}

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class Terms{
		public String term;
		public boolean agree;
	}
}
