package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBrand extends ApiBaseModel {
	@NotNull
	public ApiText name;
	@NotNull
	public List<String> sector;
	public String logo;
	public ApiContent content;
	public String website;
	public List<String> social;
	public List<String> branches;
	public List<String> activities;
	@JsonProperty("business_operation_start_at")
	public Date businessOperationStartAt;
	@JsonProperty("channel_services")
	public List<String> channelOfServices;
	@JsonProperty("physical_store_available")
	public Boolean physicalStoreAvailable;
	@JsonProperty("monthly_sales_range")
	public String monthlySalesRange;
	@JsonProperty("customers_served_monthly")
	public String customerServedMonthly;
	@JsonProperty("customers_base")
	public List<String> customerBase;
	@JsonProperty("agree_chargeback")
	public Boolean agreeChargeback;
	@JsonProperty("agree_refund")
	public Boolean agreeRefund;
	@JsonProperty("terms_conditions_accepted")
	public Boolean termsConditionsAccepted;
}
