package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiBankAccount extends ApiBaseModel {
    @NotEmpty(message = "Please provide a iban;")
    public String iban;
    public String account_number;
    public String swift_code;
    @JsonProperty("bank_name")
    public String bankName;
    @JsonProperty("beneficiary_name")
    public String beneficiaryName;
    @JsonProperty("bank_statement_file_id")
    public String bankStatementFileId;
    @JsonProperty("is_acknowledged")
    public Boolean isAcknowledged;
    @JsonProperty("wallet_id")
    public String walletId;
}
