/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.Constants;

public class CommonConstants {
    public static final class CaseSensitiveID {
        public static final String OPERATOR_ID = "operatorId";
        public static final String BUSINESS_ID = "businessId";
        public static final String SEGMENT_ID = "segmentId";
        public static final String PRODUCT_ID = "productId";
        public static final String LEGACY_ID = "legacyId";
    }

    public static final class Status {
        public static final String New = "New";
        public static final String NewUnderReview = "New Under Review";
        public static final String NewPendingApproval = "New Pending Approval";
        public static final String Rejected = "Rejected";
        public static final String Active = "Active";
        public static final String NotActive = "Not Active";
        public static final String Expired = "Expired";
        public static final String Suspended = "Suspended";
        public static final String Cancelled = "Cancelled";
        public static final String UpdateUnderReview = "Update Under Review";
        public static final String UpdatePendingApproval = "Update Pending Approval";
        public static final String Archive = "Archive";
        public static final String Delete = "Delete";
        public static final String Closed = "Closed";
    }
    public static class ObjectNames {
        public static String Business = "business";
        public static String BusinessAccount = "business_account";
        public static String BankAccount = "bank_account";
        public static String Branch = "branch";
        public static String Operator = "operator";
        public static String Merchant = "merchant";
        public static String Destination = "destination";
        public static String MarketPlace = "marketplace";
        public static String Developer = "developer";
        public static String Bank = "bank";
        public static String Acqurier = "acqurier";
        public static String Issuer = "issuer";
        public static String PaymentGateway = "payment_gateway";
        public static String Scheme = "scheme";
        public static String Platform = "platform";
        public static String Processor = "processor";
        public static String Psp = "payment_service_provider";
        public static String Switch = "switch";
        public static String Apm = "alternative_paymentMethod";
        public static String Accounting = "accounting";
        public static String Marketing = "marketing";
        public static String Legal = "legal";
        public static String Facilitator = "facilitator";
        public static String Aggregator = "aggregator";
        public static String Brand = "brand";
        public static String Entity = "entity";
        public static String User = "user";
    }
}
