package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({"status", "auth_token", "auth_type", "data_token", "auth_session", "device_token", "lead_id",
        "connections"})
public class ApiAuth {

    /**
     * dataToken - can contain email mobile and authType data encrypted using RSA
     * authToken - returned and accepted authSession - on success session will be
     * returned authType - type of authentication success - Auth status
     */

    @JsonProperty("data_token")
    public String dataToken;

    @JsonProperty("auth_token")
    public String authToken;

    @JsonProperty("auth_session")
    public String authSession;

    @JsonProperty("auth_type")
    public Integer authType;

    public String status;

    @JsonProperty("lead_id")
    public String leadId;

    public ApiConnections connections;

    @JsonProperty("device_info")
    public ApiDevice deviceInfo;

    @JsonProperty("device_token")
    public String deviceToken;

    @JsonProperty("remember_me")
    public Boolean rememberMe;

    @JsonProperty("keepme_signedin")
    public Boolean keepMeSignedIn;

    @JsonProperty("new_user")
    public Boolean newUser;

    @JsonProperty("scopes")
    public List<String> scopes;

    @JsonProperty("api_credentials")
    public goLoginApiKeys apiCredentials;

    @JsonProperty("signup_token")
    public String signupToken;

    @JsonProperty("sign_in")
    public boolean signIn = true;

    @JsonProperty("individual_id")
    public String individualId;

    @JsonProperty("individual_country_code")
    public String individualCountryCode;

    @JsonProperty("is_tap_user")
    public Boolean isTapUser;

}
