/*
 * Copyright (c) 2022. Tap Payments
 * Author: Charan Dommara
 * Created On: 31 8 2022
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;


@Data
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiIndividualType {

	@NotNull
	@JsonProperty("business_id")
	public String businessId;

	@NotNull
	public ApiIndividualEntity entity;

	public List<String> brands;

	public ApiGlobalUser contact_person;

	public int type;

	/**
	 * Used for segment user and developer
	 */
	
	@JsonProperty("segment_id")
	public String segmentId;
	
	@JsonProperty("user_id")
	public String userId;
	
	@JsonProperty("developer_id")
	public String developerId;

	@Data
	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	public static class ApiIndividualEntity {

		@JsonProperty("id")
		public String Id;

		public List<String> branches;

		// entity info to create operator for user

		@JsonIgnore
		public String operatorId;
		@JsonIgnore
		public String walletId;
		@JsonIgnore
		public String legacyId;
		@JsonIgnore
		public String accessToken;
	}
}
