package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

@Data
@NoArgsConstructor
@JsonPropertyOrder({"id", "status", "created", "legal_name", "country", "type", "not_for_profit", "is_licensed", "license",
        "capital", "relations", "taxable", "tax_number", "settlement", "settlement_by", "documents", "wallets", "branches",
        "bank_account", "billing_address"})
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiEntity extends ApiBaseModel {

    @NotNull
    @JsonProperty("legal_name")
    public ApiText legalName;
    @JsonProperty("is_licensed")
    public boolean is_licensed;
    @JsonProperty("license_number")
    public String licenseNumber;
    public ApiLicense license;
    @JsonProperty("not_for_profit")
    public boolean not_for_profit;
    @NotNull
    public String country;
    public String type;
    @JsonProperty("currency_code")
    public String currencyCode;
    @JsonProperty("taxable")
    public boolean taxable;
    @JsonProperty("tax_number")
    public String taxNumber;
    @JsonProperty("settlement_by")
    public String settlementBy;
    public ApiSettlement settlement; //Added on 27OCT
    public List<ApiDocuments> documents;
    public List<ApiWallet> wallets;
    public List<ApiBranch> branches;
    @JsonProperty("bank_account")
    public ApiBankAccount bankAccount; //Added on 07OCT as goSell create account requires iban
    public ApiOperator operator; // Added to return default operator
    @JsonProperty("bank_accounts")
    public List<ApiBankAccount> bankAccounts;
    @JsonProperty("billing_address")
    public ApiAddress billingAddress;
    @JsonProperty("capital")
    public ApiEntityCapital capital;
    public List<Relations> relations;

    @Data
    @JsonPropertyOrder({"relation_id","name", "source","source_id","is_external"})
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Relations {
        @JsonProperty("relation_id")
        public String relationId;
        @JsonProperty("name")
        public Map<String, String> name;
        @JsonProperty("source")
        public String source;
        @JsonProperty("source_id")
        public String sourceId;
        @JsonProperty("is_external")
        public Boolean isExternal;
    }
}
