package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiShipment extends ApiBaseModel {
    @JsonProperty("order_id")
    public String orderId;
    @JsonProperty("customer_id")
    public String customerId;
    public String currency;
    public Double amount;
    public ApiText description;
    public ApiAddress address;
    @JsonProperty("merchant_id")
    public String merchantId;
    public Carrier carrier;

    @Data
    @EqualsAndHashCode(callSuper = true)
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Carrier extends ApiBaseModel{
        public String name;
        public String service;
        public String reference;
        public List<Log> logs;
    }
    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Log {
        public String status;
        public long created;
    }
}
