package company.tap.commondependencies.Cipher;

import org.apache.tomcat.util.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.spec.KeySpec;
import java.util.Arrays;


public class DataCipherAES256 {

    private static final String ENCRYPT_ALGO = "AES/GCM/NoPadding";

    private static final int TAG_LENGTH_BIT = 128; // must be one of {128, 120, 112, 104, 96}
    private static final int IV_LENGTH_BYTE = 12;
    private static final int SALT_LENGTH_BYTE = 16;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static byte[] salt;
    private static byte[] iv;


    // 16 bytes salt
    // GCM recommended 12 bytes iv?
    // Initialization vector.
    // It could be any value or generated using a random number generator.
    private static void init(String UniqueKey)  {
        salt = Arrays.copyOf(UniqueKey.getBytes(StandardCharsets.UTF_16BE), SALT_LENGTH_BYTE);
        iv = Arrays.copyOf(UniqueKey.getBytes(StandardCharsets.UTF_16BE), IV_LENGTH_BYTE);
    }

    private static Cipher cipherInstance(String UniqueKey, int opMode) throws Exception {
        UniqueKey = Base64.encodeBase64String(UniqueKey.getBytes(StandardCharsets.UTF_8));
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");

        KeySpec spec = new PBEKeySpec(UniqueKey.toCharArray(), salt, 65536, 256);
        SecretKey secretKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");

        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);

        cipher.init(opMode, secretKey, new GCMParameterSpec(TAG_LENGTH_BIT, iv));
        return cipher;
    }

    // return a base64 encoded AES encrypted text
    public static String encrypt(String uniqueKey, String data) throws Exception {
        init(uniqueKey);
        Cipher cipher = cipherInstance(uniqueKey, Cipher.ENCRYPT_MODE);

        byte[] cipherText = cipher.doFinal(data.getBytes());

        return URLEncoder.encode(Base64.encodeBase64String(cipherText), StandardCharsets.UTF_8);

    }

    // we need the same password, salt and iv to decrypt it
    public static String decrypt(String uniqueKey, String encryptedMessage) throws Exception {
        byte[] DecodedMessage = Base64.decodeBase64(URLDecoder.decode(encryptedMessage, StandardCharsets.UTF_8));
        init(uniqueKey);

        Cipher cipher = cipherInstance(uniqueKey, Cipher.DECRYPT_MODE);

        byte[] plainText = cipher.doFinal(DecodedMessage);

        return new String(plainText, UTF_8);

    }

}
