/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ISO8583.interfaces;

import company.tap.commondependencies.ISO8583.enums.ProcessCodes;
import company.tap.commondependencies.ISO8583.exceptions.ISOException;

public interface ProcessCode<T> {
    DataElement<T> processCode(String code) throws ISOException;

    DataElement<T> processCode(ProcessCodes.TTC_100 ttc) throws ISOException;

    DataElement<T> processCode(ProcessCodes.TTC_100 ttc, ProcessCodes.ATC atcFrom, ProcessCodes.ATC atcTo) throws ISOException;

    DataElement<T> processCode(ProcessCodes.TTC_200 ttc) throws ISOException;

    DataElement<T> processCode(ProcessCodes.TTC_200 ttc, ProcessCodes.ATC atcFrom, ProcessCodes.ATC atcTo) throws ISOException;
}

