package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.HashMap;

@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiProduct extends ApiBaseModel {
    public ApiText name;
    public ApiText description;
    public String currency;
    public Double amount;
    public String inventory;
    public String image;
    public ProdReference reference;
    public Dimensions dimensions;
    public Business business;
    @JsonProperty("item_code")
    public String itemCode;
    @JsonProperty("account_code")
    public String accountCode;
    public String category;
    public HashMap<String, String> metadata;

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public class Dimensions {
        public String weight_type;
        public Double weight;
        public String measurements;
        public Integer length;
        public Integer width;
        public Integer height;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class ProdReference {
        @JsonProperty("SKU")
        public String SKU;
        @JsonProperty("GTIN")
        public String GTIN;
        public String platform;
    }

    @Data
    @NoArgsConstructor
    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public static class Business {
        public String id;
        @JsonProperty("entity_id")
        public String entityId;
        @JsonProperty("brand_id")
        public String brandId;
    }
}

