/*
 *
 *  * Copyright (c) 2021. Tap Payments
 *  * @author <a href="mailto:c.dommara@tap.company">Charan Dommara</a>
 *  * Created On: 21 1 2021
 *
 */

package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

@Data
@NoArgsConstructor
@JsonPropertyOrder({"paid", "subscribed", "announced", "shares"})
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class ApiEntityCapital {
    public String paid;
    public String subscribed;
    public String announced;
    public Map<String, Double> shares;
}
