package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

import java.util.List;

@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(allowSetters = true, allowGetters = false, ignoreUnknown = true)
public class ApiDevice {
	public String source;
	public Device device;
	public Browser browser;
	public App app;
	public Connection connection;
	public Entry entry;
	@JsonProperty("ip_info")
	public IpObject ipObject;

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public static class Device {
		public String name;
		public String type;
		public String brand;
		public String model;
		public os os;

		@NoArgsConstructor
		@JsonInclude(value = JsonInclude.Include.NON_NULL)
		@JsonIgnoreProperties(ignoreUnknown = true)
		public static class os {
			public String name;
			public String version;
		}

	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public static class Browser {
		public String name;
		public String brand;
		public String version;
		@JsonProperty("user_agent")
		public String userAgent;
		@JsonProperty("browser_id")
		public String browserId;
	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public static class App {
		public String identifier;
		public String name;
		public String version;
		public String requirer;
		@JsonProperty("requirer_version")
		public String requirerVersion;
		@JsonProperty("app_locale")
		public String appLocale;
		@JsonProperty("sdk_version")
		public String sdkVersion;
		@JsonProperty("requirer_sim_network_name")
		public String requirerSimNetworkName;
		@JsonProperty("requirer_sim_country_iso")
		public String requirerSimCountryIso;
		@JsonProperty("universal_id")
		public String universalId;
	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public static class Connection {
		public String ip;
		public String mac;
	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public static class Entry {
		public String name;
		@JsonProperty("interface")
		public String Interface;
		public String type;
		public String version;

	}


	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public static class IpObject {
		public String ip;
		public String type;
		@JsonProperty("continent_code")
		public String continentCode;
		@JsonProperty("continent_name")
		public String continentName;
		@JsonProperty("country_code")
		public String countryCode;
		@JsonProperty("country_name")
		public String countryName;
		@JsonProperty("region_code")
		public String regionCode;
		@JsonProperty("region_name")
		public String regionName;
		public String city;
		public String zip;
		public String latitude;
		public String longitude;
		public Location location;
		@JsonProperty("time_zone")
		public TimeZone timeZone;
		public Currency currency;
		public Connection connection;

		@NoArgsConstructor
		@JsonInclude(value = JsonInclude.Include.NON_NULL)
		@JsonIgnoreProperties(ignoreUnknown = true)
		public static class Location {
			@JsonProperty("geoname_id")
			public String geonameId;
			public String capital;
			public List<Language> languages;
			@JsonProperty("country_flag")
			public String countryFlag;
			@JsonProperty("country_flag_emoji")
			public String countryFlagEmoji;
			@JsonProperty("country_flag_emoji_unicode")
			public String countryFlagEmojiUnicode;
			@JsonProperty("calling_code")
			public String callingCode;
			@JsonProperty("is_eu")
			public Boolean isEu;

			@NoArgsConstructor
			@JsonInclude(value = JsonInclude.Include.NON_NULL)
			@JsonIgnoreProperties(ignoreUnknown = true)
			public static class Language {
				public String code;
				public String name;
				@JsonProperty("native")
				public String native_;
			}

		}

		@NoArgsConstructor
		@JsonInclude(value = JsonInclude.Include.NON_NULL)
		@JsonIgnoreProperties(ignoreUnknown = true)
		public static class TimeZone {
			public String id;
			@JsonProperty("current_time")
			public String currentTime;
			@JsonProperty("gmt_offset")
			public String gmtOffset;
			public String code;
			@JsonProperty("is_daylight_saving")
			public String isDaylightSaving;
		}

		@NoArgsConstructor
		@JsonInclude(value = JsonInclude.Include.NON_NULL)
		@JsonIgnoreProperties(ignoreUnknown = true)
		public static class Currency {
			public String code;
			public String name;
			public String plural;
			public String symbol;
			@JsonProperty("symbol_native")
			public String symbolNative;
		}

		@NoArgsConstructor
		@JsonInclude(value = JsonInclude.Include.NON_NULL)
		@JsonIgnoreProperties(ignoreUnknown = true)
		public static class Connection {
			public String asn;
			public String isp;
		}
	}
}
