package company.tap.commondependencies.ApiModels;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NoArgsConstructor;

@NoArgsConstructor
@JsonInclude(value = JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(allowSetters = true, allowGetters = false, ignoreUnknown = true)
public class ApiDevice {

	public String source;

	public Device device;

	public Browser browser;

	public App app;

	public Connection connection;

	public Entry entry;

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public class Device {

		public String name;

		public String type;

		public String brand;

		public String model;

		public os os;

		@NoArgsConstructor
		@JsonInclude(value = JsonInclude.Include.NON_NULL)
		@JsonIgnoreProperties(ignoreUnknown = true)
		public class os {
			public String name;
			public String version;
		}

	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public class Browser {
		public String name;
		public String version;
		@JsonProperty("user_agent")
		public String userAgent;
		@JsonProperty("browser_id")
		public String browserId;
	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public class App {
		public String identifier;
		public String name;
		public String version;
		public String requirer;
		@JsonProperty("requirer_version")
		public String requirerVersion;
		@JsonProperty("app_locale")
		public String appLocale;
		@JsonProperty("sdk_version")
		public String sdkVersion;
		@JsonProperty("requirer_sim_network_name")
		public String requirerSimNetworkName;
		@JsonProperty("requirer_sim_country_iso")
		public String requirerSimCountryIso;
		@JsonProperty("universal_id")
		public String universalId;
	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public class Connection {
		public String ip;
		public String mac;
	}

	@NoArgsConstructor
	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonIgnoreProperties(ignoreUnknown = true)
	public class Entry {
		public String name;
		@JsonProperty("interface")
		public String Interface;
		public String type;
		public String version;

	}

}
