package company.tap.commondependencies.Operator;

import company.tap.commondependencies.Errors.Errors;
import company.tap.commondependencies.Errors.IErrorServices;
import company.tap.commondependencies.Helpers.DataUtilities;
import company.tap.commondependencies.Helpers.RestAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.*;
import org.springframework.stereotype.Service;

import static org.springframework.http.MediaType.APPLICATION_JSON;

@Service
class OperatorService implements IOperatorService {
    /*
        Author - Charan Dommara
        Created On - 02 SEP 202
        The class is used to retrieve operator info and validate operator
    */
    private static final Logger logger = LogManager.getLogger(OperatorService.class);
    private final String tapApiUrl = DataUtilities.getInstance().getUrlTapApiV2();
    final
    IErrorServices _errorServices;

    public OperatorService(IErrorServices _errorServices) {
        this._errorServices = _errorServices;
    }

    @Override
    public PrivateOperator GetOperatorInfoByKey(String key) {
        try {
            HttpHeaders headersCA = new HttpHeaders();
            headersCA.setContentType(APPLICATION_JSON);
            headersCA.set("Authorization", "Bearer " + key);
            HttpEntity<String> entityToken = new HttpEntity<>(headersCA);
            return RestAPI.getInstance()
                    .exchange(tapApiUrl + "operator/private/info", HttpMethod.GET, entityToken, PrivateOperator.class)
                    .getBody();

        } catch (Exception e) {
            logger.info("----- GetOperatorInfoByKey Error -----");
            e.printStackTrace();
            logger.error(e);
            return null;
        }
    }

    @Override
    public ResponseEntity<Object> ValidateOperatorByKey(String key, boolean tap, boolean isMerchant) {
        try {
            PrivateOperator operator = GetOperatorInfoByKey(key);
            if (operator == null) {
                return _errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString()
                        , "Api " +
                                "key is unauthorized to perform the operation", HttpStatus.UNAUTHORIZED);
            }
            if (!operator.getStatus().equalsIgnoreCase(DataUtilities.getInstance().getStatusActive())) {
                return _errorServices.Error(Errors.InActive_Id.getCode(), Errors.InActive_Id.toString(), "Api " +
                        "key is unauthorized to perform the operation, Operator InActive", HttpStatus.UNAUTHORIZED);
            }
            if (tap && !operator.legacyId.equals("1300")) {
                return _errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString(),
                        "Api " +
                                "key is unauthorized to perform the operation", HttpStatus.UNAUTHORIZED);
            }
            if (isMerchant && !operator.isMerchant) {
                return _errorServices.Error(Errors.Api_key_unauthorised.getCode(), Errors.Api_key_unauthorised.toString(),
                        "Api " +
                                "key is unauthorized to perform the operation", HttpStatus.UNAUTHORIZED);
            }
            return null;
        }
        catch (Exception e){
            logger.info("----- ValidateOperatorByKey Error -----");
            e.printStackTrace();
            logger.error(e);
            return _errorServices.Error(Errors.Internal_server_error.getCode(), Errors.Internal_server_error.toString(),
                    "Failed to validate the key", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}
