package company.tap.commondependencies.Helpers;

import lombok.Getter;

@Getter
public class DataUtilities {

	/**
	 * 
	 */
	// singleton instance declaration
	private static DataUtilities shared;

	// making constructor private so that no other class could use the default
	// constructor
	private DataUtilities() {
	}

	// the method which gives access to the only instance of ApiClientReqLib, is
	// thread safe
	public static synchronized DataUtilities getInstance() {
		if (shared == null) {
			shared = new DataUtilities();
		}
		return shared;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	private final String statusPending = "pending";

	private final String statusSuccess = "success";

	private final String statusActive = "active";

	private final String statusValid = "valid";

	private final String statusAlreadyTaken = "already_taken";
	
	private final String statusVerified = "verified";
	
	private final String statusFailed = "failed";

	private final String statusArchive= "archive";

	private final String urlCommonUtilities = "https://utilities.tap.company/api/v1/";
}
