/*
 * Decompiled with CFR 0.152.
 */
package company.hnlz.sendmessage.service.impl;

import company.hnlz.sendmessage.service.ICallBack;
import company.hnlz.sendmessage.service.ISendMessageUtil;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageUtilImpl
implements ISendMessageUtil,
SerialPortEventListener {
    private static final String SMS_SUCESS = "SMS_SEND_SUCESS";
    private static final String SMS_FAIL = "SMS_SEND_FAIL";
    private static final String SMS_RETURN = "CMS";
    private static CommPortIdentifier portId;
    private static Enumeration portList;
    private InputStream inputStream;
    private OutputStream outputStream;
    private SerialPort serialPort;
    private boolean initResult;
    private boolean initFlag;
    private LinkedBlockingQueue<String> sendMessageQueue = new LinkedBlockingQueue();
    private ICallBack callBack;
    private String phoneNumber;
    private String messageContent;
    private Integer sleepTime;
    private static volatile SendMessageUtilImpl sendMessageUtil;

    private SendMessageUtilImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SendMessageUtilImpl getSingleton() {
        if (sendMessageUtil != null) return sendMessageUtil;
        Class<SendMessageUtilImpl> clazz = SendMessageUtilImpl.class;
        synchronized (SendMessageUtilImpl.class) {
            if (sendMessageUtil != null) return sendMessageUtil;
            sendMessageUtil = new SendMessageUtilImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sendMessageUtil;
        }
    }

    @Override
    public boolean init(String serialPortName, String sleepTime) {
        if (!this.initFlag) {
            this.sleepTime = Integer.parseInt(sleepTime);
            portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || !portId.getName().equals(serialPortName)) continue;
                System.out.println(serialPortName);
                try {
                    this.serialPort = (SerialPort)portId.open(this.getClass().getSimpleName(), 2000);
                    this.serialPort.addEventListener((SerialPortEventListener)this);
                    this.serialPort.notifyOnDataAvailable(true);
                    this.serialPort.setSerialPortParams(9600, 8, 1, 0);
                    this.inputStream = this.serialPort.getInputStream();
                    this.outputStream = this.serialPort.getOutputStream();
                    this.initResult = true;
                    this.addThread();
                    this.initFlag = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(serialPortName + " SerialPort is open fail.");
                    this.initResult = false;
                }
                System.out.println(serialPortName + " SerialPort is open.");
            }
        }
        return this.initResult;
    }

    private void addThread() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                Iterator iterator = SendMessageUtilImpl.this.sendMessageQueue.iterator();
                while (iterator.hasNext()) {
                    String splitSendContent = (String)SendMessageUtilImpl.this.sendMessageQueue.poll();
                    if (splitSendContent == null) continue;
                    boolean result = SendMessageUtilImpl.this.sendMessage(splitSendContent);
                    String[] sendParameter = splitSendContent.split(":", -1);
                    SendMessageUtilImpl.this.phoneNumber = sendParameter[0];
                    SendMessageUtilImpl.this.messageContent = sendParameter[2];
                    SendMessageUtilImpl.this.callBack.call(SendMessageUtilImpl.this.phoneNumber, SendMessageUtilImpl.this.messageContent, result);
                }
            }
        }, 0L, 1000L);
    }

    @Override
    public void send(List<String> phoneNumberList, List<String> messageContentList, ICallBack callBack) {
        this.judgeListIsOneOrManyAndAddArgToQueue(phoneNumberList, messageContentList);
        this.callBack = callBack;
    }

    private void closeResources() {
        try {
            if (this.serialPort != null) {
                this.serialPort.notifyOnDataAvailable(false);
                this.serialPort.removeEventListener();
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                this.serialPort.close();
                this.serialPort = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void judgeListIsOneOrManyAndAddArgToQueue(List<String> phoneNumberList, List<String> messageContentList) {
        String formatParameter;
        String messageContent;
        String phoneNumber;
        if (phoneNumberList.size() == 1 && messageContentList.size() == 1) {
            phoneNumber = phoneNumberList.get(0);
            messageContent = messageContentList.get(0);
            formatParameter = phoneNumber + ":0:" + messageContent;
            this.sendMessageQueue.add(formatParameter);
        }
        if (phoneNumberList.size() == 1 && messageContentList.size() > 1) {
            phoneNumber = phoneNumberList.get(0);
            for (String message : messageContentList) {
                formatParameter = phoneNumber + ":0:" + message;
                this.sendMessageQueue.add(formatParameter);
            }
        }
        if (phoneNumberList.size() > 1 && messageContentList.size() == 1) {
            messageContent = messageContentList.get(0);
            for (String phoneNum : phoneNumberList) {
                formatParameter = phoneNum + ":0:" + messageContent;
                this.sendMessageQueue.add(formatParameter);
            }
        }
        if (phoneNumberList.size() > 1 && messageContentList.size() > 1) {
            for (String phoneNum : phoneNumberList) {
                for (String message : messageContentList) {
                    formatParameter = phoneNum + ":0:" + message;
                    this.sendMessageQueue.add(formatParameter);
                }
            }
        }
    }

    private boolean sendMessage(String splitSendContent) {
        boolean result = false;
        try {
            this.sendDataBySerialPort(splitSendContent);
            result = true;
            System.out.println(splitSendContent + ":" + new Date());
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    private void sendDataBySerialPort(String splitSendContent) {
        try {
            this.outputStream.write(splitSendContent.getBytes("GBK"), 0, splitSendContent.getBytes("GBK").length);
            this.outputStream.flush();
            System.out.println("Message had send.");
            Thread.sleep(this.sleepTime.intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        this.getSendResultByInputSream();
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSendResultByInputSream() {
        byte[] readBuffer = new byte[1024];
        int readBufferLength = 0;
        String readStringBuffer = null;
        try {
            readBufferLength = this.inputStream.read(readBuffer);
            readStringBuffer = new String(readBuffer, 0, readBufferLength - 4).trim();
            if (readStringBuffer.equals(SMS_SUCESS)) {
                System.out.println("Send sucess\uff01");
            }
            if (readStringBuffer.equals(SMS_FAIL)) {
                System.out.println("Send failed\uff01");
            }
            if (!readStringBuffer.contains(SMS_RETURN)) return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

