package community.flock.kotlinx.rgxgen.model

import community.flock.kotlinx.rgxgen.parsing.dflt.ConstantsProvider
import community.flock.kotlinx.rgxgen.util.Util
import kotlin.jvm.JvmField

/* **************************************************************************
  Copyright 2019 Vladislavs Varslavans

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
/ * **************************************************************************/

enum class UnicodeCategory(
    @JvmField val keys: List<String>,
    @JvmField val description: String,
    @JvmField val symbolRanges: List<SymbolRange>,
    @JvmField vararg val symbols: Char
) {
    /**
     * The configuration is based on [...](https://www.regular-expressions.info/unicode.html#category)
     */
    ANY_LETTER(
        keys("L", "Letter"),
        "Any kind of letter from any language",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_UPPERCASE_LATIN_ALPHABET,
            UnicodeCategoryConstants.BASIC_LATIN_LOWERCASE_LATIN_ALPHABET,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LETTERS,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_UPPERCASE_LETTERS_TO_LOWERCASE_LETTERS,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_TO_SPACING_MODIFIER_LETTERS,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_SUBSET_1,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_ADDITIONS_BASED_ON_1989_IPA_SUBSET,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_ARCHAIC_LETTERS_TO_ARCHAIC_LETTERS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_ARCHAIC_LETTERS_SUBSET,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_IOTA_SUBSCRIPT_TO_LOWERCASE_OF_EDITORIAL_SYMBOLS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET_2,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_TO_VARIANT_LETTERFORMS_AND_SYMBOLS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_TO_CYRILLIC,
            UnicodeCategoryConstants.CYRILLIC_TO_CYRILLIC_SUPPLEMENT,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_UPPERCASE_LETTERS_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_LOWERCASE_LETTERS,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_BASED_ON_ISO_8859_8_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_SIGN_TO_YIDDISH_DIGRAPHS,
            UnicodeCategoryConstants.ARABIC_ADDITION_FOR_KASHMIRI_TO_BASED_ON_ISO_8859_6,
            UnicodeCategoryConstants.ARABIC_ARCHAIC_LETTERS,
            UnicodeCategoryConstants.ARABIC_EXTENDED_ARABIC_LETTERS_TO_EXTENDED_ARABIC_LETTERS,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.ARABIC_EXTENDED_ARABIC_LETTERS_FOR_PARKARI,
            UnicodeCategoryConstants.ARABIC_EXTENDED_ARABIC_LETTERS_2,
            UnicodeCategoryConstants.SYRIAC_SYRIAC_LETTERS_TO_PERSIAN_LETTERS,
            UnicodeCategoryConstants.SYRIAC_TO_THAANA,
            UnicodeCategoryConstants.NKO_LETTERS_TO_ARCHAIC_LETTERS,
            UnicodeCategoryConstants.NKO_TONAL_APOSTROPHES,
            UnicodeCategoryConstants.SAMARITAN_LETTERS,
            UnicodeCategoryConstants.MANDAIC_LETTERS,
            UnicodeCategoryConstants.SYRIAC_SUPPLEMENT_SYRIAC_LETTERS_SUBSET,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_ARABIC_LETTERS_FOR_AFRICAN_LANGUAGES_TO_ARABIC_LETTERS_FOR_ARWI,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_ARABIC_LETTERS_FOR_BRAVANESE_TO_ARABIC_LETTERS_FOR_HAUSA_WOLOF_AND_OTHER_AFRICAN_ORTHOGRAPHIES,
            UnicodeCategoryConstants.DEVANAGARI_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.DEVANAGARI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.DEVANAGARI_ADDITIONAL_SIGNS_TO_SINDHI_IMPLOSIVES,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_4,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_15,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.BENGALI_ADDITIONS_FOR_ASSAMESE,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_1,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_10,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_12,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_16,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.BENGALI_VOWEL_BASES_TO_VOWEL_BASES,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_4,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_9,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_2,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_9,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_13,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_3,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_8,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_3,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_11,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_14,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT_1,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_3,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_8,
            UnicodeCategoryConstants.TELUGU_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.TELUGU_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.TELUGU_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TELUGU_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.TELUGU_HISTORIC_PHONETIC_VARIANTS_SUBSET,
            UnicodeCategoryConstants.TELUGU_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.KANNADA_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.KANNADA_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.KANNADA_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.KANNADA_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.KANNADA_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.KANNADA_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.KANNADA_SIGNS_USED_IN_SANSKRIT_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.MALAYALAM_ADDITIONAL_HISTORIC_CHILLU_LETTERS,
            UnicodeCategoryConstants.MALAYALAM_ADDITIONAL_HISTORIC_VOWEL_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.MALAYALAM_CHILLU_LETTERS,
            UnicodeCategoryConstants.MALAYALAM_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_4,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_5,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_TO_SIGN,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_TO_VOWEL_LENGTH_SIGN,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_3,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_TO_SIGN_1,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_DIGRAPHS_TO_CONSONANTS_FOR_KHMU,
            UnicodeCategoryConstants.TIBETAN_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_CONSONANTS_TO_EXTENSIONS_FOR_BALTI,
            UnicodeCategoryConstants.TIBETAN_TRANSLITERATION_HEAD_LETTERS,
            UnicodeCategoryConstants.MYANMAR_CONSONANTS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_MON_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_WESTERN_PWO_KAREN_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_EASTERN_PWO_KAREN,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_4,
            UnicodeCategoryConstants.GEORGIAN_CAPITAL_LETTERS_KHUTSURI_SUBSET,
            UnicodeCategoryConstants.GEORGIAN_MKHEDRULI_TO_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.GEORGIAN_TO_ETHIOPIC,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_3,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_4,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_9,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_10,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_5,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_11,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_12,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_1,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_7,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_6,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_8,
            UnicodeCategoryConstants.ETHIOPIC_SUPPLEMENT_SYLLABLES_FOR_SEBATBEIT,
            UnicodeCategoryConstants.CHEROKEE_UPPERCASE_SYLLABLES_TO_UPPERCASE_SYLLABLES,
            UnicodeCategoryConstants.CHEROKEE_LOWERCASE_SYLLABLES_TO_LOWERCASE_SYLLABLES,
            UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_SYLLABLES_TO_SYLLABLES_FOR_CARRIER,
            UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_SYLLABLES_1,
            UnicodeCategoryConstants.OGHAM_TRADITIONAL_LETTERS_TO_FORFEDA_SUPPLEMENTARY_LETTERS,
            UnicodeCategoryConstants.RUNIC_LETTERS,
            UnicodeCategoryConstants.RUNIC_TOLKIENIAN_EXTENSIONS_TO_CRYPTOGRAMMIC_LETTERS,
            UnicodeCategoryConstants.TAGALOG_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TAGALOG_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.HANUNOO_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.BUHID_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TAGBANWA_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TAGBANWA_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.KHMER_CONSONANTS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.MONGOLIAN_BASIC_LETTERS_TO_MANCHU_LETTERS,
            UnicodeCategoryConstants.MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET_2,
            UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_SYLLABLES_FOR_MOOSE_CREE_TO_FINALS_FOR_DENE_AND_CARRIER,
            UnicodeCategoryConstants.LIMBU_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.TAI_LE_CONSONANTS_TO_VOWELS,
            UnicodeCategoryConstants.TAI_LE_TONE_LETTERS_SUBSET,
            UnicodeCategoryConstants.NEW_TAI_LUE_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.NEW_TAI_LUE_VOWEL_SIGNS_TO_TONE_MARKS,
            UnicodeCategoryConstants.BUGINESE_CONSONANTS,
            UnicodeCategoryConstants.TAI_THAM_CONSONANTS_TO_CONSONANTS,
            UnicodeCategoryConstants.BALINESE_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.BALINESE_ADDITIONAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.SUNDANESE_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.SUNDANESE_ADDITIONAL_CONSONANTS,
            UnicodeCategoryConstants.SUNDANESE_TO_BATAK,
            UnicodeCategoryConstants.LEPCHA_CONSONANTS,
            UnicodeCategoryConstants.LEPCHA_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.OL_CHIKI_LETTERS_TO_MODIFIER_LETTERS,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_C_HISTORIC_LETTER_VARIANTS_SUBSET,
            UnicodeCategoryConstants.GEORGIAN_EXTENDED_CAPITAL_LETTERS_MTAVRULI_TO_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.GEORGIAN_EXTENDED_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_NASALIZATION_SIGNS_SUBSET,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_NASALIZATION_SIGNS_TO_ARDHAVISARGA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_SIGNS_SUBSET,
            UnicodeCategoryConstants.PHONETIC_EXTENSIONS_TO_PHONETIC_EXTENSIONS_SUPPLEMENT,
            UnicodeCategoryConstants.LATIN_EXTENDED_ADDITIONAL_TO_GREEK_EXTENDED,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_19,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_27,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_9,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_12,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_21,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_2,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_39,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_3,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_5,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_11,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_16,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_26,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_36,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_40,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_TO_SUBSCRIPTS_FOR_UPA,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_3,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_9,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_11,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_TO_HEBREW_LETTERLIKE_MATH_SYMBOLS,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_3,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_ITALIC_MATH_SYMBOLS,
            UnicodeCategoryConstants.NUMBER_FORMS_ARCHAIC_ROMAN_NUMERALS_TO_ARCHAIC_ROMAN_NUMERALS,
            UnicodeCategoryConstants.GLAGOLITIC_CAPITAL_LETTERS_SUBSET,
            UnicodeCategoryConstants.GLAGOLITIC_SMALL_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_TO_COPTIC,
            UnicodeCategoryConstants.COPTIC_CRYPTOGRAMMIC_LETTERS,
            UnicodeCategoryConstants.COPTIC_BOHAIRIC_COPTIC_LETTERS_SUBSET,
            UnicodeCategoryConstants.GEORGIAN_SUPPLEMENT_SMALL_LETTERS_KHUTSURI_SUBSET,
            UnicodeCategoryConstants.TIFINAGH_LETTERS_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_MEEN_TO_SYLLABLES_FOR_BLIN,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_1,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_3,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_1,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_3,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_SUBSET_1,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_KANA_REPEAT_MARKS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_OTHER_CJK_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_HIRAGANA_LETTERS_TO_SMALL_LETTERS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_ITERATION_MARKS_TO_ITERATION_MARKS,
            UnicodeCategoryConstants.KATAKANA_KATAKANA_LETTERS,
            UnicodeCategoryConstants.KATAKANA_CONJUNCTION_AND_LENGTH_MARKS_TO_ITERATION_MARKS_1,
            UnicodeCategoryConstants.KATAKANA_BASED_ON_GB_2312_TO_MISCELLANEOUS_ADDITIONS,
            UnicodeCategoryConstants.KATAKANA_CONSONANT_LETTERS_TO_OLD_VOWEL_LETTERS,
            UnicodeCategoryConstants.BOPOMOFO_EXTENDED_EXTENDED_BOPOMOFO_FOR_MINNAN_AND_HAKKA_TO_EXTENDED_BOPOMOFO_FOR_CANTONESE,
            UnicodeCategoryConstants.KATAKANA_PHONETIC_EXTENSIONS_PHONETIC_EXTENSIONS_FOR_AINU,
            UnicodeCategoryConstants.CJK_COMPATIBILITY_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A,
            UnicodeCategoryConstants.YIJING_HEXAGRAM_SYMBOLS_CJK_UNIFIED_IDEOGRAPHS_SUBSET,
            UnicodeCategoryConstants.YI_SYLLABLES_SYLLABLES_TO_SYLLABLES,
            UnicodeCategoryConstants.LISU_CONSONANTS_TO_TONES,
            UnicodeCategoryConstants.VAI_SYLLABLES_IN__EE_TO_SYLLABLE_FINALS,
            UnicodeCategoryConstants.VAI_HISTORIC_SYLLABLES_TO_LOGOGRAMS,
            UnicodeCategoryConstants.VAI_HISTORIC_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_LETTERS_FOR_OLD_CYRILLIC,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_MODIFIER_LETTER_TO_INTONATION_MARKS_FOR_LITHUANIAN_DIALECTOLOGY,
            UnicodeCategoryConstants.BAMUM_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.MODIFIER_TONE_LETTERS_CHINANTEC_TONE_MARKS_TO_AFRICANIST_TONE_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_EGYPTOLOGICAL_ADDITIONS_TO_INSULAR_AND_CELTICIST_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ORTHOGRAPHIC_LETTERS_FOR_GLOTTALS_TO_LETTERS_FOR_UGARITIC_AND_EGYPTOLOGICAL_TRANSLITERATION,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ADDITIONAL_MEDIEVAL_LETTERS_TO_ADDITIONAL_LETTERS_FOR_GAULISH,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_TO_SYLOTI_NAGRI,
            UnicodeCategoryConstants.SYLOTI_NAGRI_INDEPENDENT_VOWELS_AND_DVISVARA_SUBSET,
            UnicodeCategoryConstants.SYLOTI_NAGRI_CONSONANTS_AND_CONSONANT_SIGNS_SUBSET,
            UnicodeCategoryConstants.SYLOTI_NAGRI_CONSONANTS_AND_CONSONANT_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.PHAGS_PA_CONSONANTS_TO_CONSONANT_ADDITION_FOR_TIBETAN,
            UnicodeCategoryConstants.SAURASHTRA_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_MARKS_OF_NASALIZATION,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_SIGNS_TO_SIGNS,
            UnicodeCategoryConstants.KAYAH_LI_CONSONANTS_TO_VOWELS,
            UnicodeCategoryConstants.REJANG_CONSONANTS,
            UnicodeCategoryConstants.HANGUL_JAMO_EXTENDED_A_OLD_INITIAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.JAVANESE_LETTERS,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_ADDITIONS_FOR_SHAN_PALI_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_REDUPLICATION_MARK_TO_TAI_LAING_CONSONANTS,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_TAI_LAING_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.CHAM_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.CHAM_FINAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.CHAM_FINAL_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_KHAMTI_SHAN_CONSONANTS_TO_KHAMTI_SHAN_LOGOGRAMS,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_TO_TAI_VIET,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET_1,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET_3,
            UnicodeCategoryConstants.TAI_VIET_WORD_LIGATURE_SYMBOLS_TO_WORD_LIGATURE_SYMBOLS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_INDEPENDENT_VOWEL_SIGNS_TO_CONSONANTS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_SIGN_TO_REPETITION_MARKS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_AND_BASKETO_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_AND_BASKETO_SUBSET_1,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GUMUZ_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GUMUZ_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_LETTERS_FOR_GERMAN_DIALECTOLOGY,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_MODIFIER_LETTERS_FOR_GERMAN_DIALECTOLOGY_TO_LETTERS_FOR_SCOTS_DIALECTOLOGY,
            UnicodeCategoryConstants.CHEROKEE_SUPPLEMENT_TO_MEETEI_MAYEK,
            UnicodeCategoryConstants.MEETEI_MAYEK_HANGUL_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.HANGUL_JAMO_EXTENDED_B_OLD_MEDIAL_VOWELS_SUBSET,
            UnicodeCategoryConstants.HANGUL_JAMO_EXTENDED_B_OLD_FINAL_CONSONANTS_SUBSET
        ),
        'ª',
        'µ',
        'º',
        'ˬ',
        'ˮ',
        'Ϳ',
        'Ά',
        'Ό',
        'ՙ',
        'ە',
        'ۿ',
        'ܐ',
        'ޱ',
        'ߺ',
        'ࠚ',
        'ࠤ',
        'ࠨ',
        'ऽ',
        'ॐ',
        'ল',
        'ঽ',
        'ৎ',
        'ৼ',
        'ਫ਼',
        'ઽ',
        'ૐ',
        'ૹ',
        'ଽ',
        'ୱ',
        'ஃ',
        'ஜ',
        'ௐ',
        'ఽ',
        'ಀ',
        'ಽ',
        'ೞ',
        'ഽ',
        'ൎ',
        'ල',
        'ຄ',
        'ລ',
        'ຽ',
        'ໆ',
        'ༀ',
        'ဿ',
        'ၡ',
        'ႎ',
        'Ⴧ',
        'Ⴭ',
        'ቘ',
        'ዀ',
        'ៗ',
        'ៜ',
        'ᢪ',
        'ᪧ',
        'ᳺ',
        'Ὑ',
        'Ὓ',
        'Ὕ',
        'ι',
        'ⁱ',
        'ⁿ',
        'ℂ',
        'ℇ',
        'ℕ',
        'ℤ',
        'Ω',
        'ℨ',
        'ⅎ',
        'ⴧ',
        'ⴭ',
        'ⵯ',
        'ⸯ',
        'ꣻ',
        'ꧏ',
        'ꩺ',
        'ꪱ',
        'ꫀ',
        'ꫂ'
    ),
    LOWERCASE_LETTER(
        keys("Ll", "Lowercase_Letter"),
        "a lowercase letter that has an uppercase variant.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_LOWERCASE_LATIN_ALPHABET,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LOWERCASE_LETTERS,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LETTERS_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_A_EUROPEAN_LATIN_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_A_EUROPEAN_LATIN_TO_EUROPEAN_LATIN,
            UnicodeCategoryConstants.LATIN_EXTENDED_A_EUROPEAN_LATIN_TO_EUROPEAN_LATIN_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_3,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_7,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_11,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_15,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_16,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_PINYIN_DIACRITIC_VOWEL_COMBINATIONS_TO_PINYIN_DIACRITIC_VOWEL_COMBINATIONS,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_PHONETIC_AND_HISTORIC_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_ADDITIONS_FOR_LIVONIAN_TO_ADDITIONS_FOR_AFRICANIST_LINGUISTICS,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_ADDITIONS_FOR_AFRICANIST_LINGUISTICS_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_TO_IPA_EXTENSIONS,
            UnicodeCategoryConstants.IPA_EXTENSIONS_IPA_EXTENSIONS_TO_ADDITIONS_FOR_SINOLOGY_1,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LOWERCASE_OF_EDITORIAL_SYMBOLS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET_5,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_VARIANT_LETTERFORMS_SUBSET,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_VARIANT_LETTERFORMS_SUBSET_2,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_COPTIC_LETTERS_DERIVED_FROM_DEMOTIC_TO_VARIANT_LETTERFORMS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_ARCHAIC_LETTERS_TO_ARCHAIC_LETTERS_1,
            UnicodeCategoryConstants.CYRILLIC_BASIC_RUSSIAN_ALPHABET_TO_CYRILLIC_EXTENSIONS,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_CYRILLIC_SUBSET_1,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_LOWERCASE_LETTERS,
            UnicodeCategoryConstants.GEORGIAN_MKHEDRULI_TO_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.GEORGIAN_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ,
            UnicodeCategoryConstants.CHEROKEE_LOWERCASE_SYLLABLES_TO_LOWERCASE_SYLLABLES,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_C_HISTORIC_LETTER_VARIANTS_SUBSET,
            UnicodeCategoryConstants.PHONETIC_EXTENSIONS_LATIN_LETTERS_TO_GREEK_LETTERS,
            UnicodeCategoryConstants.PHONETIC_EXTENSIONS_LATIN_LETTER_TO_LATIN_LETTERS_WITH_MIDDLE_TILDE,
            UnicodeCategoryConstants.PHONETIC_EXTENSIONS_TO_PHONETIC_EXTENSIONS_SUPPLEMENT_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_ADDITIONAL_LATIN_GENERAL_USE_EXTENSIONS_TO_MEDIEVALIST_ADDITIONS_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_ADDITIONAL_TO_GREEK_EXTENDED_1,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_14,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_22,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_33,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_1,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_12,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_23,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_35,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_13,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_24,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_34,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_37,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_3,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_4,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_11,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_15,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_25,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_36,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_38,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_5,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_2,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_ITALIC_MATH_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.GLAGOLITIC_SMALL_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_ORTHOGRAPHIC_LATIN_ADDITIONS_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_MISCELLANEOUS_ADDITIONS_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_CLAUDIAN_LETTERS_TO_ADDITIONS_FOR_UPA,
            UnicodeCategoryConstants.COPTIC_OLD_NUBIAN_LETTERS_TO_OLD_NUBIAN_LETTERS,
            UnicodeCategoryConstants.GEORGIAN_SUPPLEMENT_SMALL_LETTERS_KHUTSURI_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_MAYANIST_ADDITIONS_TO_MEDIEVALIST_ADDITIONS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_MEDIEVALIST_ADDITIONS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ADDITIONAL_LETTERS_TO_ADDITIONS_FOR_LITHUANIAN_DIALECTOLOGY,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_LETTERS_FOR_GERMAN_DIALECTOLOGY,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_HISTORIC_LETTERS_FOR_SAKHA_YAKUT_TO_LETTERS_FOR_SINOLOGICAL_TRANSCRIPTION,
            UnicodeCategoryConstants.CHEROKEE_SUPPLEMENT_LOWERCASE_SYLLABLES
        ),
        'µ',
        'ā',
        'ă',
        'ą',
        'ć',
        'ĉ',
        'ċ',
        'č',
        'ď',
        'đ',
        'ē',
        'ĕ',
        'ė',
        'ę',
        'ě',
        'ĝ',
        'ğ',
        'ġ',
        'ģ',
        'ĥ',
        'ħ',
        'ĩ',
        'ī',
        'ĭ',
        'į',
        'ı',
        'ĳ',
        'ĵ',
        'ĺ',
        'ļ',
        'ľ',
        'ŀ',
        'ł',
        'ń',
        'ņ',
        'ŋ',
        'ō',
        'ŏ',
        'ő',
        'œ',
        'ŕ',
        'ŗ',
        'ř',
        'ś',
        'ŝ',
        'ş',
        'š',
        'ţ',
        'ť',
        'ŧ',
        'ũ',
        'ū',
        'ŭ',
        'ů',
        'ű',
        'ų',
        'ŵ',
        'ŷ',
        'ź',
        'ż',
        'ƃ',
        'ƅ',
        'ƈ',
        'ƒ',
        'ƕ',
        'ƞ',
        'ơ',
        'ƣ',
        'ƥ',
        'ƨ',
        'ƭ',
        'ư',
        'ƴ',
        'ƶ',
        'ǆ',
        'ǉ',
        'ǌ',
        'ǎ',
        'ǐ',
        'ǒ',
        'ǔ',
        'ǖ',
        'ǘ',
        'ǚ',
        'ǟ',
        'ǡ',
        'ǣ',
        'ǥ',
        'ǧ',
        'ǩ',
        'ǫ',
        'ǭ',
        'ǳ',
        'ǵ',
        'ǹ',
        'ǻ',
        'ǽ',
        'ǿ',
        'ȁ',
        'ȃ',
        'ȅ',
        'ȇ',
        'ȉ',
        'ȋ',
        'ȍ',
        'ȏ',
        'ȑ',
        'ȓ',
        'ȕ',
        'ȗ',
        'ș',
        'ț',
        'ȝ',
        'ȟ',
        'ȡ',
        'ȣ',
        'ȥ',
        'ȧ',
        'ȩ',
        'ȫ',
        'ȭ',
        'ȯ',
        'ȱ',
        'ȼ',
        'ɂ',
        'ɇ',
        'ɉ',
        'ɋ',
        'ɍ',
        'ͱ',
        'ͳ',
        'ͷ',
        'ΐ',
        'ϙ',
        'ϛ',
        'ϝ',
        'ϟ',
        'ϡ',
        'ϣ',
        'ϥ',
        'ϧ',
        'ϩ',
        'ϫ',
        'ϭ',
        'ϵ',
        'ϸ',
        'ѡ',
        'ѣ',
        'ѥ',
        'ѧ',
        'ѩ',
        'ѫ',
        'ѭ',
        'ѯ',
        'ѱ',
        'ѳ',
        'ѵ',
        'ѷ',
        'ѹ',
        'ѻ',
        'ѽ',
        'ѿ',
        'ҁ',
        'ҋ',
        'ҍ',
        'ҏ',
        'ґ',
        'ғ',
        'ҕ',
        'җ',
        'ҙ',
        'қ',
        'ҝ',
        'ҟ',
        'ҡ',
        'ң',
        'ҥ',
        'ҧ',
        'ҩ',
        'ҫ',
        'ҭ',
        'ү',
        'ұ',
        'ҳ',
        'ҵ',
        'ҷ',
        'ҹ',
        'һ',
        'ҽ',
        'ҿ',
        'ӂ',
        'ӄ',
        'ӆ',
        'ӈ',
        'ӊ',
        'ӌ',
        'ӑ',
        'ӓ',
        'ӕ',
        'ӗ',
        'ә',
        'ӛ',
        'ӝ',
        'ӟ',
        'ӡ',
        'ӣ',
        'ӥ',
        'ӧ',
        'ө',
        'ӫ',
        'ӭ',
        'ӯ',
        'ӱ',
        'ӳ',
        'ӵ',
        'ӷ',
        'ӹ',
        'ӻ',
        'ӽ',
        'ӿ',
        'ԁ',
        'ԃ',
        'ԅ',
        'ԇ',
        'ԉ',
        'ԋ',
        'ԍ',
        'ԏ',
        'ԑ',
        'ԓ',
        'ԕ',
        'ԗ',
        'ԙ',
        'ԛ',
        'ԝ',
        'ԟ',
        'ԡ',
        'ԣ',
        'ԥ',
        'ԧ',
        'ԩ',
        'ԫ',
        'ԭ',
        'ԯ',
        'ḁ',
        'ḃ',
        'ḅ',
        'ḇ',
        'ḉ',
        'ḋ',
        'ḍ',
        'ḏ',
        'ḑ',
        'ḓ',
        'ḕ',
        'ḗ',
        'ḙ',
        'ḛ',
        'ḝ',
        'ḟ',
        'ḡ',
        'ḣ',
        'ḥ',
        'ḧ',
        'ḩ',
        'ḫ',
        'ḭ',
        'ḯ',
        'ḱ',
        'ḳ',
        'ḵ',
        'ḷ',
        'ḹ',
        'ḻ',
        'ḽ',
        'ḿ',
        'ṁ',
        'ṃ',
        'ṅ',
        'ṇ',
        'ṉ',
        'ṋ',
        'ṍ',
        'ṏ',
        'ṑ',
        'ṓ',
        'ṕ',
        'ṗ',
        'ṙ',
        'ṛ',
        'ṝ',
        'ṟ',
        'ṡ',
        'ṣ',
        'ṥ',
        'ṧ',
        'ṩ',
        'ṫ',
        'ṭ',
        'ṯ',
        'ṱ',
        'ṳ',
        'ṵ',
        'ṷ',
        'ṹ',
        'ṻ',
        'ṽ',
        'ṿ',
        'ẁ',
        'ẃ',
        'ẅ',
        'ẇ',
        'ẉ',
        'ẋ',
        'ẍ',
        'ẏ',
        'ẑ',
        'ẓ',
        'ẟ',
        'ạ',
        'ả',
        'ấ',
        'ầ',
        'ẩ',
        'ẫ',
        'ậ',
        'ắ',
        'ằ',
        'ẳ',
        'ẵ',
        'ặ',
        'ẹ',
        'ẻ',
        'ẽ',
        'ế',
        'ề',
        'ể',
        'ễ',
        'ệ',
        'ỉ',
        'ị',
        'ọ',
        'ỏ',
        'ố',
        'ồ',
        'ổ',
        'ỗ',
        'ộ',
        'ớ',
        'ờ',
        'ở',
        'ỡ',
        'ợ',
        'ụ',
        'ủ',
        'ứ',
        'ừ',
        'ử',
        'ữ',
        'ự',
        'ỳ',
        'ỵ',
        'ỷ',
        'ỹ',
        'ỻ',
        'ỽ',
        'ι',
        'ℊ',
        'ℓ',
        'ℯ',
        'ℴ',
        'ℹ',
        'ⅎ',
        'ↄ',
        'ⱡ',
        'ⱨ',
        'ⱪ',
        'ⱬ',
        'ⱱ',
        'ⲁ',
        'ⲃ',
        'ⲅ',
        'ⲇ',
        'ⲉ',
        'ⲋ',
        'ⲍ',
        'ⲏ',
        'ⲑ',
        'ⲓ',
        'ⲕ',
        'ⲗ',
        'ⲙ',
        'ⲛ',
        'ⲝ',
        'ⲟ',
        'ⲡ',
        'ⲣ',
        'ⲥ',
        'ⲧ',
        'ⲩ',
        'ⲫ',
        'ⲭ',
        'ⲯ',
        'ⲱ',
        'ⲳ',
        'ⲵ',
        'ⲷ',
        'ⲹ',
        'ⲻ',
        'ⲽ',
        'ⲿ',
        'ⳁ',
        'ⳃ',
        'ⳅ',
        'ⳇ',
        'ⳉ',
        'ⳋ',
        'ⳍ',
        'ⳏ',
        'ⳑ',
        'ⳓ',
        'ⳕ',
        'ⳗ',
        'ⳙ',
        'ⳛ',
        'ⳝ',
        'ⳟ',
        'ⳡ',
        'ⳬ',
        'ⳮ',
        'ⳳ',
        'ⴧ',
        'ⴭ',
        'ꙁ',
        'ꙃ',
        'ꙅ',
        'ꙇ',
        'ꙉ',
        'ꙋ',
        'ꙍ',
        'ꙏ',
        'ꙑ',
        'ꙓ',
        'ꙕ',
        'ꙗ',
        'ꙙ',
        'ꙛ',
        'ꙝ',
        'ꙟ',
        'ꙡ',
        'ꙣ',
        'ꙥ',
        'ꙧ',
        'ꙩ',
        'ꙫ',
        'ꙭ',
        'ꚁ',
        'ꚃ',
        'ꚅ',
        'ꚇ',
        'ꚉ',
        'ꚋ',
        'ꚍ',
        'ꚏ',
        'ꚑ',
        'ꚓ',
        'ꚕ',
        'ꚗ',
        'ꚙ',
        'ꚛ',
        'ꜣ',
        'ꜥ',
        'ꜧ',
        'ꜩ',
        'ꜫ',
        'ꜭ',
        'ꜳ',
        'ꜵ',
        'ꜷ',
        'ꜹ',
        'ꜻ',
        'ꜽ',
        'ꜿ',
        'ꝁ',
        'ꝃ',
        'ꝅ',
        'ꝇ',
        'ꝉ',
        'ꝋ',
        'ꝍ',
        'ꝏ',
        'ꝑ',
        'ꝓ',
        'ꝕ',
        'ꝗ',
        'ꝙ',
        'ꝛ',
        'ꝝ',
        'ꝟ',
        'ꝡ',
        'ꝣ',
        'ꝥ',
        'ꝧ',
        'ꝩ',
        'ꝫ',
        'ꝭ',
        'ꝯ',
        'ꝺ',
        'ꝼ',
        'ꝿ',
        'ꞁ',
        'ꞃ',
        'ꞅ',
        'ꞇ',
        'ꞌ',
        'ꞎ',
        'ꞑ',
        'ꞗ',
        'ꞙ',
        'ꞛ',
        'ꞝ',
        'ꞟ',
        'ꞡ',
        'ꞣ',
        'ꞥ',
        'ꞧ',
        'ꞩ',
        'ꞯ',
        'ꞵ',
        'ꞷ',
        'ꞹ',
        'ꞻ',
        'ꞽ',
        'ꞿ',
        'ꟃ',
        'ꟈ',
        'ꟊ',
        'ꟶ',
        'ꟺ'
    ),
    UPPERCASE_LETTER(
        keys("Lu", "Uppercase_Letter"),
        "an uppercase letter that has a lowercase variant.",
        listOf(
            UnicodeCategoryConstants.BASIC_LATIN_UPPERCASE_LATIN_ALPHABET,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LETTERS,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_UPPERCASE_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_A_EUROPEAN_LATIN_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_2,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_4,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_5,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_6,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_8,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_9,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_10,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_12,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_13,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_NON_EUROPEAN_AND_HISTORIC_LATIN_SUBSET_14,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_PHONETIC_AND_HISTORIC_LETTERS_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_ADDITIONS_FOR_SENCOTEN_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_ADDITIONS_FOR_SENCOTEN_SUBSET_1,
            UnicodeCategoryConstants.LATIN_EXTENDED_B_MISCELLANEOUS_ADDITIONS_SUBSET,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET_1,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET_3,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_LETTERS_SUBSET_4,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_VARIANT_LETTERFORMS_SUBSET_1,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_VARIANT_LETTERFORM_TO_VARIANT_LETTERFORM,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_TO_CYRILLIC_1,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_CYRILLIC_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_UPPERCASE_LETTERS_SUBSET,
            UnicodeCategoryConstants.GEORGIAN_CAPITAL_LETTERS_KHUTSURI_SUBSET,
            UnicodeCategoryConstants.CHEROKEE_UPPERCASE_SYLLABLES_TO_UPPERCASE_SYLLABLES,
            UnicodeCategoryConstants.GEORGIAN_EXTENDED_CAPITAL_LETTERS_MTAVRULI_TO_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.GEORGIAN_EXTENDED_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_7,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_19,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_28,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_43,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_9,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_29,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_41,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_6,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_17,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_31,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_42,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_4,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_6,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_9,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_11,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_12,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_4,
            UnicodeCategoryConstants.GLAGOLITIC_CAPITAL_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_ORTHOGRAPHIC_LATIN_ADDITIONS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_MISCELLANEOUS_ADDITIONS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_ADDITIONS_FOR_SHONA_TO_ADDITIONS_FOR_SHONA,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_INSULAR_AND_CELTICIST_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ADDITIONAL_LETTERS_TO_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_LETTERS_FOR_AMERICANIST_ORTHOGRAPHIES_TO_LETTER_FOR_GERMAN_DIALECTOLOGY,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_LETTERS_USED_IN_EARLY_PINYIN_ROMANIZATION_TO_LETTERS_USED_IN_EARLY_PINYIN_ROMANIZATION
        ),
        'Ā',
        'Ă',
        'Ą',
        'Ć',
        'Ĉ',
        'Ċ',
        'Č',
        'Ď',
        'Đ',
        'Ē',
        'Ĕ',
        'Ė',
        'Ę',
        'Ě',
        'Ĝ',
        'Ğ',
        'Ġ',
        'Ģ',
        'Ĥ',
        'Ħ',
        'Ĩ',
        'Ī',
        'Ĭ',
        'Į',
        'İ',
        'Ĳ',
        'Ĵ',
        'Ķ',
        'Ĺ',
        'Ļ',
        'Ľ',
        'Ŀ',
        'Ł',
        'Ń',
        'Ņ',
        'Ň',
        'Ŋ',
        'Ō',
        'Ŏ',
        'Ő',
        'Œ',
        'Ŕ',
        'Ŗ',
        'Ř',
        'Ś',
        'Ŝ',
        'Ş',
        'Š',
        'Ţ',
        'Ť',
        'Ŧ',
        'Ũ',
        'Ū',
        'Ŭ',
        'Ů',
        'Ű',
        'Ų',
        'Ŵ',
        'Ŷ',
        'Ż',
        'Ž',
        'Ƅ',
        'Ƣ',
        'Ƥ',
        'Ʃ',
        'Ƭ',
        'Ƶ',
        'Ƽ',
        'Ǆ',
        'Ǉ',
        'Ǌ',
        'Ǎ',
        'Ǐ',
        'Ǒ',
        'Ǔ',
        'Ǖ',
        'Ǘ',
        'Ǚ',
        'Ǜ',
        'Ǟ',
        'Ǡ',
        'Ǣ',
        'Ǥ',
        'Ǧ',
        'Ǩ',
        'Ǫ',
        'Ǭ',
        'Ǯ',
        'Ǳ',
        'Ǵ',
        'Ǻ',
        'Ǽ',
        'Ǿ',
        'Ȁ',
        'Ȃ',
        'Ȅ',
        'Ȇ',
        'Ȉ',
        'Ȋ',
        'Ȍ',
        'Ȏ',
        'Ȑ',
        'Ȓ',
        'Ȕ',
        'Ȗ',
        'Ș',
        'Ț',
        'Ȝ',
        'Ȟ',
        'Ƞ',
        'Ȣ',
        'Ȥ',
        'Ȧ',
        'Ȩ',
        'Ȫ',
        'Ȭ',
        'Ȯ',
        'Ȱ',
        'Ȳ',
        'Ɂ',
        'Ɉ',
        'Ɋ',
        'Ɍ',
        'Ɏ',
        'Ͱ',
        'Ͳ',
        'Ͷ',
        'Ϳ',
        'Ά',
        'Ό',
        'Ϗ',
        'Ϙ',
        'Ϛ',
        'Ϝ',
        'Ϟ',
        'Ϡ',
        'Ϣ',
        'Ϥ',
        'Ϧ',
        'Ϩ',
        'Ϫ',
        'Ϭ',
        'Ϯ',
        'ϴ',
        'Ϸ',
        'Ѡ',
        'Ѣ',
        'Ѥ',
        'Ѧ',
        'Ѩ',
        'Ѫ',
        'Ѭ',
        'Ѯ',
        'Ѱ',
        'Ѳ',
        'Ѵ',
        'Ѷ',
        'Ѹ',
        'Ѻ',
        'Ѽ',
        'Ѿ',
        'Ҁ',
        'Ҋ',
        'Ҍ',
        'Ҏ',
        'Ґ',
        'Ғ',
        'Ҕ',
        'Җ',
        'Ҙ',
        'Қ',
        'Ҝ',
        'Ҟ',
        'Ҡ',
        'Ң',
        'Ҥ',
        'Ҧ',
        'Ҩ',
        'Ҫ',
        'Ҭ',
        'Ү',
        'Ұ',
        'Ҳ',
        'Ҵ',
        'Ҷ',
        'Ҹ',
        'Һ',
        'Ҽ',
        'Ҿ',
        'Ӄ',
        'Ӆ',
        'Ӈ',
        'Ӊ',
        'Ӌ',
        'Ӎ',
        'Ӑ',
        'Ӓ',
        'Ӕ',
        'Ӗ',
        'Ә',
        'Ӛ',
        'Ӝ',
        'Ӟ',
        'Ӡ',
        'Ӣ',
        'Ӥ',
        'Ӧ',
        'Ө',
        'Ӫ',
        'Ӭ',
        'Ӯ',
        'Ӱ',
        'Ӳ',
        'Ӵ',
        'Ӷ',
        'Ӹ',
        'Ӻ',
        'Ӽ',
        'Ӿ',
        'Ԁ',
        'Ԃ',
        'Ԅ',
        'Ԇ',
        'Ԉ',
        'Ԋ',
        'Ԍ',
        'Ԏ',
        'Ԑ',
        'Ԓ',
        'Ԕ',
        'Ԗ',
        'Ԙ',
        'Ԛ',
        'Ԝ',
        'Ԟ',
        'Ԡ',
        'Ԣ',
        'Ԥ',
        'Ԧ',
        'Ԩ',
        'Ԫ',
        'Ԭ',
        'Ԯ',
        'Ⴧ',
        'Ⴭ',
        'Ḁ',
        'Ḃ',
        'Ḅ',
        'Ḇ',
        'Ḉ',
        'Ḋ',
        'Ḍ',
        'Ḏ',
        'Ḑ',
        'Ḓ',
        'Ḕ',
        'Ḗ',
        'Ḙ',
        'Ḛ',
        'Ḝ',
        'Ḟ',
        'Ḡ',
        'Ḣ',
        'Ḥ',
        'Ḧ',
        'Ḩ',
        'Ḫ',
        'Ḭ',
        'Ḯ',
        'Ḱ',
        'Ḳ',
        'Ḵ',
        'Ḷ',
        'Ḹ',
        'Ḻ',
        'Ḽ',
        'Ḿ',
        'Ṁ',
        'Ṃ',
        'Ṅ',
        'Ṇ',
        'Ṉ',
        'Ṋ',
        'Ṍ',
        'Ṏ',
        'Ṑ',
        'Ṓ',
        'Ṕ',
        'Ṗ',
        'Ṙ',
        'Ṛ',
        'Ṝ',
        'Ṟ',
        'Ṡ',
        'Ṣ',
        'Ṥ',
        'Ṧ',
        'Ṩ',
        'Ṫ',
        'Ṭ',
        'Ṯ',
        'Ṱ',
        'Ṳ',
        'Ṵ',
        'Ṷ',
        'Ṹ',
        'Ṻ',
        'Ṽ',
        'Ṿ',
        'Ẁ',
        'Ẃ',
        'Ẅ',
        'Ẇ',
        'Ẉ',
        'Ẋ',
        'Ẍ',
        'Ẏ',
        'Ẑ',
        'Ẓ',
        'Ẕ',
        'ẞ',
        'Ạ',
        'Ả',
        'Ấ',
        'Ầ',
        'Ẩ',
        'Ẫ',
        'Ậ',
        'Ắ',
        'Ằ',
        'Ẳ',
        'Ẵ',
        'Ặ',
        'Ẹ',
        'Ẻ',
        'Ẽ',
        'Ế',
        'Ề',
        'Ể',
        'Ễ',
        'Ệ',
        'Ỉ',
        'Ị',
        'Ọ',
        'Ỏ',
        'Ố',
        'Ồ',
        'Ổ',
        'Ỗ',
        'Ộ',
        'Ớ',
        'Ờ',
        'Ở',
        'Ỡ',
        'Ợ',
        'Ụ',
        'Ủ',
        'Ứ',
        'Ừ',
        'Ử',
        'Ữ',
        'Ự',
        'Ỳ',
        'Ỵ',
        'Ỷ',
        'Ỹ',
        'Ỻ',
        'Ỽ',
        'Ỿ',
        'Ὑ',
        'Ὓ',
        'Ὕ',
        'Ὗ',
        'ℂ',
        'ℇ',
        'ℕ',
        'ℤ',
        'Ω',
        'ℨ',
        'ⅅ',
        'Ↄ',
        'Ⱡ',
        'Ⱨ',
        'Ⱪ',
        'Ⱬ',
        'Ⱳ',
        'Ⱶ',
        'Ⲃ',
        'Ⲅ',
        'Ⲇ',
        'Ⲉ',
        'Ⲋ',
        'Ⲍ',
        'Ⲏ',
        'Ⲑ',
        'Ⲓ',
        'Ⲕ',
        'Ⲗ',
        'Ⲙ',
        'Ⲛ',
        'Ⲝ',
        'Ⲟ',
        'Ⲡ',
        'Ⲣ',
        'Ⲥ',
        'Ⲧ',
        'Ⲩ',
        'Ⲫ',
        'Ⲭ',
        'Ⲯ',
        'Ⲱ',
        'Ⲳ',
        'Ⲵ',
        'Ⲷ',
        'Ⲹ',
        'Ⲻ',
        'Ⲽ',
        'Ⲿ',
        'Ⳁ',
        'Ⳃ',
        'Ⳅ',
        'Ⳇ',
        'Ⳉ',
        'Ⳋ',
        'Ⳍ',
        'Ⳏ',
        'Ⳑ',
        'Ⳓ',
        'Ⳕ',
        'Ⳗ',
        'Ⳙ',
        'Ⳛ',
        'Ⳝ',
        'Ⳟ',
        'Ⳡ',
        'Ⳣ',
        'Ⳬ',
        'Ⳮ',
        'Ⳳ',
        'Ꙁ',
        'Ꙃ',
        'Ꙅ',
        'Ꙇ',
        'Ꙉ',
        'Ꙋ',
        'Ꙍ',
        'Ꙏ',
        'Ꙑ',
        'Ꙓ',
        'Ꙕ',
        'Ꙗ',
        'Ꙙ',
        'Ꙛ',
        'Ꙝ',
        'Ꙟ',
        'Ꙡ',
        'Ꙣ',
        'Ꙥ',
        'Ꙧ',
        'Ꙩ',
        'Ꙫ',
        'Ꙭ',
        'Ꚁ',
        'Ꚃ',
        'Ꚅ',
        'Ꚇ',
        'Ꚉ',
        'Ꚋ',
        'Ꚍ',
        'Ꚏ',
        'Ꚑ',
        'Ꚓ',
        'Ꚕ',
        'Ꚗ',
        'Ꚙ',
        'Ꚛ',
        'Ꜣ',
        'Ꜥ',
        'Ꜧ',
        'Ꜩ',
        'Ꜫ',
        'Ꜭ',
        'Ꜯ',
        'Ꜳ',
        'Ꜵ',
        'Ꜷ',
        'Ꜹ',
        'Ꜻ',
        'Ꜽ',
        'Ꜿ',
        'Ꝁ',
        'Ꝃ',
        'Ꝅ',
        'Ꝇ',
        'Ꝉ',
        'Ꝋ',
        'Ꝍ',
        'Ꝏ',
        'Ꝑ',
        'Ꝓ',
        'Ꝕ',
        'Ꝗ',
        'Ꝙ',
        'Ꝛ',
        'Ꝝ',
        'Ꝟ',
        'Ꝡ',
        'Ꝣ',
        'Ꝥ',
        'Ꝧ',
        'Ꝩ',
        'Ꝫ',
        'Ꝭ',
        'Ꝯ',
        'Ꝺ',
        'Ꝼ',
        'Ꞁ',
        'Ꞃ',
        'Ꞅ',
        'Ꞇ',
        'Ꞌ',
        'Ɥ',
        'Ꞑ',
        'Ꞓ',
        'Ꞗ',
        'Ꞙ',
        'Ꞛ',
        'Ꞝ',
        'Ꞟ',
        'Ꞡ',
        'Ꞣ',
        'Ꞥ',
        'Ꞧ',
        'Ꞩ',
        'Ꞷ',
        'Ꞹ',
        'Ꞻ',
        'Ꞽ',
        'Ꞿ',
        'Ꟃ',
        'Ꟊ',
        'Ꟶ'
    ),
    TITLECASE_LETTER(
        keys("Lt", "Titlecase_Letter"),
        "a letter that appears at the start of a word when only the first letter of the word is capitalized.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_8,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_18,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_30
        ),
        'ǅ',
        'ǈ',
        'ǋ',
        'ǲ',
        'ᾼ',
        'ῌ',
        'ῼ'
    ),
    MODIFIER_LETTER(
        keys("Lm", "Modifier_Letter"),
        "a special character that is used like a letter.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_LATIN_SUPERSCRIPT_MODIFIER_LETTERS_TO_MISCELLANEOUS_PHONETIC_MODIFIERS,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_SUBSET_1,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_ADDITIONS_BASED_ON_1989_IPA_SUBSET,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.NKO_TONAL_APOSTROPHES,
            UnicodeCategoryConstants.OL_CHIKI_MODIFIER_LETTERS,
            UnicodeCategoryConstants.PHONETIC_EXTENSIONS_LATIN_SUPERSCRIPT_MODIFIER_LETTERS_TO_GREEK_SUBSCRIPT_MODIFIER_LETTERS,
            UnicodeCategoryConstants.PHONETIC_EXTENSIONS_SUPPLEMENT_MODIFIER_LETTERS,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_TO_SUBSCRIPTS_FOR_UPA,
            UnicodeCategoryConstants.LATIN_EXTENDED_C_ADDITIONS_FOR_UPA_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_KANA_REPEAT_MARKS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_ITERATION_MARKS,
            UnicodeCategoryConstants.KATAKANA_CONJUNCTION_AND_LENGTH_MARKS_TO_ITERATION_MARKS,
            UnicodeCategoryConstants.LISU_TONES,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_INTONATION_MARKS_FOR_LITHUANIAN_DIALECTOLOGY,
            UnicodeCategoryConstants.MODIFIER_TONE_LETTERS_CHINANTEC_TONE_MARKS_TO_AFRICANIST_TONE_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ADDITIONS_FOR_EXTENDED_IPA,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_REPETITION_MARKS,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_MODIFIER_LETTERS_FOR_GERMAN_DIALECTOLOGY_SUBSET
        ),
        'ˬ',
        'ˮ',
        'ʹ',
        'ͺ',
        'ՙ',
        'ـ',
        'ߺ',
        'ࠚ',
        'ࠤ',
        'ࠨ',
        'ॱ',
        'ๆ',
        'ໆ',
        'ჼ',
        'ៗ',
        'ᡃ',
        'ᪧ',
        'ᵸ',
        'ⁱ',
        'ⁿ',
        'ⵯ',
        'ⸯ',
        '々',
        '〻',
        'ꀕ',
        'ꘌ',
        'ꙿ',
        'ꝰ',
        'ꞈ',
        'ꧏ',
        'ꧦ',
        'ꩰ',
        'ꫝ',
        'ꭩ'
    ),
    OTHER_LETTER(
        keys("Lo", "Other_Letter"),
        "a letter or ideograph that does not have lowercase and uppercase variants.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.LATIN_EXTENDED_B_AFRICAN_LETTERS_FOR_CLICKS,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_BASED_ON_ISO_8859_8_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_SIGN_TO_YIDDISH_DIGRAPHS,
            UnicodeCategoryConstants.ARABIC_ADDITION_FOR_KASHMIRI_TO_ADDITIONS_FOR_EARLY_PERSIAN_AND_AZERBAIJANI,
            UnicodeCategoryConstants.ARABIC_BASED_ON_ISO_8859_6_SUBSET,
            UnicodeCategoryConstants.ARABIC_ARCHAIC_LETTERS,
            UnicodeCategoryConstants.ARABIC_EXTENDED_ARABIC_LETTERS_TO_EXTENDED_ARABIC_LETTERS,
            UnicodeCategoryConstants.ARABIC_EXTENDED_ARABIC_LETTERS_FOR_PARKARI,
            UnicodeCategoryConstants.ARABIC_EXTENDED_ARABIC_LETTERS_2,
            UnicodeCategoryConstants.SYRIAC_SYRIAC_LETTERS_TO_PERSIAN_LETTERS,
            UnicodeCategoryConstants.SYRIAC_TO_THAANA,
            UnicodeCategoryConstants.NKO_LETTERS_TO_ARCHAIC_LETTERS,
            UnicodeCategoryConstants.SAMARITAN_LETTERS,
            UnicodeCategoryConstants.MANDAIC_LETTERS,
            UnicodeCategoryConstants.SYRIAC_SUPPLEMENT_SYRIAC_LETTERS_SUBSET,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_ARABIC_LETTERS_FOR_AFRICAN_LANGUAGES_TO_ARABIC_LETTERS_FOR_ARWI,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_ARABIC_LETTERS_FOR_BRAVANESE_TO_ARABIC_LETTERS_FOR_HAUSA_WOLOF_AND_OTHER_AFRICAN_ORTHOGRAPHIES,
            UnicodeCategoryConstants.DEVANAGARI_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.DEVANAGARI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.DEVANAGARI_INDEPENDENT_VOWEL_FOR_MARATHI_TO_SINDHI_IMPLOSIVES,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_4,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_15,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.BENGALI_ADDITIONS_FOR_ASSAMESE,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_1,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_10,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_12,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_16,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.BENGALI_VOWEL_BASES_TO_VOWEL_BASES,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_4,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_9,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_2,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_9,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_13,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_3,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_8,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_CONSONANTS_3,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_11,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_14,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_CONSONANTS_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT_1,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_INDEPENDENT_VOWELS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_3,
            UnicodeCategoryConstants.BENGALI_CONSONANTS_SUBSET_8,
            UnicodeCategoryConstants.TELUGU_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.TELUGU_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.TELUGU_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TELUGU_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.TELUGU_HISTORIC_PHONETIC_VARIANTS_SUBSET,
            UnicodeCategoryConstants.TELUGU_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.KANNADA_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.KANNADA_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.KANNADA_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.KANNADA_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.KANNADA_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.KANNADA_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.KANNADA_SIGNS_USED_IN_SANSKRIT_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_INDEPENDENT_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.MALAYALAM_ADDITIONAL_HISTORIC_CHILLU_LETTERS,
            UnicodeCategoryConstants.MALAYALAM_ADDITIONAL_HISTORIC_VOWEL_TO_ADDITIONAL_VOWELS_FOR_SANSKRIT,
            UnicodeCategoryConstants.MALAYALAM_CHILLU_LETTERS,
            UnicodeCategoryConstants.MALAYALAM_INDEPENDENT_VOWELS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_4,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_5,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_TO_SIGN,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_TO_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_SUBSET_3,
            UnicodeCategoryConstants.MALAYALAM_CONSONANTS_TO_SIGN_1,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_DIGRAPHS_TO_CONSONANTS_FOR_KHMU,
            UnicodeCategoryConstants.TIBETAN_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_CONSONANTS_TO_EXTENSIONS_FOR_BALTI,
            UnicodeCategoryConstants.TIBETAN_TRANSLITERATION_HEAD_LETTERS,
            UnicodeCategoryConstants.MYANMAR_CONSONANTS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_MON_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_WESTERN_PWO_KAREN_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_EASTERN_PWO_KAREN,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_4,
            UnicodeCategoryConstants.HANGUL_JAMO_TO_ETHIOPIC,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_3,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_4,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_9,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_10,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_5,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_11,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_12,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_1,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_7,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_6,
            UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_SUBSET_8,
            UnicodeCategoryConstants.ETHIOPIC_SUPPLEMENT_SYLLABLES_FOR_SEBATBEIT,
            UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_SYLLABLES_TO_SYLLABLES_FOR_CARRIER,
            UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_SYLLABLES_1,
            UnicodeCategoryConstants.OGHAM_TRADITIONAL_LETTERS_TO_FORFEDA_SUPPLEMENTARY_LETTERS,
            UnicodeCategoryConstants.RUNIC_LETTERS,
            UnicodeCategoryConstants.RUNIC_TOLKIENIAN_EXTENSIONS_TO_CRYPTOGRAMMIC_LETTERS,
            UnicodeCategoryConstants.TAGALOG_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TAGALOG_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.HANUNOO_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.BUHID_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TAGBANWA_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.TAGBANWA_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.KHMER_CONSONANTS_TO_INDEPENDENT_VOWELS,
            UnicodeCategoryConstants.MONGOLIAN_BASIC_LETTERS,
            UnicodeCategoryConstants.MONGOLIAN_TODO_LETTERS_TO_MANCHU_LETTERS,
            UnicodeCategoryConstants.MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET_2,
            UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_SYLLABLES_FOR_MOOSE_CREE_TO_FINALS_FOR_DENE_AND_CARRIER,
            UnicodeCategoryConstants.LIMBU_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.TAI_LE_CONSONANTS_TO_VOWELS,
            UnicodeCategoryConstants.TAI_LE_TONE_LETTERS_SUBSET,
            UnicodeCategoryConstants.NEW_TAI_LUE_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.NEW_TAI_LUE_VOWEL_SIGNS_TO_TONE_MARKS,
            UnicodeCategoryConstants.BUGINESE_CONSONANTS,
            UnicodeCategoryConstants.TAI_THAM_CONSONANTS_TO_CONSONANTS,
            UnicodeCategoryConstants.BALINESE_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.BALINESE_ADDITIONAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.SUNDANESE_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.SUNDANESE_ADDITIONAL_CONSONANTS,
            UnicodeCategoryConstants.SUNDANESE_TO_BATAK,
            UnicodeCategoryConstants.LEPCHA_CONSONANTS,
            UnicodeCategoryConstants.LEPCHA_ADDITIONAL_LETTERS,
            UnicodeCategoryConstants.OL_CHIKI_LETTERS,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_NASALIZATION_SIGNS_SUBSET,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_NASALIZATION_SIGNS_TO_ARDHAVISARGA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_SIGNS_SUBSET,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_HEBREW_LETTERLIKE_MATH_SYMBOLS,
            UnicodeCategoryConstants.TIFINAGH_LETTERS_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_MEEN_TO_SYLLABLES_FOR_BLIN,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_1,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_BENCH_SUBSET_3,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_1,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_EXTENDED_SYLLABLES_FOR_SEBATBEIT_SUBSET_3,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_HIRAGANA_LETTERS_TO_SMALL_LETTERS,
            UnicodeCategoryConstants.KATAKANA_KATAKANA_LETTERS,
            UnicodeCategoryConstants.KATAKANA_BASED_ON_GB_2312_TO_MISCELLANEOUS_ADDITIONS,
            UnicodeCategoryConstants.KATAKANA_CONSONANT_LETTERS_TO_OLD_VOWEL_LETTERS,
            UnicodeCategoryConstants.BOPOMOFO_EXTENDED_EXTENDED_BOPOMOFO_FOR_MINNAN_AND_HAKKA_TO_EXTENDED_BOPOMOFO_FOR_CANTONESE,
            UnicodeCategoryConstants.KATAKANA_PHONETIC_EXTENSIONS_PHONETIC_EXTENSIONS_FOR_AINU,
            UnicodeCategoryConstants.CJK_COMPATIBILITY_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A,
            UnicodeCategoryConstants.YIJING_HEXAGRAM_SYMBOLS_CJK_UNIFIED_IDEOGRAPHS_SUBSET,
            UnicodeCategoryConstants.YI_SYLLABLES_SYLLABLES,
            UnicodeCategoryConstants.YI_SYLLABLES_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.LISU_CONSONANTS_TO_VOWELS,
            UnicodeCategoryConstants.VAI_SYLLABLES_IN__EE_TO_SYLLABLES_IN__E,
            UnicodeCategoryConstants.VAI_HISTORIC_SYLLABLES_TO_LOGOGRAMS,
            UnicodeCategoryConstants.VAI_HISTORIC_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.BAMUM_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_TO_SYLOTI_NAGRI_1,
            UnicodeCategoryConstants.SYLOTI_NAGRI_INDEPENDENT_VOWELS_AND_DVISVARA_SUBSET,
            UnicodeCategoryConstants.SYLOTI_NAGRI_CONSONANTS_AND_CONSONANT_SIGNS_SUBSET,
            UnicodeCategoryConstants.SYLOTI_NAGRI_CONSONANTS_AND_CONSONANT_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.PHAGS_PA_CONSONANTS_TO_CONSONANT_ADDITION_FOR_TIBETAN,
            UnicodeCategoryConstants.SAURASHTRA_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_MARKS_OF_NASALIZATION,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_SIGNS_TO_SIGNS,
            UnicodeCategoryConstants.KAYAH_LI_CONSONANTS_TO_VOWELS,
            UnicodeCategoryConstants.REJANG_CONSONANTS,
            UnicodeCategoryConstants.HANGUL_JAMO_EXTENDED_A_OLD_INITIAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.JAVANESE_LETTERS,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_ADDITIONS_FOR_SHAN_PALI_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_TAI_LAING_CONSONANTS,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_TAI_LAING_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.CHAM_INDEPENDENT_VOWELS_TO_CONSONANTS,
            UnicodeCategoryConstants.CHAM_FINAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.CHAM_FINAL_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_KHAMTI_SHAN_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_KHAMTI_SHAN_CONSONANTS_TO_KHAMTI_SHAN_LOGOGRAMS_1,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_TO_TAI_VIET,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET_1,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET_3,
            UnicodeCategoryConstants.TAI_VIET_WORD_LIGATURE_SYMBOLS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_INDEPENDENT_VOWEL_SIGNS_TO_CONSONANTS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_AND_BASKETO_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_AND_BASKETO_SUBSET_1,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GAMO_GOFA_DAWRO_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GUMUZ_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_GUMUZ_SUBSET_1,
            UnicodeCategoryConstants.MEETEI_MAYEK_LETTERS_TO_FINAL_CONSONANTS,
            UnicodeCategoryConstants.MEETEI_MAYEK_HANGUL_SYLLABLES_SUBSET,
            UnicodeCategoryConstants.HANGUL_JAMO_EXTENDED_B_OLD_MEDIAL_VOWELS_SUBSET,
            UnicodeCategoryConstants.HANGUL_JAMO_EXTENDED_B_OLD_FINAL_CONSONANTS_SUBSET
        ),
        'ª',
        'º',
        'ƻ',
        'ʔ',
        'ە',
        'ۿ',
        'ܐ',
        'ޱ',
        'ऽ',
        'ॐ',
        'ল',
        'ঽ',
        'ৎ',
        'ৼ',
        'ਫ਼',
        'ઽ',
        'ૐ',
        'ૹ',
        'ଽ',
        'ୱ',
        'ஃ',
        'ஜ',
        'ௐ',
        'ఽ',
        'ಀ',
        'ಽ',
        'ೞ',
        'ഽ',
        'ൎ',
        'ල',
        'ຄ',
        'ລ',
        'ຽ',
        'ༀ',
        'ဿ',
        'ၡ',
        'ႎ',
        'ቘ',
        'ዀ',
        'ៜ',
        'ᢪ',
        'ᳺ',
        '〆',
        '〼',
        'ゟ',
        'ヿ',
        'ꙮ',
        'ꞏ',
        'ꟷ',
        'ꣻ',
        'ꩺ',
        'ꪱ',
        'ꫀ',
        'ꫂ',
        'ꫲ'
    ),
    MARK(
        keys("M", "Mark"),
        "a character intended to be combined with another character (e.g. accents, umlauts, enclosing boxes, etc.).",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_ORDINARY_DIACRITICS_TO_MEDIEVAL_SUPERSCRIPT_LETTER_DIACRITICS,
            UnicodeCategoryConstants.CYRILLIC_HISTORIC_MISCELLANEOUS_SUBSET_1,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_CANTILLATION_MARKS_TO_POINTS_AND_PUNCTUATION,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_POINTS_AND_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_PUNCTA_EXTRAORDINARIA,
            UnicodeCategoryConstants.ARABIC_HONORIFICS_TO_QURANIC_ANNOTATION_SIGNS,
            UnicodeCategoryConstants.ARABIC_TASHKIL_FROM_ISO_8859_6_TO_OTHER_COMBINING_MARKS,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.SYRIAC_SYRIAC_POINTS_VOWELS_TO_SYRIAC_MARKS,
            UnicodeCategoryConstants.THAANA_VOWELS,
            UnicodeCategoryConstants.NKO_TONE_MARKS_TO_OTHER_DIACRITICS,
            UnicodeCategoryConstants.SAMARITAN_CONSONANT_MODIFIERS_SUBSET,
            UnicodeCategoryConstants.SAMARITAN_CONSONANT_MODIFIERS_TO_VOWEL_SIGNS,
            UnicodeCategoryConstants.SAMARITAN_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.SAMARITAN_VOWEL_SIGNS_TO_VOWEL_SIGNS,
            UnicodeCategoryConstants.MANDAIC_DIACRITICS_SUBSET,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_QURANIC_ANNOTATION_SIGNS_SUBSET,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_TO_DEVANAGARI_1,
            UnicodeCategoryConstants.DEVANAGARI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.DEVANAGARI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS_1,
            UnicodeCategoryConstants.DEVANAGARI_VEDIC_TONE_MARKS_TO_DEPENDENT_VOWEL_SIGNS_FOR_KASHMIRI,
            UnicodeCategoryConstants.DEVANAGARI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_19,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS_1,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_16,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.BENGALI_SIGNS_1,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_18,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_10,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS_1,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_TRANSLITERATION_SIGNS,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_20,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_8,
            UnicodeCategoryConstants.BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS_2,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_9,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_17,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.TELUGU_VARIOUS_SIGNS,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.TELUGU_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.KANNADA_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.KANNADA_VARIOUS_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_VARIANT_SHAPE_VIRAMAS,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_6,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_ADDITIONAL_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET_3,
            UnicodeCategoryConstants.MALAYALAM_VOWEL_TO_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_TO_VOWEL,
            UnicodeCategoryConstants.MALAYALAM_TONE_MARKS_TO_SIGNS,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_1,
            UnicodeCategoryConstants.TIBETAN_DEPENDENT_VOWEL_SIGNS_TO_MARKS_AND_SIGNS_1,
            UnicodeCategoryConstants.TIBETAN_MARKS_AND_SIGNS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_TRANSLITERATION_SUBJOINED_SIGNS_TO_SUBJOINED_CONSONANTS,
            UnicodeCategoryConstants.TIBETAN_SUBJOINED_CONSONANTS_TO_FIXED_FORM_SUBJOINED_CONSONANTS,
            UnicodeCategoryConstants.MYANMAR_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_CONSONANT_SIGNS,
            UnicodeCategoryConstants.MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_MON_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SGAW_KAREN_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_WESTERN_PWO_KAREN_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENSION_FOR_GEBA_KAREN_TO_EXTENSIONS_FOR_KAYAH,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_KHAMTI_SHAN_TO_EXTENSIONS_FOR_AITON_AND_PHAKE,
            UnicodeCategoryConstants.ETHIOPIC_COMBINING_MARKS,
            UnicodeCategoryConstants.TAGALOG_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.HANUNOO_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.BUHID_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.TAGBANWA_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.KHMER_INHERENT_VOWELS_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.MONGOLIAN_FORMAT_CONTROLS_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET_1,
            UnicodeCategoryConstants.LIMBU_DEPENDENT_VOWEL_SIGNS_TO_SUBJOINED_CONSONANTS,
            UnicodeCategoryConstants.LIMBU_FINAL_CONSONANTS_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.BUGINESE_VOWELS_SUBSET_1,
            UnicodeCategoryConstants.TAI_THAM_CONSONANT_SIGNS_SUBSET,
            UnicodeCategoryConstants.TAI_THAM_SIGN_TO_OTHER_MARKS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_EXTENDED_USED_IN_GERMAN_DIALECTOLOGY_TO_USED_FOR_SCOTS_DIALECTOLOGY,
            UnicodeCategoryConstants.BALINESE_VARIOUS_SIGNS,
            UnicodeCategoryConstants.BALINESE_SIGN_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.BALINESE_DIACRITICAL_MARKS_FOR_MUSICAL_SYMBOLS,
            UnicodeCategoryConstants.SUNDANESE_VARIOUS_SIGNS,
            UnicodeCategoryConstants.SUNDANESE_CONSONANT_SIGNS_TO_CONSONANT_SIGNS,
            UnicodeCategoryConstants.BATAK_SIGN_TO_SIGNS,
            UnicodeCategoryConstants.LEPCHA_SUBJOINED_CONSONANTS_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_TONE_MARKS_FOR_THE_SAMAVEDA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_SIGNS_FOR_YAJURVEDIC_TO_DIACRITICS_FOR_VISARGA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_SIGNS_TO_SIGNS_FOR_JAIMINIYA_SAMA_VEDA,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_USED_FOR_ANCIENT_GREEK_TO_MISCELLANEOUS_MARKS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_MISCELLANEOUS_MARKS_TO_ADDITIONAL_MARKS_FOR_UPA,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_TO_ADDITIONAL_DIACRITICAL_MARKS_FOR_SYMBOLS,
            UnicodeCategoryConstants.COPTIC_COMBINING_MARKS,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_A_OLD_CHURCH_SLAVONIC_COMBINING_LETTERS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_COMBINING_TONE_MARKS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_VOICING_MARKS_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_ABBREVIATION_MARK_TO_COMBINING_NUMERIC_SIGNS,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_COMBINING_MARKS_FOR_OLD_CYRILLIC,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_COMBINING_MARKS_FOR_OLD_CYRILLIC_1,
            UnicodeCategoryConstants.BAMUM_COMBINING_MARKS,
            UnicodeCategoryConstants.SYLOTI_NAGRI_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.SAURASHTRA_VARIOUS_SIGNS,
            UnicodeCategoryConstants.SAURASHTRA_CONSONANTS_TO_VIRAMA,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_CANTILLATION_MARKS_SVARA_FOR_THE_SAMAVEDA,
            UnicodeCategoryConstants.KAYAH_LI_VOWELS_TO_TONE_MARKS,
            UnicodeCategoryConstants.REJANG_VOWEL_SIGNS_TO_CONSONANT_SIGNS,
            UnicodeCategoryConstants.JAVANESE_VARIOUS_SIGNS,
            UnicodeCategoryConstants.JAVANESE_SIGN_TO_DEPENDENT_CONSONANT_SIGNS,
            UnicodeCategoryConstants.CHAM_DEPENDENT_VOWEL_SIGNS_TO_CONSONANT_SIGNS,
            UnicodeCategoryConstants.CHAM_FINAL_CONSONANTS_SUBSET_2,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_PAO_KAREN_TONE_MARK_TO_TAI_LAING_TONE_MARKS,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET_2,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_TO_VOWELS_AND_FINALS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_SIGN_TO_SIGN,
            UnicodeCategoryConstants.MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MEETEI_MAYEK_PUNCTUATION_SUBSET
        ),
        'ֿ',
        'ׇ',
        'ٰ',
        'ܑ',
        '߽',
        '়',
        'ৗ',
        '৾',
        '਼',
        'ੑ',
        'ੵ',
        '઼',
        '଼',
        'ஂ',
        'ௗ',
        '಼',
        'ൗ',
        '්',
        'ූ',
        'ั',
        'ັ',
        '༵',
        '༷',
        '༹',
        '࿆',
        'ႏ',
        '៝',
        'ᢩ',
        '᩿',
        '᳭',
        '᳴',
        '⵿',
        'ꠂ',
        '꠆',
        'ꠋ',
        '꠬',
        'ꣿ',
        'ꧥ',
        'ꩃ',
        'ꪰ',
        '꫁'
    ),
    NON_SPACING_MARK(
        keys("Mn", "Non_Spacing_Mark"),
        "a character intended to be combined with another character without taking up extra space (e.g. accents, umlauts, etc.).",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_ORDINARY_DIACRITICS_TO_MEDIEVAL_SUPERSCRIPT_LETTER_DIACRITICS,
            UnicodeCategoryConstants.CYRILLIC_HISTORIC_MISCELLANEOUS_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_CANTILLATION_MARKS_TO_POINTS_AND_PUNCTUATION,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_POINTS_AND_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_PUNCTA_EXTRAORDINARIA,
            UnicodeCategoryConstants.ARABIC_HONORIFICS_TO_QURANIC_ANNOTATION_SIGNS,
            UnicodeCategoryConstants.ARABIC_TASHKIL_FROM_ISO_8859_6_TO_OTHER_COMBINING_MARKS,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.ARABIC_QURANIC_ANNOTATION_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.SYRIAC_SYRIAC_POINTS_VOWELS_TO_SYRIAC_MARKS,
            UnicodeCategoryConstants.THAANA_VOWELS,
            UnicodeCategoryConstants.NKO_TONE_MARKS_TO_OTHER_DIACRITICS,
            UnicodeCategoryConstants.SAMARITAN_CONSONANT_MODIFIERS_SUBSET,
            UnicodeCategoryConstants.SAMARITAN_CONSONANT_MODIFIERS_TO_VOWEL_SIGNS,
            UnicodeCategoryConstants.SAMARITAN_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.SAMARITAN_VOWEL_SIGNS_TO_VOWEL_SIGNS,
            UnicodeCategoryConstants.MANDAIC_DIACRITICS_SUBSET,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_QURANIC_ANNOTATION_SIGNS_SUBSET,
            UnicodeCategoryConstants.ARABIC_EXTENDED_A_TO_DEVANAGARI,
            UnicodeCategoryConstants.DEVANAGARI_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.DEVANAGARI_VEDIC_TONE_MARKS_TO_DEPENDENT_VOWEL_SIGNS_FOR_KASHMIRI,
            UnicodeCategoryConstants.DEVANAGARI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.BENGALI_SIGNS_1,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_9,
            UnicodeCategoryConstants.BENGALI_ADDITIONAL_VOWELS_FOR_SANSKRIT_SUBSET_2,
            UnicodeCategoryConstants.BENGALI_TRANSLITERATION_SIGNS,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_8,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.TELUGU_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS_1,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_VARIANT_SHAPE_VIRAMAS,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_SUBSET_3,
            UnicodeCategoryConstants.MALAYALAM_VOWEL_TO_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_VOWELS_TO_VOWEL,
            UnicodeCategoryConstants.MALAYALAM_TONE_MARKS_TO_SIGNS,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TIBETAN_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.TIBETAN_DEPENDENT_VOWEL_SIGNS_TO_MARKS_AND_SIGNS,
            UnicodeCategoryConstants.TIBETAN_MARKS_AND_SIGNS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_TRANSLITERATION_SUBJOINED_SIGNS_TO_SUBJOINED_CONSONANTS,
            UnicodeCategoryConstants.TIBETAN_SUBJOINED_CONSONANTS_TO_FIXED_FORM_SUBJOINED_CONSONANTS,
            UnicodeCategoryConstants.MYANMAR_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_DEPENDENT_VOWEL_SIGNS_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.MYANMAR_VIRAMA_AND_KILLER,
            UnicodeCategoryConstants.MYANMAR_DEPENDENT_CONSONANT_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET_3,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_MON_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENSION_FOR_GEBA_KAREN_TO_EXTENSIONS_FOR_KAYAH,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_2,
            UnicodeCategoryConstants.ETHIOPIC_COMBINING_MARKS,
            UnicodeCategoryConstants.TAGALOG_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.HANUNOO_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.BUHID_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.TAGBANWA_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.KHMER_INHERENT_VOWELS,
            UnicodeCategoryConstants.KHMER_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.KHMER_CONSONANT_SHIFTERS_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.MONGOLIAN_FORMAT_CONTROLS_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN_SUBSET_1,
            UnicodeCategoryConstants.LIMBU_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.LIMBU_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.LIMBU_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.BUGINESE_VOWELS_SUBSET,
            UnicodeCategoryConstants.TAI_THAM_CONSONANT_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TAI_THAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TAI_THAM_DEPENDENT_VOWEL_SIGNS_TO_OTHER_MARKS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_EXTENDED_USED_IN_GERMAN_DIALECTOLOGY_TO_MARKS_SURROUNDING_OTHER_DIACRITICS_OR_LETTERS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_EXTENDED_USED_FOR_SCOTS_DIALECTOLOGY,
            UnicodeCategoryConstants.BALINESE_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.BALINESE_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.BALINESE_DIACRITICAL_MARKS_FOR_MUSICAL_SYMBOLS,
            UnicodeCategoryConstants.SUNDANESE_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.SUNDANESE_CONSONANT_SIGNS_TO_VOWEL_SIGNS,
            UnicodeCategoryConstants.SUNDANESE_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.SUNDANESE_VIRAMAS_TO_CONSONANT_SIGNS,
            UnicodeCategoryConstants.BATAK_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.BATAK_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_CONSONANT_SIGNS,
            UnicodeCategoryConstants.LEPCHA_DEPENDENT_VOWELS_TO_CONSONANT_SIGNS,
            UnicodeCategoryConstants.LEPCHA_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_TONE_MARKS_FOR_THE_SAMAVEDA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_SIGNS_FOR_YAJURVEDIC_TO_TONE_MARKS_FOR_THE_SATAPATHABRAHMANA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_DIACRITICS_FOR_VISARGA,
            UnicodeCategoryConstants.VEDIC_EXTENSIONS_SIGNS_FOR_JAIMINIYA_SAMA_VEDA,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_USED_FOR_ANCIENT_GREEK_TO_MISCELLANEOUS_MARKS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_SUPPLEMENT_MISCELLANEOUS_MARKS_TO_ADDITIONAL_MARKS_FOR_UPA,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_ADDITIONAL_DIACRITICAL_MARKS_FOR_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.COPTIC_COMBINING_MARKS,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_A_OLD_CHURCH_SLAVONIC_COMBINING_LETTERS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_COMBINING_TONE_MARKS_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_VOICING_MARKS_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_COMBINING_MARKS_FOR_OLD_CYRILLIC,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_COMBINING_MARKS_FOR_OLD_CYRILLIC_1,
            UnicodeCategoryConstants.BAMUM_COMBINING_MARKS,
            UnicodeCategoryConstants.SYLOTI_NAGRI_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.SAURASHTRA_VIRAMA_TO_VIRAMA,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_CANTILLATION_MARKS_SVARA_FOR_THE_SAMAVEDA,
            UnicodeCategoryConstants.KAYAH_LI_VOWELS_TO_TONE_MARKS,
            UnicodeCategoryConstants.REJANG_VOWEL_SIGNS_TO_CONSONANT_SIGNS_1,
            UnicodeCategoryConstants.JAVANESE_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.JAVANESE_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.JAVANESE_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.CHAM_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.CHAM_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.CHAM_CONSONANT_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_SUBSET_2,
            UnicodeCategoryConstants.TAI_VIET_VOWELS_AND_FINALS_TO_VOWELS_AND_FINALS,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_DEPENDENT_VOWEL_SIGNS_SUBSET
        ),
        'ֿ',
        'ׇ',
        'ٰ',
        'ܑ',
        '߽',
        'ऺ',
        '़',
        '्',
        'ঁ',
        '়',
        '্',
        '৾',
        '਼',
        'ੑ',
        'ੵ',
        '઼',
        '્',
        'ଁ',
        '଼',
        'ି',
        '୍',
        'ஂ',
        'ீ',
        '்',
        'ఀ',
        'ఄ',
        'ಁ',
        '಼',
        'ಿ',
        'ೆ',
        '്',
        'ඁ',
        '්',
        'ූ',
        'ั',
        'ັ',
        '༵',
        '༷',
        '༹',
        '࿆',
        'ႂ',
        'ႍ',
        'ႝ',
        'ំ',
        '៝',
        'ᢩ',
        'ᤲ',
        'ᨛ',
        'ᩖ',
        '᩠',
        'ᩢ',
        '᩿',
        '᬴',
        'ᬼ',
        'ᭂ',
        '᯦',
        'ᯭ',
        '᳭',
        '᳴',
        '⃡',
        '⵿',
        '꙯',
        'ꠂ',
        '꠆',
        'ꠋ',
        '꠬',
        'ꣿ',
        '꦳',
        'ꧥ',
        'ꩃ',
        'ꩌ',
        'ꩼ',
        'ꪰ',
        '꫁',
        '꫶',
        'ꯥ',
        'ꯨ',
        '꯭'
    ),
    SPACING_COMBINING_MARK(
        keys("Mc", "Spacing_Combining_Mark"),
        "a character intended to be combined with another character that takes up extra space (vowel signs in many Eastern languages).",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.DEVANAGARI_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.DEVANAGARI_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.DEVANAGARI_DEPENDENT_VOWEL_SIGNS_2,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_13,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_6,
            UnicodeCategoryConstants.BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_14,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_15,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_11,
            UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_SUBSET_7,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_8,
            UnicodeCategoryConstants.BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_1,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_12,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.BENGALI_DEPENDENT_VOWEL_SIGNS_SUBSET_5,
            UnicodeCategoryConstants.BENGALI_TWO_PART_DEPENDENT_VOWEL_SIGNS_2,
            UnicodeCategoryConstants.TELUGU_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.TELUGU_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.KANNADA_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.KANNADA_DEPENDENT_VOWEL_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.KANNADA_VARIOUS_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_SUBSET_4,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_5,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MALAYALAM_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_SUBSET_3,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.MALAYALAM_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.MALAYALAM_ADDITIONAL_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_1,
            UnicodeCategoryConstants.MYANMAR_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_DEPENDENT_CONSONANT_SIGNS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_PALI_AND_SANSKRIT_EXTENSIONS_SUBSET_2,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SGAW_KAREN_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_WESTERN_PWO_KAREN_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_1,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_SHAN_SUBSET_3,
            UnicodeCategoryConstants.MYANMAR_EXTENSIONS_FOR_KHAMTI_SHAN_TO_EXTENSIONS_FOR_KHAMTI_SHAN,
            UnicodeCategoryConstants.KHMER_TWO_PART_DEPENDENT_VOWEL_SIGNS_TO_TWO_PART_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.KHMER_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.LIMBU_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.LIMBU_SUBJOINED_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.LIMBU_FINAL_CONSONANTS_SUBSET,
            UnicodeCategoryConstants.LIMBU_FINAL_CONSONANTS_SUBSET_1,
            UnicodeCategoryConstants.BUGINESE_VOWELS_SUBSET_2,
            UnicodeCategoryConstants.TAI_THAM_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.TAI_THAM_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.BALINESE_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.BALINESE_DEPENDENT_VOWEL_SIGNS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.SUNDANESE_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.BATAK_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.BATAK_SIGNS_SUBSET,
            UnicodeCategoryConstants.LEPCHA_SUBJOINED_CONSONANTS_TO_DEPENDENT_VOWELS,
            UnicodeCategoryConstants.LEPCHA_CONSONANT_SIGNS_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_COMBINING_TONE_MARKS_SUBSET_1,
            UnicodeCategoryConstants.SYLOTI_NAGRI_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.SAURASHTRA_VARIOUS_SIGNS,
            UnicodeCategoryConstants.SAURASHTRA_CONSONANTS_TO_DEPENDENT_VOWEL_SIGNS,
            UnicodeCategoryConstants.REJANG_CONSONANT_SIGNS_TO_CONSONANT_SIGNS,
            UnicodeCategoryConstants.JAVANESE_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.JAVANESE_DEPENDENT_VOWEL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.JAVANESE_DEPENDENT_CONSONANT_SIGNS_TO_DEPENDENT_CONSONANT_SIGNS,
            UnicodeCategoryConstants.CHAM_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.CHAM_CONSONANT_SIGNS_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.MEETEI_MAYEK_DEPENDENT_VOWEL_SIGNS_SUBSET_2
        ),
        'ः',
        'ऻ',
        'ৗ',
        'ਃ',
        'ઃ',
        'ૉ',
        'ା',
        'ୀ',
        'ୗ',
        'ௗ',
        'ಾ',
        'ൗ',
        'ཿ',
        'ေ',
        'း',
        'ႏ',
        'ា',
        'ᩕ',
        'ᩗ',
        'ᩡ',
        'ᬄ',
        'ᬵ',
        'ᬻ',
        'ᮂ',
        'ᮡ',
        '᮪',
        'ᯧ',
        'ᯮ',
        '᳡',
        '᳷',
        'ꠧ',
        'ꦃ',
        'ꩍ',
        'ꩻ',
        'ꩽ',
        'ꫫ',
        'ꫵ',
        '꯬'
    ),
    ENCLOSING_MARK(
        keys("Me", "Enclosing_Mark"),
        "a character that encloses the character it is combined with (circle, square, keycap, etc.).",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.CYRILLIC_HISTORIC_MISCELLANEOUS_SUBSET_2,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_ENCLOSING_DIACRITICS,
            UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS_ADDITIONAL_ENCLOSING_DIACRITICS,
            UnicodeCategoryConstants.CYRILLIC_EXTENDED_B_COMBINING_NUMERIC_SIGNS
        ),
        '᪾'
    ),
    SEPARATOR(
        keys("Z", "Separator"),
        "any kind of whitespace or invisible separator.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_SPACES,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_SEPARATORS
        ),
        ' ',
        ' ',
        ' ',
        ' ',
        ' ',
        '　'
    ),
    SPACE_SEPARATOR(
        keys("Zs", "Space_Separator"),
        "a whitespace character that is invisible, but does take up space.",
        UnicodeCategoryConstants.GENERAL_PUNCTUATION_SPACES,
        charArrayOf(' ', ' ', ' ', ' ', ' ', '　')
    ),
    LINE_SEPARATOR(keys("Zl", "Line_Separator"), "line separator character U+2028.", ' '),
    PARAGRAPH_SEPARATOR(keys("Zp", "Paragraph_Separator"), "paragraph separator character U+2029.", ' '),
    SYMBOL(
        keys("S", "Symbol"),
        "math symbols, currency signs, dingbats, box-drawing characters, etc.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_MATHEMATICAL_OPERATORS,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_2,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_3,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_SUBSET,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_TO_ADDITIONS_BASED_ON_1989_IPA,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_TONE_LETTERS_TO_EXTENDED_BOPOMOFO_TONE_MARKS,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_UPA_MODIFIERS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_SPACING_ACCENT_MARKS,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_RELIGIOUS_SYMBOLS_TO_RELIGIOUS_SYMBOLS,
            UnicodeCategoryConstants.ARABIC_RADIX_SYMBOLS_TO_RADIX_SYMBOLS,
            UnicodeCategoryConstants.ARABIC_POETIC_MARKS,
            UnicodeCategoryConstants.ARABIC_SIGNS_FOR_SINDHI,
            UnicodeCategoryConstants.NKO_CURRENCY_SYMBOLS,
            UnicodeCategoryConstants.BENGALI_CURRENCY_SYMBOLS,
            UnicodeCategoryConstants.BENGALI_SIGN_TO_SIGN,
            UnicodeCategoryConstants.BENGALI_TAMIL_CALENDRICAL_SYMBOLS_TO_CURRENCY_SYMBOL,
            UnicodeCategoryConstants.TIBETAN_HEAD_MARKS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.TIBETAN_SIGNS_TO_SYMBOLS,
            UnicodeCategoryConstants.TIBETAN_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_2,
            UnicodeCategoryConstants.TIBETAN_RELIGIOUS_SYMBOLS,
            UnicodeCategoryConstants.MYANMAR_SHAN_SYMBOLS,
            UnicodeCategoryConstants.ETHIOPIC_SUPPLEMENT_TONAL_MARKS_SUBSET,
            UnicodeCategoryConstants.NEW_TAI_LUE_TO_KHMER_SYMBOLS,
            UnicodeCategoryConstants.BALINESE_MUSICAL_SYMBOLS_FOR_NOTES,
            UnicodeCategoryConstants.BALINESE_MUSICAL_SYMBOLS,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_45,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_10,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_20,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_32,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_44,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET_1,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET_1,
            UnicodeCategoryConstants.CURRENCY_SYMBOLS_CURRENCY_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_2,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_8,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_10,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_LARGE_OPERATOR_TO_ADDITIONAL_LETTERLIKE_SYMBOLS,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_2,
            UnicodeCategoryConstants.NUMBER_FORMS_TURNED_DIGITS_SUBSET,
            UnicodeCategoryConstants.ARROWS_TO_MISCELLANEOUS_TECHNICAL,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_CROPS_TO_KEYBOARD_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_TO_CONTROL_PICTURES_1,
            UnicodeCategoryConstants.OPTICAL_CHARACTER_RECOGNITION_OCR_A_TO_MICR,
            UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_PARENTHESIZED_LATIN_LETTERS_TO_CIRCLED_LATIN_LETTERS,
            UnicodeCategoryConstants.BOX_DRAWING_TO_DINGBATS,
            UnicodeCategoryConstants.DINGBATS_TO_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_OPERATOR_TO_MODAL_LOGIC_OPERATORS,
            UnicodeCategoryConstants.SUPPLEMENTAL_ARROWS_A_TO_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_FENCES_TO_BOWTIE_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_TO_SPECIALIZED_PLUS_SIGN_OPERATORS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_TO_MISCELLANEOUS_SYMBOLS_AND_ARROWS,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_TRIANGLE_HEADED_ARROWS_TO_MISCELLANEOUS_ARROW_SYMBOL,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_MISCELLANEOUS_SYMBOL_TO_SYMBOLS_USED_IN_CHESS_NOTATION,
            UnicodeCategoryConstants.COPTIC_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT_SUBSET,
            UnicodeCategoryConstants.CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT_SUBSET_1,
            UnicodeCategoryConstants.KANGXI_RADICALS_KANGXI_RADICALS_SUBSET,
            UnicodeCategoryConstants.IDEOGRAPHIC_DESCRIPTION_CHARACTERS_IDEOGRAPHIC_DESCRIPTION_CHARACTERS_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_OTHER_CJK_SYMBOLS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_SPECIAL_CJK_INDICATORS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_VOICING_MARKS_SUBSET_1,
            UnicodeCategoryConstants.KANBUN_TATETEN_TO_TATETEN,
            UnicodeCategoryConstants.KANBUN_KAERITEN_SUBSET_1,
            UnicodeCategoryConstants.CJK_STROKES_CJK_STROKES_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_HANGUL_LETTERS_TO_PARENTHESIZED_KOREAN_WORDS,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_IDEOGRAPHS_TO_CIRCLED_IDEOGRAPHS_FROM_ARIB_STD_B24,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_HANGUL_LETTERS_TO_CIRCLED_HANGUL_SYLLABLE,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_IDEOGRAPHS_SUBSET_1,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_TO_CJK_COMPATIBILITY,
            UnicodeCategoryConstants.YIJING_HEXAGRAM_SYMBOLS_YIJING_HEXAGRAM_SYMBOLS,
            UnicodeCategoryConstants.YI_RADICALS_YI_RADICALS_SUBSET,
            UnicodeCategoryConstants.MODIFIER_TONE_LETTERS_CORNER_TONE_MARKS_FOR_CHINESE_TO_LEFT_STEM_TONE_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ADDITIONS_FOR_UPA,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_MODIFIER_LETTERS_SUBSET,
            UnicodeCategoryConstants.SYLOTI_NAGRI_POETRY_MARKS,
            UnicodeCategoryConstants.COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_TO_CURRENCY_SYMBOL,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_AITON_SYMBOLS_AND_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_LETTERS_FOR_SCOTS_DIALECTOLOGY_SUBSET
        ),
        '$',
        '+',
        '^',
        '`',
        '|',
        '~',
        '¬',
        '´',
        '¸',
        '×',
        '÷',
        '˭',
        '͵',
        '϶',
        '҂',
        '؋',
        '۞',
        '۩',
        '߶',
        '૱',
        '୰',
        '౿',
        '൏',
        '൹',
        '฿',
        '༓',
        '༴',
        '༶',
        '༸',
        '᙭',
        '៛',
        '᥀',
        '᾽',
        '⁄',
        '⁒',
        '℔',
        '℥',
        '℧',
        '℩',
        '℮',
        '⅏',
        '〄',
        '〠',
        '㉐',
        '꭛'
    ),
    MATH_SYMBOL(
        keys("Sm", "Math_Symbol"), "any mathematical symbol.", listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_MATHEMATICAL_OPERATORS,
            UnicodeCategoryConstants.ARABIC_RADIX_SYMBOLS_TO_RADIX_SYMBOLS,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET_1,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET_1,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_DOUBLE_STRUCK_LARGE_OPERATOR_TO_ADDITIONAL_LETTERLIKE_SYMBOLS,
            UnicodeCategoryConstants.ARROWS_SIMPLE_ARROWS_SUBSET,
            UnicodeCategoryConstants.ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET,
            UnicodeCategoryConstants.ARROWS_DOUBLE_ARROWS_SUBSET,
            UnicodeCategoryConstants.ARROWS_TO_MATHEMATICAL_OPERATORS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_INTEGRAL_PIECES,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_BRACKET_PIECES_TO_SUMMATION_SIGN_PARTS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_HORIZONTAL_BRACKETS_1,
            UnicodeCategoryConstants.GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_1,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_MISCELLANEOUS_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_OPERATOR_TO_MODAL_LOGIC_OPERATORS,
            UnicodeCategoryConstants.SUPPLEMENTAL_ARROWS_A_ARROWS_TO_LONG_ARROWS,
            UnicodeCategoryConstants.SUPPLEMENTAL_ARROWS_B_TO_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_FENCES_TO_BOWTIE_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_TO_SPECIALIZED_PLUS_SIGN_OPERATORS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_TO_SUPPLEMENTAL_MATHEMATICAL_OPERATORS,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_MATHEMATICAL_ARROWS_SUBSET_2,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_MATHEMATICAL_ARROWS_SUBSET_1
        ), '+', '|', '~', '¬', '±', '×', '÷', '϶', '⁄', '⁒', '℘', '⅋', '↠', '↣', '↦', '↮', '⇒', '⇔', '⍼', '▷', '◁', '♯'
    ),
    CURRENCY_SYMBOL(
        keys("Sc", "Currency_Symbol"),
        "any currency sign.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.NKO_CURRENCY_SYMBOLS,
            UnicodeCategoryConstants.BENGALI_CURRENCY_SYMBOLS,
            UnicodeCategoryConstants.CURRENCY_SYMBOLS_CURRENCY_SYMBOLS_SUBSET
        ),
        '$',
        '֏',
        '؋',
        '৻',
        '૱',
        '௹',
        '฿',
        '៛',
        '꠸'
    ),
    MODIFIER_SYMBOL(
        keys("Sk", "Modifier_Symbol"),
        "a combining character (mark) as a full character on its own.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_SUBSET,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_MISCELLANEOUS_PHONETIC_MODIFIERS_TO_ADDITIONS_BASED_ON_1989_IPA,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_TONE_LETTERS_TO_EXTENDED_BOPOMOFO_TONE_MARKS,
            UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_UPA_MODIFIERS,
            UnicodeCategoryConstants.GREEK_AND_COPTIC_SPACING_ACCENT_MARKS,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_45,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_10,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_20,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_32,
            UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK_SUBSET_44,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_VOICING_MARKS_SUBSET_1,
            UnicodeCategoryConstants.MODIFIER_TONE_LETTERS_CORNER_TONE_MARKS_FOR_CHINESE_TO_LEFT_STEM_TONE_LETTERS,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_ADDITIONS_FOR_UPA,
            UnicodeCategoryConstants.LATIN_EXTENDED_D_MODIFIER_LETTERS_SUBSET,
            UnicodeCategoryConstants.LATIN_EXTENDED_E_LETTERS_FOR_SCOTS_DIALECTOLOGY_SUBSET
        ),
        '^',
        '`',
        '¨',
        '¯',
        '´',
        '¸',
        '˭',
        '͵',
        '᾽',
        '꭛'
    ),
    OTHER_SYMBOL(
        keys("So", "Other_Symbol"),
        "various symbols that are not math symbols, currency signs, or combining characters.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_RELIGIOUS_SYMBOLS,
            UnicodeCategoryConstants.ARABIC_POETIC_MARKS,
            UnicodeCategoryConstants.ARABIC_SIGNS_FOR_SINDHI,
            UnicodeCategoryConstants.BENGALI_TAMIL_CALENDRICAL_SYMBOLS_TO_TAMIL_CLERICAL_SYMBOLS,
            UnicodeCategoryConstants.TIBETAN_HEAD_MARKS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.TIBETAN_SIGNS_TO_SYMBOLS,
            UnicodeCategoryConstants.TIBETAN_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_ASTROLOGICAL_SIGNS_2,
            UnicodeCategoryConstants.TIBETAN_RELIGIOUS_SYMBOLS,
            UnicodeCategoryConstants.MYANMAR_SHAN_SYMBOLS,
            UnicodeCategoryConstants.ETHIOPIC_SUPPLEMENT_TONAL_MARKS_SUBSET,
            UnicodeCategoryConstants.NEW_TAI_LUE_TO_KHMER_SYMBOLS,
            UnicodeCategoryConstants.BALINESE_MUSICAL_SYMBOLS_FOR_NOTES,
            UnicodeCategoryConstants.BALINESE_MUSICAL_SYMBOLS,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_2,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_7,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_SUBSET_10,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_ADDITIONAL_LETTERLIKE_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.NUMBER_FORMS_TURNED_DIGITS_SUBSET,
            UnicodeCategoryConstants.ARROWS_SIMPLE_ARROWS_SUBSET_1,
            UnicodeCategoryConstants.ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_1,
            UnicodeCategoryConstants.ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_2,
            UnicodeCategoryConstants.ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_3,
            UnicodeCategoryConstants.ARROWS_ARROWS_WITH_MODIFICATIONS_SUBSET_4,
            UnicodeCategoryConstants.ARROWS_ARROWS_WITH_MODIFICATIONS_TO_PAIRED_ARROWS_AND_HARPOONS,
            UnicodeCategoryConstants.ARROWS_DOUBLE_ARROWS_SUBSET_1,
            UnicodeCategoryConstants.ARROWS_DOUBLE_ARROWS_TO_WHITE_ARROWS_AND_KEYBOARD_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_MISCELLANEOUS_TECHNICAL,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_CROPS_TO_QUINE_CORNERS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_FROWN_AND_SMILE_TO_KEYBOARD_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_KEYBOARD_SYMBOL_TO_APL,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_GRAPHICS_FOR_CONTROL_CODES_TO_KEYBOARD_SYMBOLS_FROM_ISO_9995_7,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_HORIZONTAL_BRACKETS_TO_ELECTROTECHNICAL_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_TO_CONTROL_PICTURES,
            UnicodeCategoryConstants.OPTICAL_CHARACTER_RECOGNITION_OCR_A_TO_MICR,
            UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_PARENTHESIZED_LATIN_LETTERS_TO_CIRCLED_LATIN_LETTERS,
            UnicodeCategoryConstants.BOX_DRAWING_TO_GEOMETRIC_SHAPES,
            UnicodeCategoryConstants.GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_SUBSET,
            UnicodeCategoryConstants.GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_TO_CONTROL_CODE_GRAPHICS,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_WEATHER_AND_ASTROLOGICAL_SYMBOLS_TO_MUSICAL_SYMBOLS,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_TO_DINGBATS,
            UnicodeCategoryConstants.DINGBATS_DINGBAT_ARROW_TO_DINGBAT_ARROWS,
            UnicodeCategoryConstants.BRAILLE_PATTERNS_BRAILLE_PATTERNS,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_WHITE_AND_BLACK_ARROWS_TO_ELLIPSES,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_MATHEMATICAL_ARROWS_SUBSET,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_MISCELLANEOUS_ARROW_TO_TRIANGLE_HEADED_ARROWS,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_TRIANGLE_HEADED_ARROWS_TO_MISCELLANEOUS_ARROW_SYMBOL,
            UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_MISCELLANEOUS_SYMBOL_TO_SYMBOLS_USED_IN_CHESS_NOTATION,
            UnicodeCategoryConstants.COPTIC_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT_SUBSET,
            UnicodeCategoryConstants.CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT_SUBSET_1,
            UnicodeCategoryConstants.KANGXI_RADICALS_KANGXI_RADICALS_SUBSET,
            UnicodeCategoryConstants.IDEOGRAPHIC_DESCRIPTION_CHARACTERS_IDEOGRAPHIC_DESCRIPTION_CHARACTERS_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_OTHER_CJK_SYMBOLS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_SPECIAL_CJK_INDICATORS,
            UnicodeCategoryConstants.KANBUN_TATETEN_TO_TATETEN,
            UnicodeCategoryConstants.KANBUN_KAERITEN_SUBSET_1,
            UnicodeCategoryConstants.CJK_STROKES_CJK_STROKES_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_HANGUL_LETTERS_TO_PARENTHESIZED_KOREAN_WORDS,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_IDEOGRAPHS_TO_CIRCLED_IDEOGRAPHS_FROM_ARIB_STD_B24,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_HANGUL_LETTERS_TO_CIRCLED_HANGUL_SYLLABLE,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_IDEOGRAPHS_SUBSET_1,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_TO_CJK_COMPATIBILITY,
            UnicodeCategoryConstants.YIJING_HEXAGRAM_SYMBOLS_YIJING_HEXAGRAM_SYMBOLS,
            UnicodeCategoryConstants.YI_RADICALS_YI_RADICALS_SUBSET,
            UnicodeCategoryConstants.SYLOTI_NAGRI_POETRY_MARKS,
            UnicodeCategoryConstants.COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_TO_NUMBER_FORMS,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_A_AITON_SYMBOLS_AND_LETTERS_SUBSET
        ),
        '¦',
        '©',
        '®',
        '°',
        '҂',
        '۞',
        '۩',
        '߶',
        '৺',
        '୰',
        '௺',
        '౿',
        '൏',
        '൹',
        '༓',
        '༴',
        '༶',
        '༸',
        '᙭',
        '᥀',
        '℔',
        '℥',
        '℧',
        '℩',
        '℮',
        '⅊',
        '⅏',
        '⇓',
        '〄',
        '〠',
        '㉐',
        '꠹'
    ),
    NUMBER(
        keys("N", "Number"), "any kind of numeric character in any script.", listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_DIGITS,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_4,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_VULGAR_FRACTIONS,
            UnicodeCategoryConstants.ARABIC_ARABIC_INDIC_DIGITS,
            UnicodeCategoryConstants.ARABIC_EASTERN_ARABIC_INDIC_DIGITS,
            UnicodeCategoryConstants.NKO_DIGITS,
            UnicodeCategoryConstants.DEVANAGARI_DIGITS,
            UnicodeCategoryConstants.BENGALI_DIGITS,
            UnicodeCategoryConstants.BENGALI_HISTORIC_SYMBOLS_FOR_FRACTIONAL_VALUES,
            UnicodeCategoryConstants.BENGALI_DIGITS_1,
            UnicodeCategoryConstants.BENGALI_DIGITS_2,
            UnicodeCategoryConstants.BENGALI_DIGITS_3,
            UnicodeCategoryConstants.BENGALI_FRACTION_SIGNS_SUBSET,
            UnicodeCategoryConstants.BENGALI_DIGITS_TO_TAMIL_NUMERICS,
            UnicodeCategoryConstants.TELUGU_DIGITS_SUBSET,
            UnicodeCategoryConstants.TELUGU_TELUGU_FRACTIONS_AND_WEIGHTS_SUBSET,
            UnicodeCategoryConstants.KANNADA_DIGITS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_MINOR_FRACTIONS,
            UnicodeCategoryConstants.MALAYALAM_DIGITS_TO_FRACTIONS,
            UnicodeCategoryConstants.MALAYALAM_ASTROLOGICAL_DIGITS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_DIGITS_1,
            UnicodeCategoryConstants.MALAYALAM_DIGITS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_DIGITS_TO_DIGITS_MINUS_HALF,
            UnicodeCategoryConstants.MYANMAR_DIGITS,
            UnicodeCategoryConstants.MYANMAR_SHAN_DIGITS,
            UnicodeCategoryConstants.ETHIOPIC_DIGITS_TO_NUMBERS,
            UnicodeCategoryConstants.RUNIC_GOLDEN_NUMBER_RUNES,
            UnicodeCategoryConstants.KHMER_DIGITS_SUBSET,
            UnicodeCategoryConstants.KHMER_NUMERIC_SYMBOLS_FOR_DIVINATION_LORE_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_DIGITS_SUBSET,
            UnicodeCategoryConstants.LIMBU_DIGITS,
            UnicodeCategoryConstants.NEW_TAI_LUE_DIGITS_SUBSET,
            UnicodeCategoryConstants.TAI_THAM_HORA_DIGITS_SUBSET,
            UnicodeCategoryConstants.TAI_THAM_THAM_DIGITS_SUBSET,
            UnicodeCategoryConstants.BALINESE_DIGITS,
            UnicodeCategoryConstants.SUNDANESE_DIGITS,
            UnicodeCategoryConstants.LEPCHA_DIGITS_SUBSET,
            UnicodeCategoryConstants.OL_CHIKI_DIGITS,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET,
            UnicodeCategoryConstants.NUMBER_FORMS_FRACTIONS_TO_ARCHAIC_ROMAN_NUMERALS,
            UnicodeCategoryConstants.NUMBER_FORMS_ARCHAIC_ROMAN_NUMERALS_TO_ARCHAIC_ROMAN_NUMERALS_1,
            UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_CIRCLED_NUMBERS_TO_NUMBERS_PERIOD,
            UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_ADDITIONAL_CIRCLED_NUMBER_TO_DOUBLE_CIRCLED_NUMBERS,
            UnicodeCategoryConstants.DINGBATS_DINGBAT_CIRCLED_DIGITS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_SUZHOU_NUMERALS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_ADDITIONAL_SUZHOU_NUMERALS,
            UnicodeCategoryConstants.KANBUN_KAERITEN_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_IDEOGRAPHS_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS_ON_BLACK_SQUARES_FROM_ARIB_STD_B24,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_IDEOGRAPHS_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS_1,
            UnicodeCategoryConstants.VAI_DIGITS,
            UnicodeCategoryConstants.BAMUM_SYLLABLES_SUBSET_1,
            UnicodeCategoryConstants.COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_SUBSET,
            UnicodeCategoryConstants.SAURASHTRA_DIGITS_SUBSET,
            UnicodeCategoryConstants.KAYAH_LI_DIGITS,
            UnicodeCategoryConstants.JAVANESE_DIGITS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_TAI_LAING_DIGITS,
            UnicodeCategoryConstants.CHAM_DIGITS_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_DIGITS_SUBSET
        ), '¹', '⁰', '⳽', '〇'
    ),
    DECIMAL_DIGIT_NUMBER(
        keys("Nd", "Decimal_Digit_Number"),
        "a digit zero through nine in any script except ideographic scripts.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_DIGITS,
            UnicodeCategoryConstants.ARABIC_ARABIC_INDIC_DIGITS,
            UnicodeCategoryConstants.ARABIC_EASTERN_ARABIC_INDIC_DIGITS,
            UnicodeCategoryConstants.NKO_DIGITS,
            UnicodeCategoryConstants.DEVANAGARI_DIGITS,
            UnicodeCategoryConstants.BENGALI_DIGITS,
            UnicodeCategoryConstants.BENGALI_DIGITS_1,
            UnicodeCategoryConstants.BENGALI_DIGITS_2,
            UnicodeCategoryConstants.BENGALI_DIGITS_3,
            UnicodeCategoryConstants.BENGALI_DIGITS_4,
            UnicodeCategoryConstants.TELUGU_DIGITS_SUBSET,
            UnicodeCategoryConstants.KANNADA_DIGITS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_DIGITS,
            UnicodeCategoryConstants.MALAYALAM_ASTROLOGICAL_DIGITS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_DIGITS_1,
            UnicodeCategoryConstants.MALAYALAM_DIGITS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_DIGITS,
            UnicodeCategoryConstants.MYANMAR_DIGITS,
            UnicodeCategoryConstants.MYANMAR_SHAN_DIGITS,
            UnicodeCategoryConstants.KHMER_DIGITS_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_DIGITS_SUBSET,
            UnicodeCategoryConstants.LIMBU_DIGITS,
            UnicodeCategoryConstants.NEW_TAI_LUE_DIGITS_SUBSET_1,
            UnicodeCategoryConstants.TAI_THAM_HORA_DIGITS_SUBSET,
            UnicodeCategoryConstants.TAI_THAM_THAM_DIGITS_SUBSET,
            UnicodeCategoryConstants.BALINESE_DIGITS,
            UnicodeCategoryConstants.SUNDANESE_DIGITS,
            UnicodeCategoryConstants.LEPCHA_DIGITS_SUBSET,
            UnicodeCategoryConstants.OL_CHIKI_DIGITS,
            UnicodeCategoryConstants.VAI_DIGITS,
            UnicodeCategoryConstants.SAURASHTRA_DIGITS_SUBSET,
            UnicodeCategoryConstants.KAYAH_LI_DIGITS,
            UnicodeCategoryConstants.JAVANESE_DIGITS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_EXTENDED_B_TAI_LAING_DIGITS,
            UnicodeCategoryConstants.CHAM_DIGITS_SUBSET,
            UnicodeCategoryConstants.MEETEI_MAYEK_DIGITS_SUBSET
        )
    ),
    LETTER_NUMBER(
        keys("Nl", "Letter_Number"),
        "a number that looks like a letter, such as a Roman numeral.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.RUNIC_GOLDEN_NUMBER_RUNES,
            UnicodeCategoryConstants.NUMBER_FORMS_ROMAN_NUMERALS_TO_ARCHAIC_ROMAN_NUMERALS,
            UnicodeCategoryConstants.NUMBER_FORMS_ARCHAIC_ROMAN_NUMERALS_1,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_SUZHOU_NUMERALS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_ADDITIONAL_SUZHOU_NUMERALS,
            UnicodeCategoryConstants.BAMUM_SYLLABLES_SUBSET_1
        ),
        '〇'
    ),
    OTHER_NUMBER(
        keys("No", "Other_Number"),
        "a superscript or subscript digit, or a number that is not a digit 0-9 (excluding numbers from ideographic scripts).",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_4,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_VULGAR_FRACTIONS,
            UnicodeCategoryConstants.BENGALI_HISTORIC_SYMBOLS_FOR_FRACTIONAL_VALUES,
            UnicodeCategoryConstants.BENGALI_FRACTION_SIGNS_SUBSET,
            UnicodeCategoryConstants.BENGALI_TAMIL_NUMERICS,
            UnicodeCategoryConstants.TELUGU_TELUGU_FRACTIONS_AND_WEIGHTS_SUBSET,
            UnicodeCategoryConstants.MALAYALAM_MINOR_FRACTIONS,
            UnicodeCategoryConstants.MALAYALAM_MALAYALAM_NUMERICS_TO_FRACTIONS,
            UnicodeCategoryConstants.TIBETAN_DIGITS_MINUS_HALF,
            UnicodeCategoryConstants.ETHIOPIC_DIGITS_TO_NUMBERS,
            UnicodeCategoryConstants.KHMER_NUMERIC_SYMBOLS_FOR_DIVINATION_LORE_SUBSET,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET,
            UnicodeCategoryConstants.NUMBER_FORMS_FRACTIONS,
            UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_CIRCLED_NUMBERS_TO_NUMBERS_PERIOD,
            UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_ADDITIONAL_CIRCLED_NUMBER_TO_DOUBLE_CIRCLED_NUMBERS,
            UnicodeCategoryConstants.DINGBATS_DINGBAT_CIRCLED_DIGITS,
            UnicodeCategoryConstants.KANBUN_KAERITEN_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_IDEOGRAPHS_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS_ON_BLACK_SQUARES_FROM_ARIB_STD_B24,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_IDEOGRAPHS_SUBSET,
            UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_CIRCLED_NUMBERS_1,
            UnicodeCategoryConstants.COMMON_INDIC_NUMBER_FORMS_NUMBER_FORMS_SUBSET
        ),
        '¹',
        '᧚',
        '⁰',
        '↉',
        '⳽'
    ),
    PUNCTUATION(
        keys("P", "Punctuation"),
        "any kind of punctuation character.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_3,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_1,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_2,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_5,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_MODIFIER_LETTERS_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_ADDITIONAL_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION_1,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION_4,
            UnicodeCategoryConstants.SYRIAC_SYRIAC_PUNCTUATION_AND_SIGNS_SUBSET,
            UnicodeCategoryConstants.NKO_PUNCTUATION,
            UnicodeCategoryConstants.SAMARITAN_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.DEVANAGARI_GENERIC_PUNCTUATION_FOR_SCRIPTS_OF_INDIA,
            UnicodeCategoryConstants.MALAYALAM_SIGNS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_HEAD_MARKS_TO_MARKS_AND_SIGNS,
            UnicodeCategoryConstants.TIBETAN_PAIRED_PUNCTUATION,
            UnicodeCategoryConstants.TIBETAN_MARKS_TO_HEAD_MARKS,
            UnicodeCategoryConstants.TIBETAN_ANNOTATION_MARKS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_PUNCTUATION_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.ETHIOPIC_PUNCTUATION,
            UnicodeCategoryConstants.OGHAM_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.RUNIC_PUNCTUATION,
            UnicodeCategoryConstants.HANUNOO_GENERIC_PUNCTUATION_FOR_PHILIPPINE_SCRIPTS_SUBSET,
            UnicodeCategoryConstants.KHMER_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.KHMER_VARIOUS_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.MONGOLIAN_PUNCTUATION,
            UnicodeCategoryConstants.LIMBU_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.BUGINESE_VARIOUS_SIGNS,
            UnicodeCategoryConstants.TAI_THAM_LOGOGRAPHS_TO_PUNCTUATION,
            UnicodeCategoryConstants.TAI_THAM_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.BALINESE_PUNCTUATION,
            UnicodeCategoryConstants.BATAK_PUNCTUATION,
            UnicodeCategoryConstants.LEPCHA_PUNCTUATION,
            UnicodeCategoryConstants.OL_CHIKI_PUNCTUATION,
            UnicodeCategoryConstants.SUNDANESE_SUPPLEMENT_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_DASHES_TO_GENERAL_PUNCTUATION,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_GENERAL_PUNCTUATION,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_BRACKETS_TO_GENERAL_PUNCTUATION,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_ARCHAIC_PUNCTUATION,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_SUBSET_2,
            UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUBSCRIPTS_SUBSET_2,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_CEILINGS_AND_FLOORS,
            UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_DEPRECATED_ANGLE_BRACKETS,
            UnicodeCategoryConstants.DINGBATS_ORNAMENTAL_BRACKETS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_PAIRED_PUNCTUATION,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A_MATHEMATICAL_BRACKETS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_BRACKETS_TO_BRACKETS,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_FENCES_1,
            UnicodeCategoryConstants.MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B_BRACKETS_2,
            UnicodeCategoryConstants.COPTIC_OLD_NUBIAN_PUNCTUATION,
            UnicodeCategoryConstants.COPTIC_PUNCTUATION,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_NEW_TESTAMENT_EDITORIAL_SYMBOLS_TO_HISTORIC_PUNCTUATION,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_TO_HISTORIC_PUNCTUATION,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_ANGLE_BRACKETS_TO_CJK_BRACKETS,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_BRACKETS_TO_CJK_PUNCTUATION,
            UnicodeCategoryConstants.LISU_PUNCTUATION,
            UnicodeCategoryConstants.VAI_PUNCTUATION,
            UnicodeCategoryConstants.BAMUM_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.PHAGS_PA_HEAD_MARKS_FOR_TIBETAN_TO_PUNCTUATION_FOR_TIBETAN,
            UnicodeCategoryConstants.SAURASHTRA_PUNCTUATION,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_EDITORIAL_MARKS_SUBSET,
            UnicodeCategoryConstants.KAYAH_LI_PUNCTUATION,
            UnicodeCategoryConstants.JAVANESE_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.JAVANESE_ELLIPSIS_MARKS,
            UnicodeCategoryConstants.CHAM_PUNCTUATION,
            UnicodeCategoryConstants.TAI_VIET_PUNCTUATION,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_PUNCTUATION
        ),
        '_',
        '{',
        '}',
        '¡',
        '§',
        '«',
        '»',
        '¿',
        ';',
        '·',
        '־',
        '׀',
        '׃',
        '׆',
        '؛',
        '۔',
        '࡞',
        '॰',
        '৽',
        '੶',
        '૰',
        '౷',
        '಄',
        '෴',
        '๏',
        '༔',
        '྅',
        '჻',
        '᐀',
        '᙮',
        '᳓',
        '⵰',
        '⹒',
        '〰',
        '〽',
        '゠',
        '・',
        '꙳',
        '꙾',
        '꣼',
        '꥟',
        '꯫'
    ),
    DASH_PUNCTUATION(
        keys("Pd", "Dash_Punctuation"),
        "any kind of hyphen or dash.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_DASHES,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_DASHES
        ),
        '-',
        '֊',
        '־',
        '᐀',
        '᠆',
        '⸗',
        '⸚',
        '⹀',
        '〜',
        '〰',
        '゠'
    ),
    OPEN_PUNCTUATION(
        keys("Ps", "Open_Punctuation"),
        "any kind of opening bracket.",
        '(',
        '[',
        '{',
        '༺',
        '༼',
        '᚛',
        '‚',
        '„',
        '⁅',
        '⁽',
        '₍',
        '⌈',
        '⌊',
        '〈',
        '❨',
        '❪',
        '❬',
        '❮',
        '❰',
        '❲',
        '❴',
        '⟅',
        '⟦',
        '⟨',
        '⟪',
        '⟬',
        '⟮',
        '⦃',
        '⦅',
        '⦇',
        '⦉',
        '⦋',
        '⦍',
        '⦏',
        '⦑',
        '⦓',
        '⦕',
        '⦗',
        '⧘',
        '⧚',
        '⧼',
        '⸢',
        '⸤',
        '⸦',
        '⸨',
        '⹂',
        '〈',
        '《',
        '「',
        '『',
        '【',
        '〔',
        '〖',
        '〘',
        '〚',
        '〝'
    ),
    CLOSE_PUNCTUATION(
        keys("Pe", "Close_Punctuation"),
        "any kind of closing bracket.",
        UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_PUNCTUATION_SUBSET,
        charArrayOf(
            ')',
            ']',
            '}',
            '༻',
            '༽',
            '᚜',
            '⁆',
            '⁾',
            '₎',
            '⌉',
            '⌋',
            '〉',
            '❩',
            '❫',
            '❭',
            '❯',
            '❱',
            '❳',
            '❵',
            '⟆',
            '⟧',
            '⟩',
            '⟫',
            '⟭',
            '⟯',
            '⦄',
            '⦆',
            '⦈',
            '⦊',
            '⦌',
            '⦎',
            '⦐',
            '⦒',
            '⦔',
            '⦖',
            '⦘',
            '⧙',
            '⧛',
            '⧽',
            '⸣',
            '⸥',
            '⸧',
            '⸩',
            '〉',
            '》',
            '」',
            '』',
            '】',
            '〕',
            '〗',
            '〙',
            '〛'
        )
    ),
    INITIAL_PUNCTUATION(
        keys("Pi", "Initial_Punctuation"),
        "any kind of opening quote.",
        UnicodeCategoryConstants.GENERAL_PUNCTUATION_QUOTATION_MARKS_AND_APOSTROPHE_SUBSET,
        charArrayOf('«', '‘', '‟', '‹', '⸂', '⸄', '⸉', '⸌', '⸜', '⸠')
    ),
    FINAL_PUNCTUATION(
        keys("Pf", "Final_Punctuation"),
        "any kind of closing quote.",
        '»',
        '’',
        '”',
        '›',
        '⸃',
        '⸅',
        '⸊',
        '⸍',
        '⸝',
        '⸡'
    ),
    CONNECTOR_PUNCTUATION(
        keys("Pc", "Connector_Punctuation"),
        "a punctuation character such as an underscore that connects words.",
        UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_SUBSET_1,
        charArrayOf('_', '⁔')
    ),
    OTHER_PUNCTUATION(
        keys("Po", "Other_Punctuation"),
        "any kind of punctuation character that is not a dash, bracket, quote or connector.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_SUBSET_2,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_1,
            UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_2,
            UnicodeCategoryConstants.LATIN_1_SUPPLEMENT_LATIN_1_PUNCTUATION_AND_SYMBOLS_SUBSET_5,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_MODIFIER_LETTERS_SUBSET,
            UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_ADDITIONAL_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION_1,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.ARABIC_PUNCTUATION_4,
            UnicodeCategoryConstants.SYRIAC_SYRIAC_PUNCTUATION_AND_SIGNS_SUBSET,
            UnicodeCategoryConstants.NKO_PUNCTUATION,
            UnicodeCategoryConstants.SAMARITAN_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.DEVANAGARI_GENERIC_PUNCTUATION_FOR_SCRIPTS_OF_INDIA,
            UnicodeCategoryConstants.MALAYALAM_SIGNS_SUBSET,
            UnicodeCategoryConstants.TIBETAN_HEAD_MARKS_TO_MARKS_AND_SIGNS,
            UnicodeCategoryConstants.TIBETAN_MARKS_TO_HEAD_MARKS,
            UnicodeCategoryConstants.TIBETAN_ANNOTATION_MARKS_SUBSET,
            UnicodeCategoryConstants.MYANMAR_PUNCTUATION_TO_VARIOUS_SIGNS,
            UnicodeCategoryConstants.ETHIOPIC_PUNCTUATION,
            UnicodeCategoryConstants.RUNIC_PUNCTUATION,
            UnicodeCategoryConstants.HANUNOO_GENERIC_PUNCTUATION_FOR_PHILIPPINE_SCRIPTS_SUBSET,
            UnicodeCategoryConstants.KHMER_VARIOUS_SIGNS_SUBSET_1,
            UnicodeCategoryConstants.KHMER_VARIOUS_SIGNS_SUBSET_2,
            UnicodeCategoryConstants.MONGOLIAN_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.MONGOLIAN_PUNCTUATION_SUBSET_1,
            UnicodeCategoryConstants.LIMBU_VARIOUS_SIGNS_SUBSET,
            UnicodeCategoryConstants.BUGINESE_VARIOUS_SIGNS,
            UnicodeCategoryConstants.TAI_THAM_LOGOGRAPHS_TO_PUNCTUATION,
            UnicodeCategoryConstants.TAI_THAM_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.BALINESE_PUNCTUATION,
            UnicodeCategoryConstants.BATAK_PUNCTUATION,
            UnicodeCategoryConstants.LEPCHA_PUNCTUATION,
            UnicodeCategoryConstants.OL_CHIKI_PUNCTUATION,
            UnicodeCategoryConstants.SUNDANESE_SUPPLEMENT_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_1,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_2,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_GENERAL_PUNCTUATION_1,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_DOUBLE_PUNCTUATION_FOR_VERTICAL_TEXT_TO_GENERAL_PUNCTUATION,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_GENERAL_PUNCTUATION_TO_ARCHAIC_PUNCTUATION_1,
            UnicodeCategoryConstants.COPTIC_OLD_NUBIAN_PUNCTUATION,
            UnicodeCategoryConstants.COPTIC_PUNCTUATION,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_NEW_TESTAMENT_EDITORIAL_SYMBOLS_SUBSET,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_NEW_TESTAMENT_EDITORIAL_SYMBOLS_SUBSET_1,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_ANCIENT_GREEK_TEXTUAL_SYMBOLS,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_GENERAL_PUNCTUATION,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_DICTIONARY_PUNCTUATION_1,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_SUBSET_1,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_HISTORIC_PUNCTUATION_TO_PALAEOTYPE_TRANSLITERATION_SYMBOLS,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_ALTERNATE_FORMS_OF_PUNCTUATION_TO_ALTERNATE_FORMS_OF_PUNCTUATION,
            UnicodeCategoryConstants.SUPPLEMENTAL_PUNCTUATION_MISCELLANEOUS_PUNCTUATION_TO_HISTORIC_PUNCTUATION,
            UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.LISU_PUNCTUATION,
            UnicodeCategoryConstants.VAI_PUNCTUATION,
            UnicodeCategoryConstants.BAMUM_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.PHAGS_PA_HEAD_MARKS_FOR_TIBETAN_TO_PUNCTUATION_FOR_TIBETAN,
            UnicodeCategoryConstants.SAURASHTRA_PUNCTUATION,
            UnicodeCategoryConstants.DEVANAGARI_EXTENDED_EDITORIAL_MARKS_SUBSET,
            UnicodeCategoryConstants.KAYAH_LI_PUNCTUATION,
            UnicodeCategoryConstants.JAVANESE_PUNCTUATION_SUBSET,
            UnicodeCategoryConstants.JAVANESE_ELLIPSIS_MARKS,
            UnicodeCategoryConstants.CHAM_PUNCTUATION,
            UnicodeCategoryConstants.TAI_VIET_PUNCTUATION,
            UnicodeCategoryConstants.MEETEI_MAYEK_EXTENSIONS_PUNCTUATION
        ),
        '*',
        ',',
        '\\',
        '¡',
        '§',
        '¿',
        ';',
        '·',
        '։',
        '׀',
        '׃',
        '׆',
        '؛',
        '۔',
        '࡞',
        '॰',
        '৽',
        '੶',
        '૰',
        '౷',
        '಄',
        '෴',
        '๏',
        '༔',
        '྅',
        '჻',
        '᙮',
        '᳓',
        '⁓',
        '⵰',
        '⸋',
        '⸛',
        '⹁',
        '⹒',
        '〽',
        '・',
        '꙳',
        '꙾',
        '꣼',
        '꥟',
        '꯫'
    ),
    CONTROL(
        keys("Cc", "Control"),
        "an ASCII or Latin-1 control character",
        UnicodeCategoryConstants.BASIC_LATIN_TO_LATIN_1_SUPPLEMENT
    ),
    FORMAT(
        keys("Cf", "Format"),
        "invisible formatting indicator.",
        listOf<SymbolRange>(
            UnicodeCategoryConstants.ARABIC_SUBTENDING_MARKS_TO_SUBTENDING_MARKS,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_FORMAT_CHARACTERS,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_FORMAT_CHARACTERS_1,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_FORMAT_CHARACTER_TO_INVISIBLE_OPERATORS,
            UnicodeCategoryConstants.GENERAL_PUNCTUATION_FORMAT_CHARACTERS_TO_DEPRECATED
        ),
        '­',
        '؜',
        '۝',
        '܏',
        '࣢',
        '᠎'
    ),

    /*NO_CHANGE*/
    PRIVATE_USE(keys("Co", "Private_Use"), "any code point reserved for private use.", SymbolRange.range('', '')),
    IN_BASIC_LATIN(
        keys("InBasic_Latin", "Latin"),
        "32-U+007F",
        UnicodeCategoryConstants.BASIC_LATIN_ASCII_PUNCTUATION_AND_SYMBOLS_TO_ASCII_PUNCTUATION_AND_SYMBOLS
    ),
    IN_IPA_EXTENSIONS(
        keys("InIPA_Extensions"),
        "U+0250-U+02AF",
        UnicodeCategoryConstants.IPA_EXTENSIONS_IPA_EXTENSIONS_TO_ADDITIONS_FOR_SINOLOGY
    ),
    IN_SPACING_MODIFIER_LETTERS(
        keys("InSpacing_Modifier_Letters"),
        "U+02B0-U+02FF",
        UnicodeCategoryConstants.SPACING_MODIFIER_LETTERS_LATIN_SUPERSCRIPT_MODIFIER_LETTERS_TO_UPA_MODIFIERS
    ),
    IN_COMBINING_DIACRITICAL_MARKS(
        keys("InCombining_Diacritical_Marks"),
        "U+0300-U+036F",
        UnicodeCategoryConstants.COMBINING_DIACRITICAL_MARKS_ORDINARY_DIACRITICS_TO_MEDIEVAL_SUPERSCRIPT_LETTER_DIACRITICS
    ),

    IN_CYRILLIC(
        keys("InCyrillic", "Cyrillic"),
        "U+0400-U+04FF",
        UnicodeCategoryConstants.CYRILLIC_CYRILLIC_EXTENSIONS_TO_ADDITIONS_FOR_NIVKH
    ),
    IN_CYRILLIC_SUPPLEMENTARY(
        keys("InCyrillic_Supplementary"),
        "U+0500-U+052F",
        UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_KOMI_LETTERS_TO_KHANTY_LETTERS
    ),
    IN_ARMENIAN(
        keys("InArmenian", "Armenian"),
        "U+0530-U+058F",
        UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_ARMENIAN_TO_RELIGIOUS_SYMBOLS
    ),
    IN_HEBREW(
        keys("InHebrew", "Hebrew"),
        "U+0590-U+05FF",
        UnicodeCategoryConstants.CYRILLIC_SUPPLEMENT_HEBREW_TO_ADDITIONAL_PUNCTUATION
    ),
    IN_ARABIC(
        keys("InArabic", "Arabic"),
        "U+0600-U+06FF",
        UnicodeCategoryConstants.ARABIC_SUBTENDING_MARKS_TO_SIGNS_FOR_SINDHI
    ),
    IN_SYRIAC(
        keys("InSyriac", "Syriac"),
        "U+0700-U+074F",
        UnicodeCategoryConstants.SYRIAC_SYRIAC_PUNCTUATION_AND_SIGNS_TO_SOGDIAN_LETTERS
    ),
    IN_THAANA(
        keys("InThaana", "Thaana"),
        "U+0780-U+07BF",
        UnicodeCategoryConstants.THAANA_BASIC_CONSONANTS_TO_CONSONANT_FOR_ADDU_DIALECT
    ),
    IN_DEVANAGARI(
        keys("InDevanagari", "Devanagari"),
        "U+0900-U+097F",
        UnicodeCategoryConstants.DEVANAGARI_VARIOUS_SIGNS_TO_SINDHI_IMPLOSIVES
    ),
    IN_BENGALI(keys("InBengali", "Bengali"), "U+0980-U+09FF", UnicodeCategoryConstants.BENGALI_VARIOUS_SIGNS_TO_SIGNS),
    IN_GURMUKHI(keys("InGurmukhi", "Gurmukhi"), "U+0A00-U+0A7F", UnicodeCategoryConstants.BENGALI_GURMUKHI_TO_SIGNS),
    IN_GUJARATI(
        keys("InGujarati", "Gujarati"),
        "U+0A80-U+0AFF",
        UnicodeCategoryConstants.BENGALI_GUJARATI_TO_TRANSLITERATION_SIGNS
    ),
    IN_ORIYA(keys("InOriya", "Oriya"), "U+0B00-U+0B7F", UnicodeCategoryConstants.BENGALI_ORIYA_TO_FRACTION_SIGNS),
    IN_TAMIL(
        keys("InTamil", "Tamil"),
        "U+0B80-U+0BFF",
        UnicodeCategoryConstants.BENGALI_TAMIL_TO_TAMIL_CLERICAL_SYMBOL
    ),
    IN_TELUGU(
        keys("InTelugu", "Telugu"),
        "U+0C00-U+0C7F",
        UnicodeCategoryConstants.TELUGU_VARIOUS_SIGNS_TO_TELUGU_FRACTIONS_AND_WEIGHTS
    ),
    IN_KANNADA(
        keys("InKannada", "Kannada"),
        "U+0C80-U+0CFF",
        UnicodeCategoryConstants.KANNADA_VARIOUS_SIGNS_TO_SIGNS_USED_IN_SANSKRIT
    ),
    IN_MALAYALAM(
        keys("InMalayalam", "Malayalam"),
        "U+0D00-U+0D7F",
        UnicodeCategoryConstants.MALAYALAM_VARIOUS_SIGNS_TO_CHILLU_LETTERS
    ),
    IN_SINHALA(
        keys("InSinhala", "Sinhala"),
        "U+0D80-U+0DFF",
        UnicodeCategoryConstants.MALAYALAM_SINHALA_TO_PUNCTUATION
    ),
    IN_THAI(keys("InThai", "Thai"), "U+0E00-U+0E7F", UnicodeCategoryConstants.MALAYALAM_THAI_TO_SIGNS),
    IN_LAO(keys("InLao", "Lao"), "U+0E80-U+0EFF", UnicodeCategoryConstants.MALAYALAM_LAO_TO_CONSONANTS_FOR_KHMU),
    IN_TIBETAN(
        keys("InTibetan", "Tibetan"),
        "U+0F00-U+0FFF",
        UnicodeCategoryConstants.TIBETAN_SYLLABLE_TO_ANNOTATION_MARKS
    ),
    IN_MYANMAR(
        keys("InMyanmar", "Myanmar"),
        "U+1000-U+109F",
        UnicodeCategoryConstants.MYANMAR_CONSONANTS_TO_SHAN_SYMBOLS
    ),
    IN_GEORGIAN(
        keys("InGeorgian", "Georgian"),
        "U+10A0-U+10FF",
        UnicodeCategoryConstants.GEORGIAN_CAPITAL_LETTERS_KHUTSURI_TO_ADDITIONAL_LETTERS_FOR_OSSETIAN_AND_ABKHAZ
    ),
    IN_HANGUL_JAMO(
        keys("InHangul_Jamo", "Hangul"),
        "U+1100-U+11FF",
        UnicodeCategoryConstants.HANGUL_JAMO_INITIAL_CONSONANTS_TO_OLD_FINAL_CONSONANTS
    ),
    IN_ETHIOPIC(
        keys("InEthiopic", "Ethiopic"),
        "U+1200-U+137F",
        UnicodeCategoryConstants.ETHIOPIC_SYLLABLES_TO_NUMBERS
    ),
    IN_CHEROKEE(
        keys("InCherokee", "Cherokee"),
        "U+13A0-U+13FF",
        UnicodeCategoryConstants.CHEROKEE_UPPERCASE_SYLLABLES_TO_ARCHAIC_LOWERCASE_SYLLABLE
    ),
    IN_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS(
        keys("InUnified_Canadian_Aboriginal_Syllabics", "Canadian_Aboriginal"),
        "U+1400-U+167F",
        UnicodeCategoryConstants.UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_PUNCTUATION_TO_SYLLABLES
    ),
    IN_OGHAM(keys("InOgham", "Ogham"), "U+1680-U+169F", UnicodeCategoryConstants.OGHAM_SPACE_TO_PUNCTUATION),
    IN_RUNIC(
        keys("InRunic", "Runic"),
        "U+16A0-U+16FF",
        UnicodeCategoryConstants.RUNIC_LETTERS_TO_CRYPTOGRAMMIC_LETTERS
    ),
    IN_TAGALOG(
        keys("InTagalog", "Tagalog"),
        "U+1700-U+171F",
        UnicodeCategoryConstants.TAGALOG_INDEPENDENT_VOWELS_TO_VIRAMAS
    ),
    IN_HANUNOO(
        keys("InHanunoo", "Hanunoo"),
        "U+1720-U+173F",
        UnicodeCategoryConstants.HANUNOO_INDEPENDENT_VOWELS_TO_GENERIC_PUNCTUATION_FOR_PHILIPPINE_SCRIPTS
    ),
    IN_BUHID(
        keys("InBuhid", "Buhid"),
        "U+1740-U+175F",
        UnicodeCategoryConstants.BUHID_INDEPENDENT_VOWELS_TO_DEPENDENT_VOWEL_SIGNS
    ),
    IN_TAGBANWA(
        keys("InTagbanwa", "Tagbanwa"),
        "U+1760-U+177F",
        UnicodeCategoryConstants.TAGBANWA_INDEPENDENT_VOWELS_TO_DEPENDENT_VOWEL_SIGNS
    ),
    IN_KHMER(
        keys("InKhmer", "Khmer"),
        "U+1780-U+17FF",
        UnicodeCategoryConstants.KHMER_CONSONANTS_TO_NUMERIC_SYMBOLS_FOR_DIVINATION_LORE
    ),
    IN_MONGOLIAN(
        keys("InMongolian", "Mongolian"),
        "U+1800-U+18AF",
        UnicodeCategoryConstants.MONGOLIAN_PUNCTUATION_TO_EXTENSIONS_FOR_SANSKRIT_AND_TIBETAN
    ),
    IN_LIMBU(keys("InLimbu", "Limbu"), "U+1900-U+194F", UnicodeCategoryConstants.LIMBU_CONSONANTS_TO_DIGITS),
    IN_TAI_LE(keys("InTai_Le"), "U+1950-U+197F", UnicodeCategoryConstants.TAI_LE_CONSONANTS_TO_TONE_LETTERS),
    IN_KHMER_SYMBOLS(
        keys("InKhmer_Symbols"),
        "U+19E0-U+19FF",
        UnicodeCategoryConstants.KHMER_SYMBOLS_LUNAR_DATE_SYMBOLS
    ),
    IN_PHONETIC_EXTENSIONS(
        keys("InPhonetic_Extensions"),
        "U+1D00-U+1D7F",
        UnicodeCategoryConstants.PHONETIC_EXTENSIONS_LATIN_LETTERS_TO_OTHER_PHONETIC_SYMBOLS
    ),
    IN_LATIN_EXTENDED_ADDITIONAL(
        keys("InLatin_Extended_Additional"),
        "U+1E00-U+1EFF",
        UnicodeCategoryConstants.LATIN_EXTENDED_ADDITIONAL_LATIN_GENERAL_USE_EXTENSIONS_TO_MEDIEVALIST_ADDITIONS
    ),
    IN_GREEK_EXTENDED(
        keys("InGreek_Extended", "Greek"),
        "U+1F00-U+1FFF",
        UnicodeCategoryConstants.GREEK_EXTENDED_PRECOMPOSED_POLYTONIC_GREEK
    ),
    IN_GENERAL_PUNCTUATION(
        keys("InGeneral_Punctuation"),
        "U+2000-U+206F",
        UnicodeCategoryConstants.GENERAL_PUNCTUATION_SPACES_TO_DEPRECATED
    ),
    IN_SUPERSCRIPTS_AND_SUBSCRIPTS(
        keys("InSuperscripts_and_Subscripts"),
        "U+2070-U+209F",
        UnicodeCategoryConstants.SUPERSCRIPTS_AND_SUBSCRIPTS_SUPERSCRIPTS_TO_SUBSCRIPTS_FOR_UPA
    ),
    IN_CURRENCY_SYMBOLS(
        keys("InCurrency_Symbols"),
        "U+20A0-U+20CF",
        UnicodeCategoryConstants.CURRENCY_SYMBOLS_CURRENCY_SYMBOLS
    ),
    IN_LETTERLIKE_SYMBOLS(
        keys("InLetterlike_Symbols"),
        "U+2100-U+214F",
        UnicodeCategoryConstants.LETTERLIKE_SYMBOLS_LETTERLIKE_SYMBOLS_TO_LOWERCASE_CLAUDIAN_LETTER
    ),
    IN_NUMBER_FORMS(
        keys("InNumber_Forms"),
        "U+2150-U+218F",
        UnicodeCategoryConstants.NUMBER_FORMS_FRACTIONS_TO_TURNED_DIGITS
    ),
    IN_ARROWS(keys("InArrows"), "U+2190-U+21FF", UnicodeCategoryConstants.ARROWS_SIMPLE_ARROWS_TO_MISCELLANEOUS_ARROWS),
    IN_MATHEMATICAL_OPERATORS(
        keys("InMathematical_Operators"),
        "U+2200-U+22FF",
        UnicodeCategoryConstants.MATHEMATICAL_OPERATORS_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_TO_RELATIONS
    ),
    IN_MISCELLANEOUS_TECHNICAL(
        keys("InMiscellaneous_Technical"),
        "U+2300-U+23FF",
        UnicodeCategoryConstants.MISCELLANEOUS_TECHNICAL_MISCELLANEOUS_TECHNICAL_TO_POWER_SYMBOL_FROM_IEEE_1621_2004
    ),
    IN_CONTROL_PICTURES(
        keys("InControl_Pictures"),
        "U+2400-U+243F",
        UnicodeCategoryConstants.CONTROL_PICTURES_GRAPHIC_PICTURES_FOR_CONTROL_CODES_TO_SPECIFIC_SYMBOL_FOR_CONTROL_CODE
    ),
    IN_OPTICAL_CHARACTER_RECOGNITION(
        keys("InOptical_Character_Recognition"),
        "U+2440-U+245F",
        UnicodeCategoryConstants.OPTICAL_CHARACTER_RECOGNITION_OCR_A_TO_OCR
    ),
    IN_ENCLOSED_ALPHANUMERICS(
        keys("InEnclosed_Alphanumerics"),
        "U+2460-U+24FF",
        UnicodeCategoryConstants.ENCLOSED_ALPHANUMERICS_CIRCLED_NUMBERS_TO_DOUBLE_CIRCLED_NUMBERS
    ),
    IN_BOX_DRAWING(
        keys("InBox_Drawing"),
        "U+2500-U+257F",
        UnicodeCategoryConstants.BOX_DRAWING_LIGHT_AND_HEAVY_SOLID_LINES_TO_MIXED_LIGHT_AND_HEAVY_LINES
    ),
    IN_BLOCK_ELEMENTS(
        keys("InBlock_Elements"),
        "U+2580-U+259F",
        UnicodeCategoryConstants.BLOCK_ELEMENTS_BLOCK_ELEMENTS_TO_TERMINAL_GRAPHIC_CHARACTERS
    ),
    IN_GEOMETRIC_SHAPES(
        keys("InGeometric_Shapes"),
        "U+25A0-U+25FF",
        UnicodeCategoryConstants.GEOMETRIC_SHAPES_GEOMETRIC_SHAPES_TO_GEOMETRIC_SHAPES
    ),
    IN_MISCELLANEOUS_SYMBOLS(
        keys("InMiscellaneous_Symbols"),
        "U+2600-U+26FF",
        UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_WEATHER_AND_ASTROLOGICAL_SYMBOLS_TO_MAP_SYMBOLS_FROM_ARIB_STD_B24
    ),
    IN_DINGBATS(keys("InDingbats"), "U+2700-U+27BF", UnicodeCategoryConstants.DINGBATS_MISCELLANEOUS_TO_DINGBAT_ARROWS),
    IN_BRAILLE_PATTERNS(
        keys("InBraille_Patterns", "Braille"),
        "U+2800-U+28FF",
        UnicodeCategoryConstants.BRAILLE_PATTERNS_BRAILLE_PATTERNS
    ),
    IN_SUPPLEMENTAL_MATHEMATICAL_OPERATORS(
        keys("InSupplemental_Mathematical_Operators"),
        "U+2A00-U+2AFF",
        UnicodeCategoryConstants.SUPPLEMENTAL_MATHEMATICAL_OPERATORS_N_ARY_OPERATORS_TO_OPERATORS
    ),
    IN_MISCELLANEOUS_SYMBOLS_AND_ARROWS(
        keys("InMiscellaneous_Symbols_and_Arrows"),
        "U+2B00-U+2BFF",
        UnicodeCategoryConstants.MISCELLANEOUS_SYMBOLS_AND_ARROWS_WHITE_AND_BLACK_ARROWS_TO_SYMBOLS_USED_IN_CHESS_NOTATION
    ),
    IN_CJK_RADICALS_SUPPLEMENT(
        keys("InCJK_Radicals_Supplement"),
        "U+2E80-U+2EFF",
        UnicodeCategoryConstants.CJK_RADICALS_SUPPLEMENT_CJK_RADICALS_SUPPLEMENT
    ),
    IN_KANGXI_RADICALS(
        keys("InKangxi_Radicals"),
        "U+2F00-U+2FDF",
        UnicodeCategoryConstants.KANGXI_RADICALS_KANGXI_RADICALS_SUBSET_1
    ),
    IN_IDEOGRAPHIC_DESCRIPTION_CHARACTERS(
        keys("InIdeographic_Description_Characters"),
        "U+2FF0-U+2FFF",
        UnicodeCategoryConstants.IDEOGRAPHIC_DESCRIPTION_CHARACTERS_IDEOGRAPHIC_DESCRIPTION_CHARACTERS
    ),
    IN_CJK_SYMBOLS_AND_PUNCTUATION(
        keys("InCJK_Symbols_and_Punctuation"),
        "U+3000-U+303F",
        UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_CJK_SYMBOLS_AND_PUNCTUATION_TO_SPECIAL_CJK_INDICATORS
    ),
    IN_HIRAGANA(
        keys("InHiragana", "Hiragana"),
        "U+3040-U+309F",
        UnicodeCategoryConstants.CJK_SYMBOLS_AND_PUNCTUATION_HIRAGANA_TO_ITERATION_MARKS
    ),
    IN_KATAKANA(
        keys("InKatakana", "Katakana"),
        "U+30A0-U+30FF",
        UnicodeCategoryConstants.KATAKANA_KATAKANA_PUNCTUATION_TO_ITERATION_MARKS
    ),
    IN_BOPOMOFO(
        keys("InBopomofo", "Bopomofo"),
        "U+3100-U+312F",
        UnicodeCategoryConstants.KATAKANA_BOPOMOFO_TO_MISCELLANEOUS_ADDITIONS
    ),
    IN_HANGUL_COMPATIBILITY_JAMO(
        keys("InHangul_Compatibility_Jamo"),
        "U+3130-U+318F",
        UnicodeCategoryConstants.KATAKANA_HANGUL_COMPATIBILITY_JAMO_TO_OLD_VOWEL_LETTERS
    ),
    IN_KANBUN(keys("InKanbun"), "U+3190-U+319F", UnicodeCategoryConstants.KANBUN_TATETEN_TO_KAERITEN),
    IN_BOPOMOFO_EXTENDED(
        keys("InBopomofo_Extended"),
        "U+31A0-U+31BF",
        UnicodeCategoryConstants.BOPOMOFO_EXTENDED_EXTENDED_BOPOMOFO_FOR_MINNAN_AND_HAKKA_TO_EXTENDED_BOPOMOFO_FOR_CANTONESE
    ),
    IN_KATAKANA_PHONETIC_EXTENSIONS(
        keys("InKatakana_Phonetic_Extensions"),
        "U+31F0-U+31FF",
        UnicodeCategoryConstants.KATAKANA_PHONETIC_EXTENSIONS_PHONETIC_EXTENSIONS_FOR_AINU
    ),
    IN_ENCLOSED_CJK_LETTERS_AND_MONTHS(
        keys("InEnclosed_CJK_Letters_and_Months"),
        "U+3200-U+32FF",
        UnicodeCategoryConstants.ENCLOSED_CJK_LETTERS_AND_MONTHS_PARENTHESIZED_HANGUL_LETTERS_TO_CIRCLED_KATAKANA
    ),
    IN_CJK_COMPATIBILITY(
        keys("InCJK_Compatibility"),
        "U+3300-U+33FF",
        UnicodeCategoryConstants.CJK_COMPATIBILITY_SQUARED_KATAKANA_WORDS_TO_TELEGRAPH_SYMBOLS_FOR_DAYS
    ),
    IN_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A(
        keys("InCJK_Unified_Ideographs_Extension_A"),
        "U+3400-U+4DBF",
        UnicodeCategoryConstants.CJK_COMPATIBILITY_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
    ),
    IN_YIJING_HEXAGRAM_SYMBOLS(
        keys("InYijing_Hexagram_Symbols", "Yi"),
        "U+4DC0-U+4DFF",
        UnicodeCategoryConstants.YIJING_HEXAGRAM_SYMBOLS_YIJING_HEXAGRAM_SYMBOLS
    ),
    IN_CJK_UNIFIED_IDEOGRAPHS(
        keys("InCJK_Unified_Ideographs"),
        "U+4E00-U+9FFF",
        UnicodeCategoryConstants.YIJING_HEXAGRAM_SYMBOLS_CJK_UNIFIED_IDEOGRAPHS
    ),
    IN_YI_SYLLABLES(
        keys("InYi_Syllables"),
        "U+A000-U+A48F",
        UnicodeCategoryConstants.YI_SYLLABLES_SYLLABLES_TO_SYLLABLES_1
    ),
    IN_YI_RADICALS(keys("InYi_Radicals"), "U+A490-U+A4CF", UnicodeCategoryConstants.YI_RADICALS_YI_RADICALS),
    IN_HANGUL_SYLLABLES(
        keys("InHangul_Syllables"),
        "U+AC00-U+D7AF",
        UnicodeCategoryConstants.MEETEI_MAYEK_HANGUL_SYLLABLES
    ),
    IN_PRIVATE_USE_AREA(keys("InPrivate_Use_Area"), "U+E000-U+F8FF", SymbolRange.range(0xE000, 0xF8FF)),
    IN_CJK_COMPATIBILITY_IDEOGRAPHS(
        keys("InCJK_Compatibility_Ideographs"),
        "U+F900-U+FAFF",
        SymbolRange.range(0xF900, 0xFAFF)
    ),
    IN_ALPHABETIC_PRESENTATION_FORMS(
        keys("InAlphabetic_Presentation_Forms"),
        "U+FB00-U+FB4F",
        SymbolRange.range(0xFB00, 0xFB4F)
    ),
    IN_VARIATION_SELECTORS(keys("InVariation_Selectors"), "U+FE00-U+FE0F", SymbolRange.range(0xFE00, 0xFE0F)),
    IN_COMBINING_HALF_MARKS(keys("InCombining_Half_Marks"), "U+FE20-U+FE2F", SymbolRange.range(0xFE20, 0xFE2F)),
    IN_CJK_COMPATIBILITY_FORMS(keys("InCJK_Compatibility_Forms"), "U+FE30-U+FE4F", SymbolRange.range(0xFE30, 0xFE4F)),
    IN_SMALL_FORM_VARIANTS(keys("InSmall_Form_Variants"), "U+FE50-U+FE6F", SymbolRange.range(0xFE50, 0xFE6F)),
    IN_HALFWIDTH_AND_FULLWIDTH_FORMS(
        keys("InHalfwidth_and_Fullwidth_Forms"),
        "U+FF00-U+FFEF",
        SymbolRange.range(0xFF00, 0xFFEF)
    ),
    IN_SPECIALS(keys("InSpecials"), "U+FFF0-U+FFFF", SymbolRange.range(0xFFF0, 0xFFFF)),
    ; // =============================================================================================
    // Below this line categories are disabled because I'm having troubles generating these values.
    // Please open a feature ticket if these are needed - then I'll invest time in those.
    //IN_LATIN_1_SUPPLEMENT(keys("InLatin-1_Supplement"), "U+0080-U+00FF", range(0x0080, 0x00FF)),
    //IN_LATIN_EXTENDED_A(keys("InLatin_Extended-A"), "U+0100-U+017F", range(0x0100, 0x017F)),
    //IN_LATIN_EXTENDED_B(keys("InLatin_Extended-B"), "U+0180-U+024F", range(0x0180, 0x024F)),
    //IN_GREEK_AND_COPTIC(keys("InGreek_and_Coptic"), "U+0370-U+03FF", range(0x0370, 0x03FF)),
    //CASED_LETTER(keys("L&", "Cased_Letter"), "a letter that exists in lowercase and uppercase variants (combination of Ll, Lu and Lt).", asList(LATIN_UPPERCASE, LATIN_LOWERCASE, range('À', 'Ö'), range('Ø', 'ö'), range('ø', 'İ'), range('Ĳ', 'ķ'), range('Ĺ', 'ň'), range('Ŋ', 'ž'), range('ƀ', 'ƌ'), range('Ǝ', 'ƚ'), range('Ɯ', 'Ʃ'), range('Ƭ', 'ƹ'), range('Ƽ', 'ƽ'), range('ǆ', 'Ǉ'), range('ǉ', 'Ǌ'), range('ǌ', 'ǯ'), range('ǳ', 'Ƞ'), range('Ȣ', 'ȳ'), range('Ⱥ', 'ɔ'), range('ɖ', 'ɗ'), range('ɛ', 'ɜ'), range('ɠ', 'ɡ'), range('ɥ', 'ɦ'), range('ɨ', 'ɬ'), range('ɱ', 'ɲ'), range('ʇ', 'ʌ'), range('ʝ', 'ʞ'), range('Ͱ', 'ͳ'), range('Ͷ', 'ͷ'), range('ͻ', 'ͽ'), range('Έ', 'Ί'), range('Ύ', 'Ώ'), range('Α', 'Ρ'), range('Σ', 'ί'), range('α', 'ρ'), range('σ', 'Ϗ'), range('ϗ', 'ϯ'), range('ϲ', 'ϴ'), range('Ϸ', 'ϻ'), range('Ͻ', 'ҁ'), range('Ҋ', 'ԯ'), range('Ա', 'Ֆ'), range('ա', 'ֆ'), range('Ⴀ', 'Ⴥ'), range('Ꭰ', 'Ᏽ'), range('ᏸ', 'ᏽ'), range('Ḁ', 'ẕ'), range('Ạ', 'ἕ'), range('Ἐ', 'Ἕ'), range('ἠ', 'ὅ'), range('Ὀ', 'Ὅ'), range('Ὗ', 'ώ'), range('ᾰ', 'ᾱ'), range('Ᾰ', 'Ά'), range('Ὲ', 'Ή'), range('ῐ', 'ῑ'), range('Ῐ', 'Ί'), range('ῠ', 'ῡ'), range('Ῠ', 'Ῥ'), range('Ὸ', 'Ώ'), range('K', 'Å'), range('Ↄ', 'ↄ'), range('Ⰰ', 'Ⱞ'), range('ⰰ', 'ⱞ'), range('Ⱡ', 'Ɒ'), range('Ⱳ', 'ⱳ'), range('Ⱶ', 'ⱶ'), range('Ȿ', 'ⳣ'), range('Ⳬ', 'ⳮ'), range('Ⳳ', 'ⳳ'), range('ⴀ', 'ⴥ'), range('Ꙁ', 'ꙭ'), range('Ꚁ', 'ꚛ'), range('Ꜣ', 'ꜯ'), range('Ꜳ', 'ꝯ'), range('Ꝺ', 'ꞇ'), range('Ꞌ', 'Ɥ'), range('Ꞑ', 'ꞓ'), range('Ꞗ', 'Ɪ'), range('Ʞ', 'ꞷ'), range('ꭰ', 'ꮿ'), range('Ａ', 'Ｚ'), range('ａ', 'ｚ')), new char[]{'ƿ', 'Ǆ', 'Ǳ', 'ə', 'ɣ', 'ɯ', 'ɵ', 'ɽ', 'ʀ', 'ʃ', 'ʒ', 'Ϳ', 'Ά', 'Ό', 'Ⴧ', 'Ⴭ', 'ᵹ', 'ᵽ', 'ẞ', 'ὑ', 'ὓ', 'ὕ', 'ὗ', 'Ὑ', 'Ὓ', 'Ὕ', 'ῥ', 'Ω', 'Ⅎ', 'ⅎ', 'ⴧ', 'ⴭ', 'ꭓ'}),
    //IN_COMBINING_DIACRITICAL_MARKS_FOR_SYMBOLS(keys("InCombining_Diacritical_Marks_for_Symbols"), "U+20D0-U+20FF", range(0x20D0, 0x20FF)),
    //IN_SUPPLEMENTAL_ARROWS_B(keys("InSupplemental_Arrows-B"), "U+2900-U+297F", range(0x2900, 0x297F)),
    //IN_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B(keys("InMiscellaneous_Mathematical_Symbols-B"), "U+2980-U+29FF", range(0x2980, 0x29FF)),
    //IN_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A(keys("InMiscellaneous_Mathematical_Symbols-A"), "U+27C0-U+27EF", range(0x27C0, 0x27EF)),
    //IN_SUPPLEMENTAL_ARROWS_A(keys("InSupplemental_Arrows-A"), "U+27F0-U+27FF", range(0x27F0, 0x27FF)),
    //IN_ARABIC_PRESENTATION_FORMS_A(keys("InArabic_Presentation_Forms-A"), "U+FB50-U+FDFF", range(0xFB50, 0xFDFF)),
    //IN_ARABIC_PRESENTATION_FORMS_B(keys("InArabic_Presentation_Forms-B"), "U+FE70-U+FEFF", range(0xFE70, 0xFEFF)),
    //    IN_HIGH_SURROGATES(keys("InHigh_Surrogates"), "U+D800-U+DB7F", range(0xD800, 0xDB7F)),
    //    IN_HIGH_PRIVATE_USE_SURROGATES(keys("InHigh_Private_Use_Surrogates"), "U+DB80-U+DBFF", range(0xDB80, 0xDBFF))
    //    IN_LOW_SURROGATES(keys("InLow_Surrogates"), "U+DC00-U+DFFF", range(0xDC00, 0xDFFF)),
    // OTHER(keys("C", "Other"), "invisible control characters and unused code points.", asList(C1_CONTROLS, UNUSED_CODEPOINT_1, UNUSED_CODEPOINTS_2, UNUSED_CODEPOINTS_3, UNUSED_CODEPOINTS_4, UNUSED_CODEPOINTS_5, UNUSED_CODEPOINTS_6, range('׵', '؅'), range('؜', '؝'), range('܎', '܏'), UNUSED_CODEPOINTS_7, UNUSED_CODEPOINTS_8, UNUSED_CODEPOINTS_9, UNUSED_CODEPOINTS_10, UNUSED_CODEPOINTS_11, UNUSED_CODEPOINTS_12, UNUSED_CODEPOINTS_13, UNUSED_CODEPOINTS_14, UNUSED_CODEPOINTS_15, UNUSED_CODEPOINTS_16, UNUSED_CODEPOINTS_17, UNUSED_CODEPOINTS_18, UNUSED_CODEPOINTS_19, UNUSED_CODEPOINTS_20, UNUSED_CODEPOINTS_21, UNUSED_CODEPOINTS_22, RANGE_470, RANGE_16, RANGE_147, RANGE_296, RANGE_490, RANGE_610, RANGE_724, RANGE_80, RANGE_361, RANGE_122, RANGE_117, RANGE_542, RANGE_607, RANGE_280, RANGE_585, RANGE_428, RANGE_515, RANGE_659, RANGE_161, RANGE_256, RANGE_364, RANGE_579, RANGE_104, RANGE_531, RANGE_204, RANGE_439, RANGE_645, RANGE_25, RANGE_156, RANGE_479, RANGE_668, RANGE_174, RANGE_241, RANGE_390, RANGE_408, RANGE_297, RANGE_726, RANGE_276, RANGE_462, RANGE_725, RANGE_118, RANGE_546, RANGE_0, RANGE_281, RANGE_604, RANGE_400, RANGE_106, RANGE_700, RANGE_460, RANGE_567, RANGE_20, RANGE_119, RANGE_565, RANGE_169, RANGE_285, RANGE_322, RANGE_309, RANGE_442, RANGE_573, RANGE_632, RANGE_459, RANGE_202, RANGE_544, RANGE_70, RANGE_209, RANGE_292, RANGE_465, RANGE_414, RANGE_543, RANGE_728, RANGE_344, RANGE_633, RANGE_28, RANGE_369, RANGE_615, RANGE_634, RANGE_630, RANGE_523, RANGE_303, RANGE_472, RANGE_224, RANGE_732, RANGE_600, RANGE_595, RANGE_489, RANGE_448, RANGE_519, RANGE_45, RANGE_382, range('᠎', '᠏'), RANGE_349, RANGE_162, RANGE_525, RANGE_669, RANGE_363, RANGE_706, RANGE_79, RANGE_316, RANGE_463, RANGE_183, RANGE_94, RANGE_454, RANGE_380, RANGE_271, RANGE_550, RANGE_157, RANGE_590, RANGE_242, RANGE_320, RANGE_628, RANGE_267, RANGE_260, RANGE_636, RANGE_548, RANGE_416, RANGE_15, RANGE_614, RANGE_66, RANGE_192, RANGE_362, RANGE_652, RANGE_308, RANGE_172, RANGE_19, RANGE_686, range('⁠', '⁯'), RANGE_33, RANGE_223, RANGE_249, RANGE_568, RANGE_228, RANGE_625, RANGE_667, RANGE_438, RANGE_443, RANGE_480, RANGE_293, RANGE_176, RANGE_617, RANGE_279, RANGE_405, RANGE_187, RANGE_377, RANGE_464, RANGE_655, RANGE_627, RANGE_355, RANGE_431, RANGE_96, RANGE_148, RANGE_422, RANGE_510, RANGE_649, RANGE_397, RANGE_87, RANGE_597, RANGE_401, RANGE_721, RANGE_730, RANGE_447, RANGE_717, RANGE_284, RANGE_181, RANGE_381, RANGE_58, RANGE_103, RANGE_505, RANGE_613, RANGE_421, RANGE_245, RANGE_714, RANGE_240, RANGE_307, RANGE_709, RANGE_287, RANGE_478, RANGE_656, RANGE_152, RANGE_123, RANGE_373, RANGE_12, RANGE_44, range('퟼', ''), RANGE_676, RANGE_93, RANGE_321, RANGE_641, RANGE_646, RANGE_60, RANGE_315, RANGE_62, RANGE_467, RANGE_334, RANGE_622, range('﻽', '＀'), RANGE_589, RANGE_27, RANGE_227, RANGE_368, RANGE_497, range('￯', '￻')), new char[]{'­', '΋', '΍', '΢', '԰', 'ՠ', 'ֈ', '֐', '۝', '࠿', '࡟', 'ࢵ', '࣢', '঄', '঩', '঱', '৞', '਄', '਩', '਱', '਴', '਷', '਽', '੝', '઄', '઎', '઒', '઩', '઱', '઴', '૆', '૊', '଀', '଄', '଩', '଱', '଴', '୞', '஄', '஑', '஛', '஝', '௉', 'ఄ', '఍', '఑', '఩', '౅', '౉', '౗', '಄', '಍', '಑', '಩', '಴', '೅', '೉', '೟', '೰', 'ഄ', '഍', '഑', '൅', '൉', '඄', '඲', '඼', '෕', '෗', '຃', 'ຉ', 'ຘ', 'ຠ', '຤', '຦', 'ຬ', '຺', '໅', '໇', '཈', '྘', '྽', '࿍', '჆', '቉', '቗', '቙', '኉', '኱', '኿', '዁', '዗', '጑', 'ᜍ', '᝭', '᝱', '᤟', '᩟', '᷺', '὘', '὚', '὜', '὞', '᾵', '῅', '῜', '῵', '῿', '₏', '⯉', 'Ⱟ', 'ⱟ', '⴦', '⶧', '⶯', '⶷', '⶿', '⷇', '⷏', '⷗', '⷟', '⺚', '぀', '㆏', '㈟', 'ꞯ', '꧎', '꧿', '꬧', '꬯', '﬷', '﬽', '﬿', '﭂', '﭅', '﹓', '﹧', '﹵', '￧', '￾'}),
    // UNASSIGNED(keys("Cn", "Unassigned"), "any code point to which no character has been assigned.", asList(UNUSED_CODEPOINT_1, UNUSED_CODEPOINTS_2, UNUSED_CODEPOINTS_3, UNUSED_CODEPOINTS_4, UNUSED_CODEPOINTS_5, UNUSED_CODEPOINTS_6, range('׵', '׿'), UNUSED_CODEPOINTS_7, UNUSED_CODEPOINTS_8, UNUSED_CODEPOINTS_9, UNUSED_CODEPOINTS_10, UNUSED_CODEPOINTS_11, UNUSED_CODEPOINTS_12, UNUSED_CODEPOINTS_13, UNUSED_CODEPOINTS_14, UNUSED_CODEPOINTS_15, UNUSED_CODEPOINTS_16, UNUSED_CODEPOINTS_17, UNUSED_CODEPOINTS_18, UNUSED_CODEPOINTS_19, UNUSED_CODEPOINTS_20, UNUSED_CODEPOINTS_21, UNUSED_CODEPOINTS_22, RANGE_470, RANGE_16, RANGE_147, RANGE_296, RANGE_490, RANGE_610, RANGE_724, RANGE_80, RANGE_361, RANGE_122, RANGE_117, RANGE_542, RANGE_607, RANGE_280, RANGE_585, RANGE_428, RANGE_515, RANGE_659, RANGE_161, RANGE_256, RANGE_364, RANGE_579, RANGE_104, RANGE_531, RANGE_204, RANGE_439, RANGE_645, RANGE_25, RANGE_156, RANGE_479, RANGE_668, RANGE_174, RANGE_241, RANGE_390, RANGE_408, RANGE_297, RANGE_726, RANGE_276, RANGE_462, RANGE_725, RANGE_118, RANGE_546, RANGE_0, RANGE_281, RANGE_604, RANGE_400, RANGE_106, RANGE_700, RANGE_460, RANGE_567, RANGE_20, RANGE_119, RANGE_565, RANGE_169, RANGE_285, RANGE_322, RANGE_309, RANGE_442, RANGE_573, RANGE_632, RANGE_459, RANGE_202, RANGE_544, RANGE_70, RANGE_209, RANGE_292, RANGE_465, RANGE_414, RANGE_543, RANGE_728, RANGE_344, RANGE_633, RANGE_28, RANGE_369, RANGE_615, RANGE_634, RANGE_630, RANGE_523, RANGE_303, RANGE_472, RANGE_224, RANGE_732, RANGE_600, RANGE_595, RANGE_489, RANGE_448, RANGE_519, RANGE_45, RANGE_382, RANGE_349, RANGE_162, RANGE_525, RANGE_669, RANGE_363, RANGE_706, RANGE_79, RANGE_316, RANGE_463, RANGE_183, RANGE_94, RANGE_454, RANGE_380, RANGE_271, RANGE_550, RANGE_157, RANGE_590, RANGE_242, RANGE_320, RANGE_628, RANGE_267, RANGE_260, RANGE_636, RANGE_548, RANGE_416, RANGE_15, RANGE_614, RANGE_66, RANGE_192, RANGE_362, RANGE_652, RANGE_308, RANGE_172, RANGE_33, RANGE_223, RANGE_249, RANGE_568, RANGE_228, RANGE_625, RANGE_667, RANGE_438, RANGE_443, RANGE_480, RANGE_293, RANGE_176, RANGE_617, RANGE_279, RANGE_405, RANGE_187, RANGE_377, RANGE_464, RANGE_655, RANGE_627, RANGE_355, RANGE_431, RANGE_96, RANGE_148, RANGE_422, RANGE_510, RANGE_649, RANGE_397, RANGE_87, RANGE_597, RANGE_401, RANGE_721, RANGE_730, RANGE_447, RANGE_717, RANGE_284, RANGE_181, RANGE_381, RANGE_58, RANGE_103, RANGE_505, RANGE_613, RANGE_421, RANGE_245, RANGE_714, RANGE_240, RANGE_307, RANGE_709, RANGE_287, RANGE_478, RANGE_656, RANGE_152, RANGE_123, RANGE_373, RANGE_12, RANGE_44, range('퟼', '퟿'), RANGE_676, RANGE_93, RANGE_321, RANGE_641, RANGE_646, RANGE_60, RANGE_315, RANGE_62, RANGE_467, RANGE_334, RANGE_622, range('﻽', '﻾'), RANGE_589, RANGE_27, RANGE_227, RANGE_368, RANGE_497, range('￯', '￸')), new char[]{'΋', '΍', '΢', '԰', 'ՠ', 'ֈ', '֐', '؝', '܎', '࠿', '࡟', 'ࢵ', '঄', '঩', '঱', '৞', '਄', '਩', '਱', '਴', '਷', '਽', '੝', '઄', '઎', '઒', '઩', '઱', '઴', '૆', '૊', '଀', '଄', '଩', '଱', '଴', '୞', '஄', '஑', '஛', '஝', '௉', 'ఄ', '఍', '఑', '఩', '౅', '౉', '౗', '಄', '಍', '಑', '಩', '಴', '೅', '೉', '೟', '೰', 'ഄ', '഍', '഑', '൅', '൉', '඄', '඲', '඼', '෕', '෗', '຃', 'ຉ', 'ຘ', 'ຠ', '຤', '຦', 'ຬ', '຺', '໅', '໇', '཈', '྘', '྽', '࿍', '჆', '቉', '቗', '቙', '኉', '኱', '኿', '዁', '዗', '጑', 'ᜍ', '᝭', '᝱', '᠏', '᤟', '᩟', '᷺', '὘', '὚', '὜', '὞', '᾵', '῅', '῜', '῵', '῿', '⁥', '₏', '⯉', 'Ⱟ', 'ⱟ', '⴦', '⶧', '⶯', '⶷', '⶿', '⷇', '⷏', '⷗', '⷟', '⺚', '぀', '㆏', '㈟', 'ꞯ', '꧎', '꧿', '꬧', '꬯', '﬷', '﬽', '﬿', '﭂', '﭅', '﹓', '﹧', '﹵', '＀', '￧', '￾'}),
    // ===========================================================================================
    // Help needed - unable to find exact list of codepoints in COMMON category
    //COMMON("Common", "", null, null),

    constructor(keys: List<String>, description: String, symbolRange: SymbolRange, symbols: CharArray) : this(
        keys,
        description,
        listOf<SymbolRange>(symbolRange),
        *symbols
    )

    constructor(keys: List<String>, description: String, vararg symbols: Char) : this(
        keys,
        description,
        emptyList<SymbolRange>(),
        *symbols
    )

    constructor(keys: List<String>, description: String, symbolRange: SymbolRange) : this(
        keys,
        description,
        listOf<SymbolRange>(symbolRange),
        *ConstantsProvider.ZERO_LENGTH_CHARACTER_ARRAY
    )

    fun contains(c: Char): Boolean {
        for (symbolRange in symbolRanges) {
            if (symbolRange.contains(c.code)) {
                return true
            }
        }

        for (symbol in symbols) {
            if (symbol == c) {
                return true
            }
        }

        return false
    }

    companion object {
        @JvmField
        val ALL_CATEGORIES: Map<String, UnicodeCategory> = entries
                .flatMap{ unicodeCategory: UnicodeCategory -> allowUseOfHyphenOrSpacesOrUnderscores(unicodeCategory) }
                .toMap()


        private fun allowUseOfHyphenOrSpacesOrUnderscores(unicodeCategory: UnicodeCategory): List<Pair<String, UnicodeCategory>> {
            val keys = Util.makeVariations(unicodeCategory.keys, '_', ' ', '-')
            return keys.map { key: String -> key to unicodeCategory }
        }
    }
}

private fun keys(vararg keys: String): List<String> {
    return listOf(*keys)
}
