/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.db.main;

import com.yikuni.db.main.Table;
import java.io.File;
import java.io.IOException;

public abstract class SerializeStrategy
implements Runnable {
    protected Table table;
    protected File file;

    protected abstract void load();

    public abstract void save();

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.table.getDb().getSaveGap());
                    this.save();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
        this.file = new File(table.getDb().getSavePath(), table.getName() + this.getSuffix());
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    protected abstract String getSuffix();
}

