/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.db.main;

import com.yikuni.db.Util.PropertiesUtil;
import com.yikuni.db.exception.YikuniDBException;
import com.yikuni.db.main.SerializeStrategy;
import com.yikuni.db.main.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;

public class Database {
    private String savePath;
    private LinkedList<Table<?>> tables;
    private Long saveGap;
    private Properties properties;

    public Database(String savePath, Long saveGap) throws YikuniDBException {
        this.saveGap = saveGap;
        this.savePath = savePath;
        this.tables = new LinkedList();
        File file = new File(savePath);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new YikuniDBException("Save Path Can Not Be a File !");
            }
            File propertiesFile = new File(file, "database.properties");
            if (propertiesFile.exists()) {
                this.loadProperties(propertiesFile);
                this.loadTables();
            } else {
                this.init();
            }
        } else {
            file.mkdirs();
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.properties = new Properties();
            this.properties.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Table<?> getTable(String tableName) {
        for (Table table : this.tables) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public <T> Table<T> getTable(String tableName, Class<T> clazz) {
        for (Table table : this.tables) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    private void loadTables() {
        String[] tableStrs;
        String tablesStr = this.properties.getProperty("tables");
        if (tablesStr == null) {
            return;
        }
        for (String tableName : tableStrs = tablesStr.split(",")) {
            this.loadTable(tableName);
        }
    }

    private <T> void loadTable(String tableName) {
        String objClassStr = this.properties.getProperty(tableName + ".objClass");
        String strategyStr = this.properties.getProperty(tableName + ".strategy");
        try {
            Class<?> objClass = Class.forName(objClassStr);
            Class<?> strategyClass = Class.forName(strategyStr);
            Table table = new Table();
            table.setName(tableName);
            table.setDb(this);
            table.setClazz(objClass);
            table.setStrategy((SerializeStrategy)strategyClass.newInstance());
            table.loadData();
            this.tables.add(table);
            Thread thread = new Thread(table.getStrategy());
            table.setSaveThread(thread);
            thread.start();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    private void init() {
        try {
            File file = new File(this.savePath, "database.properties");
            file.createNewFile();
            this.properties = new Properties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public <T> Table<T> createTable(String tableName, Class<T> elementClass) throws YikuniDBException {
        if (this.existTable(tableName)) {
            throw new YikuniDBException("Table already Exists: " + tableName);
        }
        Table<Object> table = new Table<Object>();
        table.setClazz(elementClass);
        table.setName(tableName);
        table.setDb(this);
        table.setData(new LinkedList());
        this.tables.add(table);
        return table;
    }

    public <T> Table<T> createTable(String tableName, Class<T> elementClass, SerializeStrategy strategy) throws YikuniDBException {
        Table<T> table = this.createTable(tableName, elementClass);
        this.properties.setProperty(tableName + ".objClass", elementClass.getName());
        this.onTableChange();
        table.setStrategy(strategy);
        Thread thread = new Thread(strategy);
        table.setSaveThread(thread);
        thread.start();
        this.properties.setProperty(tableName + ".strategy", strategy.getClass().getName());
        this.updateProperties();
        return table;
    }

    public boolean existTable(String tableName) {
        for (Table table : this.tables) {
            if (!table.getName().equals(tableName)) continue;
            return true;
        }
        return false;
    }

    private void onTableChange() {
        LinkedList<String> tableNames = new LinkedList<String>();
        this.tables.forEach(table -> tableNames.add(table.getName()));
        this.properties.setProperty("tables", PropertiesUtil.getListString(tableNames));
        this.updateProperties();
    }

    private void updateProperties() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.savePath, "database.properties"));
            this.properties.store(out, new SimpleDateFormat("yyyy-MM-dd mm:HH:ss").format(new Date()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save() {
        this.tables.forEach(table -> table.save());
    }

    public String getSavePath() {
        return this.savePath;
    }

    private void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    private LinkedList<Table<?>> getTables() {
        return this.tables;
    }

    private void setTables(LinkedList<Table<?>> tables) {
        this.tables = tables;
    }

    protected Long getSaveGap() {
        return this.saveGap;
    }

    private void setSaveGap(Long saveGap) {
        this.saveGap = saveGap;
    }

    private Properties getProperties() {
        return this.properties;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }
}

