/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect.loader;

import com.yikuni.mc.reflect.PluginLoader;
import com.yikuni.mc.reflect.context.ApplicationContext;
import com.yikuni.mc.reflect.key.strategy.StringReplaceStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class AbstractLoader {
    protected JavaPlugin plugin;
    protected AbstractLoader next;
    protected Class<? extends Annotation> typeAnnotation;
    protected Class<? extends Annotation> methodAnnotation;
    protected Set<Class<?>> classSet = new HashSet();

    public final void resolve(Class<?> c) {
        PluginLoader.debug("Scanned class " + c.getSimpleName());
        try {
            if (this.add(c)) {
                return;
            }
            if (this.next != null) {
                this.next.resolve(c);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public void loadClass() {
        PluginLoader.debug(this.getClass().getSimpleName() + " Totally loaded classes: " + this.classSet.size());
        this.classSet.forEach(c -> {
            try {
                Object o = this.loadClass((Class<?>)c);
                if (o != null) {
                    ApplicationContext.addContext(o.getClass(), o);
                }
                if (this.methodAnnotation != null) {
                    Method[] methods;
                    for (Method m : methods = c.getMethods()) {
                        if (m.getAnnotation(this.methodAnnotation) == null) continue;
                        this.loadMethod(m);
                    }
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        });
        if (this.next != null) {
            this.next.loadClass();
        }
    }

    abstract Object loadClass(Class<?> var1) throws ReflectiveOperationException;

    protected abstract void loadMethod(Method var1);

    protected boolean add(Class<?> c) throws ReflectiveOperationException {
        Annotation annotation = c.getAnnotation(this.typeAnnotation);
        if (annotation != null) {
            this.classSet.add(c);
            PluginLoader.debug("Add class " + c.getSimpleName());
            return true;
        }
        return false;
    }

    public void remove(Class<?> c) {
        this.classSet.remove(c);
    }

    public void setReplaceStrategy(StringReplaceStrategy strategy) {
    }

    public AbstractLoader getNext() {
        return this.next;
    }

    public void setNext(AbstractLoader next) {
        this.next = next;
    }

    public void setTypeAnnotation(Class<? extends Annotation> typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public void setMethodAnnotation(Class<? extends Annotation> methodAnnotation) {
        this.methodAnnotation = methodAnnotation;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    protected void info(String content) {
        PluginLoader.info(content);
    }
}

