/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect;

import com.yikuni.mc.reflect.common.interceptor.DefaultInterceptorDispatcher;
import com.yikuni.mc.reflect.common.interceptor.InterceptorDispatcher;
import com.yikuni.mc.reflect.context.menu.MenuFacade;
import com.yikuni.mc.reflect.loader.director.DefaultLoaderDirector;
import com.yikuni.mc.reflect.util.FileUtil;
import java.io.InputStream;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginLoader {
    public static Logger log;
    public static Settings loadSettings;
    private static Boolean isMenuFacadeRegistered;
    public static InterceptorDispatcher interceptorDispatcher;

    public static void run(Class<? extends JavaPlugin> c) {
        PluginLoader.run(c, Settings.DefaultSettings);
    }

    public static void run(Class<? extends JavaPlugin> c, Settings settings) {
        JavaPlugin plugin = JavaPlugin.getPlugin(c);
        log = plugin.getLogger();
        loadSettings = settings;
        PluginLoader.info("Spigot Reflect starting loading " + c.getSimpleName());
        PluginLoader.debug("Debug mode is on");
        PluginLoader.registerInterceptorDispatcher(plugin);
        if (settings.banner) {
            InputStream inputStream = c.getResourceAsStream("/banner.txt");
            String banner = FileUtil.readFileToString(inputStream);
            if (banner != null) {
                log.info("\n" + banner);
            } else {
                PluginLoader.debug("Failed to find banner.txt");
            }
        }
        new DefaultLoaderDirector(plugin).run();
        if (!isMenuFacadeRegistered.booleanValue()) {
            Bukkit.getPluginManager().registerEvents((Listener)new MenuFacade(), (Plugin)plugin);
            isMenuFacadeRegistered = true;
        }
        PluginLoader.info("Spigot Reflect loaded " + c.getSimpleName());
    }

    public static void info(String content) {
        if (loadSettings.log) {
            log.info(content);
        }
    }

    public static void debug(String content) {
        if (loadSettings.debug) {
            log.info(content);
        }
    }

    public static void registerInterceptorDispatcher(JavaPlugin plugin) {
        RegisteredServiceProvider dispatcher = Bukkit.getServicesManager().getRegistration(InterceptorDispatcher.class);
        if (dispatcher == null) {
            DefaultInterceptorDispatcher defaultInterceptorDispatcher = new DefaultInterceptorDispatcher();
            interceptorDispatcher = defaultInterceptorDispatcher;
            Bukkit.getServicesManager().register(InterceptorDispatcher.class, (Object)defaultInterceptorDispatcher, (Plugin)plugin, ServicePriority.Normal);
            Bukkit.getPluginManager().registerEvents((Listener)defaultInterceptorDispatcher, (Plugin)plugin);
        } else {
            interceptorDispatcher = (InterceptorDispatcher)dispatcher.getProvider();
        }
    }

    static {
        isMenuFacadeRegistered = false;
    }

    public static class Settings {
        public static final Settings DefaultSettings = new Settings(true, true, false);
        private boolean banner;
        private boolean log;
        private boolean debug;

        public Settings() {
        }

        public Settings(boolean banner, boolean log, boolean debug) {
            this.banner = banner;
            this.log = log;
            this.debug = debug;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isBanner() {
            return this.banner;
        }

        public void setBanner(boolean banner) {
            this.banner = banner;
        }

        public boolean isLog() {
            return this.log;
        }

        public void setLog(boolean log) {
            this.log = log;
        }
    }
}

