/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fileInputStream.read(b)) != -1) {
                byteArrayOutputStream.write(b, 0, n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(@Nullable InputStream in) {
        if (in == null) {
            return null;
        }
        BufferedInputStream bin = null;
        Charset charset = StandardCharsets.UTF_8;
        try {
            bin = new BufferedInputStream(in);
            byte[] bytes = new byte[1024];
            StringBuilder builder = new StringBuilder();
            while (bin.read(bytes, 0, bytes.length) != -1) {
                builder.append(new String(bytes, charset));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) {
        if (file.exists() && !file.isDirectory()) {
            FileInputStream fileInputStream = null;
            Charset charset = StandardCharsets.UTF_8;
            try {
                String result;
                fileInputStream = new FileInputStream(file);
                byte[] bytes = new byte[(int)file.length()];
                fileInputStream.read(bytes);
                String string = result = new String(bytes, charset);
                return string;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static void write(String path, String content) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileUtil.write(file, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String content) {
        FileWriter out = null;
        try {
            out = new FileWriter(file);
            out.write(content);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteFileIfExist(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void clearFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files.length != 0) {
                    for (File child : files) {
                        FileUtil.deleteFile(child);
                    }
                }
                file.delete();
            } else {
                file.delete();
            }
        }
    }
}

