/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class YikuniReflectUtil {
    public static Set<Class<?>> getClasses(String pack, Boolean recursive) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = pack;
        String packDirName = pack.replace('.', '/');
        try {
            Enumeration<URL> dirs = YikuniReflectUtil.class.getClassLoader().getResources(packDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    YikuniReflectUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String name = jarEntry.getName();
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if (!name.startsWith(packDirName)) continue;
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        packageName = name.substring(0, idx).replace('/', '.');
                    }
                    if (idx == -1 && !recursive.booleanValue() || !name.endsWith(".class") || jarEntry.isDirectory()) continue;
                    String className = name.substring(packageName.length() + 1, name.length() - 6);
                    try {
                        classes.add(Class.forName(packageName + "." + className));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, Set<Class<?>> classes) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirFiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        assert (dirFiles != null);
        for (File file2 : dirFiles) {
            if (file2.isDirectory()) {
                YikuniReflectUtil.findAndAddClassesInPackageByFile(packageName + '.' + file2.getName(), file2.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

