/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect.loader;

import com.yikuni.mc.reflect.PluginLoader;
import com.yikuni.mc.reflect.annotation.YikuniRecipe;
import com.yikuni.mc.reflect.key.strategy.NoneStrategy;
import com.yikuni.mc.reflect.key.strategy.StringReplaceStrategy;
import com.yikuni.mc.reflect.loader.AbstractLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class RecipeLoader
extends AbstractLoader {
    private StringReplaceStrategy strategy = new NoneStrategy();

    @Override
    void loadClass(Class<?> c) {
    }

    @Override
    protected void loadMethod(Method method) {
        if (!this.checkMethod(method)) {
            throw new IllegalArgumentException("Failed to load recipe " + method.getName() + " :Illegal Argument Provided");
        }
        Class<?> clazz = method.getDeclaringClass();
        try {
            Object instance = clazz.newInstance();
            YikuniRecipe annotation = method.getAnnotation(YikuniRecipe.class);
            String value = annotation.value();
            String name = value.equals("") ? this.strategy.replace(method.getName()) : value;
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, name);
            Object invoke = method.invoke(instance, key);
            Bukkit.addRecipe((Recipe)((Recipe)invoke));
            PluginLoader.log.info("Loaded Recipe: " + name);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setReplaceStrategy(StringReplaceStrategy strategy) {
        this.strategy = strategy;
    }

    private boolean checkMethod(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1 && params[0].equals(NamespacedKey.class)) {
            return Recipe.class.isAssignableFrom(method.getReturnType());
        }
        return false;
    }
}

