/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect.loader.builder;

import com.yikuni.mc.reflect.key.strategy.StringReplaceStrategy;
import com.yikuni.mc.reflect.loader.AbstractLoader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;

public class LoaderBuilder {
    private final List<AbstractLoader> loaderList = new ArrayList<AbstractLoader>();
    private final JavaPlugin plugin;

    public LoaderBuilder(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public LoaderBuilder append(AbstractLoader loader) {
        loader.setPlugin(this.plugin);
        if (this.loaderList.size() != 0) {
            AbstractLoader previous = this.loaderList.get(this.loaderList.size() - 1);
            previous.setNext(loader);
        }
        this.loaderList.add(loader);
        return this;
    }

    public LoaderBuilder typeAnnotation(Class<? extends Annotation> c) {
        AbstractLoader current = this.loaderList.get(this.loaderList.size() - 1);
        current.setTypeAnnotation(c);
        return this;
    }

    public LoaderBuilder methodAnnotation(Class<? extends Annotation> c) {
        AbstractLoader current = this.loaderList.get(this.loaderList.size() - 1);
        current.setMethodAnnotation(c);
        return this;
    }

    public LoaderBuilder replaceStrategy(StringReplaceStrategy strategy) {
        AbstractLoader current = this.loaderList.get(this.loaderList.size() - 1);
        current.setReplaceStrategy(strategy);
        return this;
    }

    public AbstractLoader build() {
        return this.loaderList.get(0);
    }
}

