/*
 * Decompiled with CFR 0.152.
 */
package com.yikuni.mc.reflect.common;

import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public abstract class Menu {
    private String name;
    private final List<Inventory> inventoryList = new LinkedList<Inventory>();
    private Menu next;
    private int size;

    public Menu() {
    }

    public Menu(@NotNull String name, @NotNull Integer size) {
        this.name = name;
        this.size = size;
    }

    public abstract void click(@NotNull InventoryClickEvent var1);

    public abstract void open(@NotNull Player var1, @NotNull Inventory var2);

    public void solveOpen(String name, Player player) {
        if (this.name.equalsIgnoreCase(name)) {
            Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)name);
            this.inventoryList.add(inventory);
            this.open(player, inventory);
            player.openInventory(inventory);
        } else if (this.next != null) {
            this.next.solveOpen(name, player);
        } else {
            this.noMenuTip(name, player);
        }
    }

    public void close(InventoryCloseEvent event) {
        if (this.inventoryList.contains(event.getInventory())) {
            this.inventoryList.remove(event.getInventory());
        } else if (this.next != null) {
            this.next.close(event);
        }
    }

    public void setNext(Menu next) {
        this.next = next;
    }

    public void solveClick(InventoryClickEvent event) {
        if (this.inventoryList.contains(event.getClickedInventory())) {
            event.setCancelled(true);
            this.click(event);
        } else if (this.next != null) {
            this.next.solveClick(event);
        }
    }

    private void noMenuTip(String name, Player player) {
        player.sendMessage(ChatColor.RED + "\u6ca1\u6709\u8fd9\u4e2a\u83dc\u5355: " + name);
    }

    public Menu getNext() {
        return this.next;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

