/*
 * Decompiled with CFR 0.152.
 */
package com.yelp.codegen;

import com.fasterxml.jackson.core.PrettyPrinter;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.codegen.config.CodegenConfigurator;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0019\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0017\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0002\u001a\u0017\u0010\t\u001a\u0004\u0018\u00010\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0082\u0002\u00a8\u0006\r"}, d2={"copySpec", "", "inputSpec", "", "outputDirectory", "main", "args", "", "([Ljava/lang/String;)V", "get", "Lorg/apache/commons/cli/CommandLine;", "opt", "", "plugin"})
@JvmName(name="Main")
public final class Main {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Options options = new Options();
        options.addRequiredOption("p", "platform", true, "The platform to generate");
        options.addRequiredOption("i", "input", true, "Path to the input spec");
        options.addRequiredOption("o", "output", true, "Path to the output directory");
        options.addRequiredOption("s", "service", true, "Name of the service to build");
        options.addRequiredOption("v", "version", true, "Version to use when generating the code.");
        options.addRequiredOption("g", "groupid", true, "The fully qualified domain name of company/organization.");
        options.addRequiredOption("a", "artifactid", true, "The artifact id to be used when generating the code.");
        options.addOption(Option.builder((String)"ignoreheaders").hasArg().argName("Comma separated list of headers to ingore").desc("A comma separated list of headers that will be ignored by the generator").build());
        CommandLineParser parser = (CommandLineParser)new DefaultParser();
        CommandLine commandLine = parser.parse(options, args);
        Intrinsics.checkExpressionValueIsNotNull((Object)commandLine, (String)"parser.parse(options, args)");
        CommandLine parsed = commandLine;
        String specVersion = Main.get(parsed, 'v');
        CodegenConfigurator configurator = new CodegenConfigurator();
        configurator.setLang(Main.get(parsed, 'p'));
        configurator.setInputSpec(Main.get(parsed, 'i'));
        configurator.setOutputDir(Main.get(parsed, 'o'));
        configurator.addAdditionalProperty("language", (Object)Main.get(parsed, 'p'));
        configurator.addAdditionalProperty("spec_version", (Object)specVersion);
        configurator.addAdditionalProperty("service_name", (Object)Main.get(parsed, 's'));
        configurator.addAdditionalProperty("group_id", (Object)Main.get(parsed, 'g'));
        configurator.addAdditionalProperty("artifact_id", (Object)Main.get(parsed, 'a'));
        configurator.addAdditionalProperty("headers_to_ignore", (Object)Main.get(parsed, "ignoreheaders"));
        new DefaultGenerator().opts(configurator.toClientOptInput()).generate();
        String string = configurator.getInputSpec();
        if (string == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = string;
        string = configurator.getOutputDir();
        String string4 = string3;
        if (string == null) {
            String string5 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        String string6 = string;
        Main.copySpec(string4, string6);
    }

    public static final void copySpec(@NotNull String inputSpec, @NotNull String outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)inputSpec, (String)"inputSpec");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Swagger swagger = new SwaggerParser().read(inputSpec);
        Json.mapper().writer((PrettyPrinter)null).writeValue(new File(outputDirectory + "/swagger.json"), (Object)swagger);
    }

    private static final String get(@NotNull CommandLine $this$get, char opt) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        return $this$get.getOptionValue(opt, null);
    }

    private static final String get(@NotNull CommandLine $this$get, String opt) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        return $this$get.getOptionValue(opt, null);
    }
}

