/*
 * Decompiled with CFR 0.152.
 */
package com.yelp.codegen.plugin;

import com.yelp.codegen.Main;
import com.yelp.codegen.plugin.FeatureConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0002J\b\u0010'\u001a\u00020%H\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR \u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR \u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR \u0010\u001e\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR \u0010!\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001a\u00a8\u0006("}, d2={"Lcom/yelp/codegen/plugin/GenerateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "extraFiles", "Ljava/io/File;", "getExtraFiles", "()Ljava/io/File;", "setExtraFiles", "(Ljava/io/File;)V", "features", "Lcom/yelp/codegen/plugin/FeatureConfiguration;", "getFeatures", "()Lcom/yelp/codegen/plugin/FeatureConfiguration;", "setFeatures", "(Lcom/yelp/codegen/plugin/FeatureConfiguration;)V", "inputFile", "getInputFile", "setInputFile", "outputDir", "getOutputDir", "setOutputDir", "packageName", "", "getPackageName", "()Ljava/lang/String;", "setPackageName", "(Ljava/lang/String;)V", "platform", "getPlatform", "setPlatform", "specName", "getSpecName", "setSpecName", "specVersion", "getSpecVersion", "setSpecVersion", "readVersionFromSpecfile", "", "specFile", "swaggerGenerate", "plugin"})
public class GenerateTask
extends DefaultTask {
    @Input
    @Optional
    @Option(option="platform", description="Configures the platform that is used for generating the code.")
    @Nullable
    private String platform;
    @Input
    @Optional
    @Option(option="packageName", description="Configures the package name of the resulting code.")
    @Nullable
    private String packageName;
    @Input
    @Optional
    @Option(option="specName", description="Configures the name of the service for the Swagger Spec.")
    @Nullable
    private String specName;
    @Input
    @Optional
    @Option(option="specVersion", description="Configures the version of the Swagger Spec.")
    @Nullable
    private String specVersion;
    @InputFile
    @Option(option="inputFile", description="Configures path of the Swagger Spec.")
    @NotNull
    public File inputFile;
    @OutputDirectory
    @Optional
    @Option(option="outputDir", description="Configures path of the Generated code directory.")
    @Nullable
    private File outputDir;
    @InputFiles
    @Optional
    @Option(option="extraFiles", description="Configures path of the extra files directory to be added to the Generated code.")
    @Nullable
    private File extraFiles;
    @Nested
    @Option(option="featureHeaderToRemove", description="")
    @Nullable
    private FeatureConfiguration features;

    @Nullable
    public final String getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@Nullable String string) {
        this.platform = string;
    }

    @Nullable
    public final String getPackageName() {
        return this.packageName;
    }

    public final void setPackageName(@Nullable String string) {
        this.packageName = string;
    }

    @Nullable
    public final String getSpecName() {
        return this.specName;
    }

    public final void setSpecName(@Nullable String string) {
        this.specName = string;
    }

    @Nullable
    public final String getSpecVersion() {
        return this.specVersion;
    }

    public final void setSpecVersion(@Nullable String string) {
        this.specVersion = string;
    }

    @NotNull
    public final File getInputFile() {
        File file = this.inputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        return file;
    }

    public final void setInputFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.inputFile = file;
    }

    @Nullable
    public final File getOutputDir() {
        return this.outputDir;
    }

    public final void setOutputDir(@Nullable File file) {
        this.outputDir = file;
    }

    @Nullable
    public final File getExtraFiles() {
        return this.extraFiles;
    }

    public final void setExtraFiles(@Nullable File file) {
        this.extraFiles = file;
    }

    @Nullable
    public final FeatureConfiguration getFeatures() {
        return this.features;
    }

    public final void setFeatures(@Nullable FeatureConfiguration featureConfiguration) {
        this.features = featureConfiguration;
    }

    @TaskAction
    public final void swaggerGenerate() {
        Collection $receiver$iv;
        String string;
        CharSequence charSequence;
        if (this.specVersion == null) {
            File file = this.inputFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
            }
            this.readVersionFromSpecfile(file);
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File defaultOutputDir = new File(project.getBuildDir(), "/gen");
        StringBuilder stringBuilder = new StringBuilder().append("\n            ####################\n            Yelp Swagger Codegen\n            ####################\n            Platform \t ");
        String string2 = this.platform;
        if (string2 == null) {
            string2 = "[ DEFAULT ] kotlin";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("\n            Package \t ");
        String string3 = this.packageName;
        if (string3 == null) {
            string3 = "[ DEFAULT ] com.codegen.default";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append("\n            specName \t ");
        String string4 = this.specName;
        if (string4 == null) {
            string4 = "[ DEFAULT ] defaultname";
        }
        StringBuilder stringBuilder4 = stringBuilder3.append(string4).append("\n            specVers \t ");
        String string5 = this.specVersion;
        if (string5 == null) {
            string5 = "[ DEFAULT ] 0.0.0";
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(string5).append("\n            input \t\t ");
        File file = this.inputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        StringBuilder stringBuilder6 = stringBuilder5.append(file).append("\n            output \t\t ");
        Object object = this.outputDir;
        if (object == null) {
            object = "[ DEFAULT ] " + defaultOutputDir;
        }
        StringBuilder stringBuilder7 = stringBuilder6.append(object).append("\n            groupId \t ");
        String string6 = this.packageName;
        if (string6 == null) {
            string6 = "[ DEFAULT ] default";
        }
        StringBuilder stringBuilder8 = stringBuilder7.append(string6).append("\n            artifactId \t ");
        String string7 = this.packageName;
        if (string7 == null) {
            string7 = "[ DEFAULT ] com.codegen";
        }
        StringBuilder stringBuilder9 = stringBuilder8.append(string7).append("\n            features \t ");
        Object object2 = this.features;
        if (this.features != null && (object2 = object2.getHeadersToRemove()) != null && (object2 = ArraysKt.joinToString$default((Object[])object2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) != null) {
            CharSequence charSequence2;
            charSequence = (CharSequence)object2;
            StringBuilder stringBuilder10 = stringBuilder9;
            CharSequence charSequence3 = charSequence;
            if (charSequence3.length() == 0) {
                boolean bl2 = false;
                charSequence2 = "[  EMPTY  ]";
            } else {
                charSequence2 = charSequence;
            }
            CharSequence charSequence4 = charSequence2;
            stringBuilder9 = stringBuilder10;
            string = (String)charSequence4;
        } else {
            string = null;
        }
        charSequence = StringsKt.trimIndent((String)stringBuilder9.append(string).append("\n        ").toString());
        System.out.println(charSequence);
        String string8 = this.packageName;
        if (string8 == null) {
            string8 = "com.codegen.default";
        }
        String packageName = string8;
        List params = new ArrayList();
        params.add("-p");
        String string9 = this.platform;
        if (string9 == null) {
            string9 = "kotlin";
        }
        params.add(string9);
        params.add("-s");
        String string10 = this.specName;
        if (string10 == null) {
            string10 = "defaultname";
        }
        params.add(string10);
        params.add("-v");
        String string11 = this.specVersion;
        if (string11 == null) {
            string11 = "0.0.0";
        }
        params.add(string11);
        params.add("-g");
        params.add(StringsKt.substringBeforeLast$default((String)packageName, (char)'.', null, (int)2, null));
        params.add("-a");
        params.add(StringsKt.substringAfterLast$default((String)packageName, (char)'.', null, (int)2, null));
        params.add("-i");
        File file2 = this.inputFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFile");
        }
        String string12 = file2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"inputFile.toString()");
        params.add(string12);
        params.add("-o");
        File file3 = this.outputDir;
        if (file3 == null) {
            file3 = defaultOutputDir;
        }
        String string13 = file3.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(outputDir ?: defaultOutputDir).toString()");
        params.add(string13);
        String[] stringArray = this.features;
        if (this.features != null && (stringArray = stringArray.getHeadersToRemove()) != null) {
            boolean bl;
            String[] bl2 = stringArray;
            boolean bl3 = true;
            String[] stringArray2 = bl2;
            boolean bl4 = bl = !(stringArray2.length == 0);
            if (bl3 == bl) {
                params.add("-ignoreheaders");
                Object object3 = this.features;
                if (this.features == null || (object3 = object3.getHeadersToRemove()) == null || (object3 = ArraysKt.joinToString$default((Object[])object3, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)) == null) {
                    object3 = "";
                }
                params.add(object3);
            }
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)params;
        String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
        if (stringArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Main.main(stringArray3);
        File source = this.extraFiles;
        File destin = this.outputDir;
        if (source != null && destin != null) {
            FilesKt.copyRecursively$default((File)source, (File)destin, (boolean)true, null, (int)4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readVersionFromSpecfile(File specFile) {
        try {
            Closeable closeable = new FileInputStream(specFile);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                Object object = new JSONTokener((InputStream)it).nextValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.json.JSONObject");
                }
                JSONObject jsonObject = (JSONObject)object;
                String version = jsonObject.getJSONObject("info").getString("version");
                String string = "Successfully read version from Swagger Spec file: " + version;
                System.out.println((Object)string);
                this.specVersion = version;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (JSONException e) {
            System.err.println("Failed to parse " + specFile + " to read spec version");
        }
    }

    public GenerateTask() {
        this.setDescription("Run the Swagger Code Generation tool");
        this.setGroup("build");
    }
}

