/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.utils;

import com.alibaba.fastjson.JSONObject;
import com.yao2san.sim.framework.web.config.WebConfigProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component
public class WebTestUtil {
    private static final Logger log = LoggerFactory.getLogger(WebTestUtil.class);
    private static final String TEST_JSON = "/test.json";
    private static Map<String, String> cache = null;
    private static WebConfigProperties webConfigProperties;

    @Autowired(required=false)
    public void setWebConfigProperties(WebConfigProperties webConfigProperties) {
        WebTestUtil.webConfigProperties = webConfigProperties;
    }

    public static boolean isTest(String key) {
        if (webConfigProperties != null) {
            WebConfigProperties.Test test = webConfigProperties.getTest();
            if (test == null) {
                return false;
            }
            Map<String, Boolean> map = test.getTest();
            return map.getOrDefault(key, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getTestData(String key, Class<T> clazz) {
        if (cache != null) return (T)JSONObject.parseObject((String)JSONObject.toJSONString((Object)cache.get(key)), clazz);
        Class<WebTestUtil> clazz2 = WebTestUtil.class;
        synchronized (WebTestUtil.class) {
            try (InputStream inputStream = WebTestUtil.class.getResourceAsStream(TEST_JSON);){
                if (inputStream == null) {
                    log.error("You have enabled the test function, but the test file is not found. Please add the file test.json to the resources directory");
                    T t = null;
                    // ** MonitorExit[clazz2] (shouldn't be in output)
                    return t;
                }
                String s = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                cache = new HashMap<String, String>();
                cache.putAll((Map)JSONObject.parseObject((String)s, Map.class));
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            // ** MonitorExit[clazz2] (shouldn't be in output)
            return (T)JSONObject.parseObject((String)JSONObject.toJSONString((Object)cache.get(key)), clazz);
        }
    }
}

