/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.utils;

import com.yao2san.sim.framework.utils.IpUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    private static final Logger log = LoggerFactory.getLogger(ServletUtil.class);
    public static final String TOKEN = "token";
    public static final String ACCESS_TOKEN_HEADER = "AccessToken";
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public static HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes != null) {
            return servletRequestAttributes.getRequest();
        }
        throw new RuntimeException("Current request is not http request");
    }

    public static HttpServletResponse getHttpServletResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes != null) {
            return servletRequestAttributes.getResponse();
        }
        throw new RuntimeException("Current request is not http request");
    }

    public static String getHeader(String headerName) {
        return ServletUtil.getHeader(headerName, null);
    }

    public static String getHeader(String headerName, String defaultValue) {
        String header = ServletUtil.getHttpServletRequest().getHeader(headerName);
        return header == null ? defaultValue : header;
    }

    public static String getToken() {
        HttpServletRequest request = ServletUtil.getHttpServletRequest();
        String token = request.getHeader(TOKEN);
        token = StringUtils.isEmpty((String)token) ? request.getParameter(TOKEN) : token;
        return token;
    }

    public static String getAuthorization() {
        HttpServletRequest request = ServletUtil.getHttpServletRequest();
        String header = request.getHeader(AUTHORIZATION_HEADER);
        String[] s = header.split(" ");
        if (s.length < 2) {
            return null;
        }
        return s[1];
    }

    public static String getAccessToken() {
        HttpServletRequest request = ServletUtil.getHttpServletRequest();
        String token = request.getHeader(ACCESS_TOKEN_HEADER);
        token = StringUtils.isEmpty((String)token) ? request.getParameter(ACCESS_TOKEN_HEADER) : token;
        return token;
    }

    public static String getRequestIp() {
        try {
            HttpServletRequest request = ServletUtil.getHttpServletRequest();
            return IpUtil.getClientIp((HttpServletRequest)request);
        }
        catch (Exception e) {
            log.info("{}", (Object)e.getMessage());
            return null;
        }
    }

    public static String getRequestBody(HttpServletRequest request) {
        StringBuilder data = new StringBuilder();
        try {
            String line;
            BufferedReader reader = request.getReader();
            while (null != (line = reader.readLine())) {
                data.append(line);
            }
            return data.toString();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getQueryParams(HttpServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        if (parameterNames != null && parameterNames.hasMoreElements()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                uriVariables.put(name, request.getParameter(name));
            }
            return uriVariables;
        }
        return Collections.emptyMap();
    }
}

