/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.uploader;

import com.yao2san.sim.framework.utils.CommonUtil;
import com.yao2san.sim.framework.web.uploader.FileNameRewriter;
import com.yao2san.sim.framework.web.uploader.FolderPolicy;
import com.yao2san.sim.framework.web.uploader.UploadResult;
import com.yao2san.sim.framework.web.uploader.WebUpDownloadProperties;
import com.yao2san.sim.framework.web.uploader.WebUploaderConfig;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class DefaultWebUploader {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebUploader.class);
    private WebUpDownloadProperties properties;
    private FolderPolicy policy;
    private FileNameRewriter fileNameRewriter;

    public UploadResult upload(MultipartFile file) throws IOException {
        return this.upload(file, new WebUploaderConfig());
    }

    public UploadResult upload(MultipartFile file, WebUploaderConfig config) throws IOException {
        String folder = this.policy.create();
        folder = CommonUtil.formatPath((String)folder);
        if (this.properties.getStoreType() == WebUpDownloadProperties.StoreType.LOCAL) {
            return this.uploadByLocal(file, folder, config);
        }
        throw new RuntimeException("Just support store type:LOCAL");
    }

    private UploadResult uploadByLocal(MultipartFile file, String folder, WebUploaderConfig config) throws IOException {
        UploadResult uploadResult = new UploadResult();
        String path = folder;
        path = CommonUtil.formatPath((String)path);
        String name = file.getOriginalFilename();
        if (config.getFileName() != null) {
            name = config.getFileName();
        }
        if (config.isRewriteFileName()) {
            name = this.fileNameRewriter.rewriter(name);
        }
        Object pathName = path + "/" + name;
        pathName = CommonUtil.formatPath((String)pathName);
        String relativePath = this.getRelativePath((String)pathName);
        File f = new File((String)pathName);
        uploadResult.setSuccess(false).setOriginalFileName(file.getOriginalFilename()).setPathName(relativePath);
        if (config.isRewriteFileName()) {
            uploadResult.setFileName(this.fileNameRewriter.rewriter(name));
        } else {
            uploadResult.setFileName(name);
        }
        if (!config.isOverwrite() && f.exists()) {
            uploadResult.setSuccess(false).setMessage("file exist");
            return uploadResult;
        }
        String p = CommonUtil.getPath((String)pathName);
        File pp = new File(p);
        if (!pp.exists()) {
            pp.mkdirs();
        }
        file.transferTo(f);
        uploadResult.setSuccess(true).setMessage("ok");
        return uploadResult;
    }

    private String getRelativePath(String pathName) {
        String s = pathName.replace(CommonUtil.formatPath((String)this.properties.getRootPath()), "");
        return s.startsWith("/") ? s : "/" + s;
    }

    private void uploadByRemote(MultipartFile file) {
    }

    private void uploadByFtp(MultipartFile file) {
    }

    private void uploadBySftp(MultipartFile file) {
    }

    public WebUpDownloadProperties getProperties() {
        return this.properties;
    }

    public FolderPolicy getPolicy() {
        return this.policy;
    }

    public FileNameRewriter getFileNameRewriter() {
        return this.fileNameRewriter;
    }

    public void setProperties(WebUpDownloadProperties properties) {
        this.properties = properties;
    }

    public void setPolicy(FolderPolicy policy) {
        this.policy = policy;
    }

    public void setFileNameRewriter(FileNameRewriter fileNameRewriter) {
        this.fileNameRewriter = fileNameRewriter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultWebUploader)) {
            return false;
        }
        DefaultWebUploader other = (DefaultWebUploader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WebUpDownloadProperties this$properties = this.getProperties();
        WebUpDownloadProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        FolderPolicy this$policy = this.getPolicy();
        FolderPolicy other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !this$policy.equals(other$policy)) {
            return false;
        }
        FileNameRewriter this$fileNameRewriter = this.getFileNameRewriter();
        FileNameRewriter other$fileNameRewriter = other.getFileNameRewriter();
        return !(this$fileNameRewriter == null ? other$fileNameRewriter != null : !this$fileNameRewriter.equals(other$fileNameRewriter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultWebUploader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebUpDownloadProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        FolderPolicy $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : $policy.hashCode());
        FileNameRewriter $fileNameRewriter = this.getFileNameRewriter();
        result = result * 59 + ($fileNameRewriter == null ? 43 : $fileNameRewriter.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultWebUploader(properties=" + this.getProperties() + ", policy=" + this.getPolicy() + ", fileNameRewriter=" + this.getFileNameRewriter() + ")";
    }
}

