/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.uploader;

import com.yao2san.sim.framework.utils.CommonUtil;
import com.yao2san.sim.framework.web.uploader.WebDownloaderConfig;
import com.yao2san.sim.framework.web.uploader.WebUpDownloadProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebDownloader {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebDownloader.class);
    private WebUpDownloadProperties properties;

    public void download(String file, String fileName, HttpServletResponse response) {
        this.download(file, fileName, response, new WebDownloaderConfig());
    }

    public void download(String file, String fileName, HttpServletResponse response, WebDownloaderConfig config) {
        if (WebUpDownloadProperties.StoreType.LOCAL.equals((Object)this.properties.getStoreType())) {
            this.downloadByLocal(file, fileName, response, config);
        }
    }

    private void downloadByLocal(String file, String fileName, HttpServletResponse response, WebDownloaderConfig config) {
        String rootPath = this.properties.getRootPath();
        file = rootPath + (String)file;
        file = CommonUtil.formatPath((String)file);
        File ff = new File((String)file);
        response.reset();
        response.setCharacterEncoding("utf-8");
        response.setContentLength(Integer.parseInt(String.valueOf(ff.length())));
        if (config.isDownload()) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        } else {
            response.setContentType(URLConnection.guessContentTypeFromName((String)file));
        }
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get((String)file, new String[0]), new OpenOption[0]));){
            int i;
            byte[] buff = new byte[1024];
            ServletOutputStream os = response.getOutputStream();
            while ((i = bis.read(buff)) != -1) {
                os.write(buff, 0, i);
                os.flush();
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        if (config.isDelete() && ff.isFile()) {
            ff.delete();
        }
    }

    public WebUpDownloadProperties getProperties() {
        return this.properties;
    }

    public void setProperties(WebUpDownloadProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultWebDownloader)) {
            return false;
        }
        DefaultWebDownloader other = (DefaultWebDownloader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WebUpDownloadProperties this$properties = this.getProperties();
        WebUpDownloadProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultWebDownloader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebUpDownloadProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultWebDownloader(properties=" + this.getProperties() + ")";
    }
}

