/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yao2san.sim.framework.web.exception.BusiException;
import com.yao2san.sim.framework.web.response.ResponseCode;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"success", "objectMapper"})
public class ResponseData<T>
implements Serializable {
    private int code;
    private T data;
    private String msg;
    private String requestId;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ResponseData() {
    }

    private ResponseData(int status, String msg, T data) {
        this.code = status;
        this.msg = msg;
        this.data = data;
    }

    private ResponseData(int status, String msg) {
        this.code = status;
        this.msg = msg;
    }

    private ResponseData(ResponseCode status, String msg) {
        this.code = status.getCode();
        this.msg = msg;
    }

    public boolean isSuccess() {
        return this.code == ResponseCode.SUCCESS.getCode();
    }

    public String toJsonString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> ResponseData<T> success() {
        return new ResponseData<Object>(ResponseCode.SUCCESS.getCode(), "", null);
    }

    public static <T> ResponseData<T> success(T data) {
        return new ResponseData<T>(ResponseCode.SUCCESS.getCode(), "", data);
    }

    public static <T> ResponseData<T> success(T data, String msg) {
        return new ResponseData<T>(ResponseCode.SUCCESS.getCode(), msg, data);
    }

    public static <T> ResponseData<T> error() {
        return new ResponseData<T>(ResponseCode.ERROR, "");
    }

    public static <T> ResponseData<T> error(String msg) {
        return new ResponseData<T>(ResponseCode.ERROR, msg);
    }

    public static <T> ResponseData<T> businessError(String msg) {
        return new ResponseData<T>(ResponseCode.BUSINESS_EXCEPTION, msg);
    }

    public static <T> ResponseData<T> error(int status, String msg) {
        return new ResponseData<T>(status, msg);
    }

    public static <T> ResponseData<T> error(ResponseCode status) {
        return new ResponseData<T>(status, "");
    }

    public static <T> ResponseData<T> error(ResponseCode status, String msg) {
        return new ResponseData<T>(status, msg);
    }

    public static <T> ResponseData<T> accessRestricted(int status, String msg) {
        return new ResponseData<T>(ResponseCode.ACCESS_RESTRICTED.getCode(), msg);
    }

    public static boolean isOk(ResponseData<?> responseData) {
        return responseData != null && responseData.getCode() == ResponseCode.SUCCESS.getCode();
    }

    public static BusiException exception(ResponseData<?> responseData) {
        return new BusiException(responseData.getCode(), responseData.getMsg());
    }

    public ResponseData<T> okOrElseThrow() {
        if (this.isSuccess()) {
            return this;
        }
        throw new BusiException(this.code, this.msg);
    }

    public ResponseData<T> okOrElseThrowDefault() {
        if (this.isSuccess()) {
            return this;
        }
        throw new BusiException(this.code, "\u670d\u52a1\u5668\u5f00\u5c0f\u5dee\u4e86\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5~");
    }

    public ResponseData<T> okOrElse(ResponseDataHandler<T> handler) {
        handler.handle(this);
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ", requestId=" + this.getRequestId() + ")";
    }

    public static interface ResponseDataHandler<T> {
        public void handle(ResponseData<T> var1);
    }
}

