/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CloudRequest {
    private static RestTemplate restTemplate;

    @Autowired
    @Qualifier(value="cloudRestTemplate")
    public void setRestTemplate(RestTemplate restTemplate) {
        CloudRequest.restTemplate = restTemplate;
    }

    public static <T> T postForObject(String url, Object object, Class<T> clazz) {
        return CloudRequest.postForObject(url, object, MediaType.APPLICATION_JSON_UTF8, clazz);
    }

    public static <T> T postForObject(String url, Object object, MediaType mediaType, Class<T> clazz) {
        return (T)CloudRequest.postForEntity(url, object, mediaType, clazz).getBody();
    }

    public static <T> ResponseEntity<T> postForEntity(String url, Object object, MediaType mediaType, Class<T> clazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        String requestJson = null;
        try {
            requestJson = objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        HttpEntity httpEntity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        return restTemplate.postForEntity(url, (Object)httpEntity, clazz, new Object[0]);
    }

    public static <T> T getForObject(String url, Class<T> clazz) {
        return (T)CloudRequest.getForEntity(url, null, clazz).getBody();
    }

    public static <T> T getForObject(String url, Map<String, Object> urlParams, Class<T> clazz) {
        return (T)CloudRequest.getForEntity(url, urlParams, clazz).getBody();
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Map<String, Object> urlParams, Class<T> clazz) {
        url = CloudRequest.builderUrl(url, urlParams);
        return restTemplate.getForEntity(url, clazz, new Object[0]);
    }

    private static String builderUrl(String url, Map<String, Object> params) {
        if (params != null) {
            StringBuilder urlBuilder = new StringBuilder(url);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                urlBuilder.append("?").append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            url = urlBuilder.toString();
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

