/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.mybatis.interceptor;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.yao2san.sim.framework.web.mybatis.sharding.ShardingConfigProperties;
import com.yao2san.sim.framework.web.mybatis.sharding.ShardingStrategy;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
@ConditionalOnProperty(prefix="sim.database.table-sharding", name={"enable"}, havingValue="true")
public class TableShardInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(TableShardInterceptor.class);
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private static final Map<String, ShardingStrategy> TABLE_SHARDING_STRATEGY = new HashMap<String, ShardingStrategy>();
    private static final String BOUND_SQL_KEY = "delegate.boundSql.sql";
    private final ShardingConfigProperties properties;

    public TableShardInterceptor(ShardingConfigProperties properties) throws InstantiationException, IllegalAccessException {
        this.properties = properties;
        this.convert();
    }

    private void convert() throws InstantiationException, IllegalAccessException {
        List<ShardingConfigProperties.ShardingTableStrategy> mapping = this.properties.getMapping();
        if (mapping == null) {
            return;
        }
        for (ShardingConfigProperties.ShardingTableStrategy strategy : mapping) {
            List<String> tables = strategy.getTables();
            ShardingStrategy s = strategy.getStrategy().newInstance();
            for (String table : tables) {
                TABLE_SHARDING_STRATEGY.put(table, s);
            }
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (TABLE_SHARDING_STRATEGY.isEmpty()) {
            return invocation.proceed();
        }
        log.debug("starting sharding table");
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        String sql = (String)metaObject.getValue(BOUND_SQL_KEY);
        log.debug("original sql:{}", (Object)sql);
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement statement = parser.parseStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        statement.accept((SQLASTVisitor)visitor);
        Map tables = visitor.getTables();
        Set names = tables.keySet();
        for (TableStat.Name name : names) {
            String tableName;
            Set<String> shardingTableNames = TABLE_SHARDING_STRATEGY.keySet();
            if (!shardingTableNames.contains(tableName = name.getName())) continue;
            ShardingStrategy shardingStrategy = TABLE_SHARDING_STRATEGY.get(tableName);
            String newTableName = shardingStrategy.getTableName(tableName);
            sql = sql.replaceAll(tableName, newTableName);
        }
        log.debug("sharding sql:{}", (Object)sql);
        metaObject.setValue(BOUND_SQL_KEY, (Object)sql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler && this.properties.isEnable()) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

