/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.mybatis.interceptor;

import com.yao2san.sim.framework.cache.utils.CacheUtil;
import com.yao2san.sim.framework.common.auth.UserPrincipal;
import com.yao2san.sim.framework.web.annotation.CreateUser;
import com.yao2san.sim.framework.web.annotation.DisableAutoFillFiled;
import com.yao2san.sim.framework.web.annotation.UpdateUser;
import com.yao2san.sim.framework.web.bean.OpenToken;
import com.yao2san.sim.framework.web.exception.BusiException;
import com.yao2san.sim.framework.web.utils.FieldUtil;
import com.yao2san.sim.framework.web.utils.ServletUtil;
import com.yao2san.sim.framework.web.utils.WebTestUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AutoFillUserInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AutoFillUserInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object parameter = invocation.getArgs()[1];
        if (!this.enabled(parameter)) {
            return invocation.proceed();
        }
        List<Field> fields = FieldUtil.getFields(parameter.getClass());
        for (Field field : fields) {
            boolean accessible;
            if (field.getAnnotation(CreateUser.class) != null) {
                accessible = field.isAccessible();
                field.setAccessible(true);
                field.set(parameter, this.getUserId());
                field.setAccessible(accessible);
            }
            if (field.getAnnotation(UpdateUser.class) == null) continue;
            accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(parameter, this.getUserId());
            field.setAccessible(accessible);
        }
        return invocation.proceed();
    }

    private boolean enabled(Object param) {
        if (param == null) {
            return false;
        }
        boolean isDisable = param.getClass().isAnnotationPresent(DisableAutoFillFiled.class);
        return !isDisable && !(param instanceof Map);
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private Long getUserId() {
        if (WebTestUtil.isTest("user")) {
            UserPrincipal userPrincipal = WebTestUtil.getTestData("user", UserPrincipal.class);
            if (userPrincipal == null) {
                throw new BusiException("User not found!");
            }
            return userPrincipal.getId();
        }
        UserPrincipal userPrincipal = (UserPrincipal)SecurityUtils.getSubject().getPrincipal();
        if (userPrincipal != null) {
            return userPrincipal.getId();
        }
        OpenToken info = (OpenToken)CacheUtil.get((String)("SIM:OAUTH:TOKEN:" + ServletUtil.getToken()));
        if (info == null || info.getUserId() == null) {
            throw new BusiException("User not found!");
        }
        return info.getUserId();
    }
}

