/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.mybatis.interceptor;

import com.yao2san.sim.framework.web.annotation.CreateDate;
import com.yao2san.sim.framework.web.annotation.UpdateDate;
import com.yao2san.sim.framework.web.utils.FieldUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AutoFillDateInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        if (parameter == null) {
            return invocation.proceed();
        }
        List<Field> fields = FieldUtil.getFields(parameter.getClass());
        for (Field field : fields) {
            boolean accessible;
            if (field.getAnnotation(CreateDate.class) != null && SqlCommandType.INSERT.equals((Object)sqlCommandType)) {
                accessible = field.isAccessible();
                field.setAccessible(true);
                field.set(parameter, DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss"));
                field.setAccessible(accessible);
            }
            if (field.getAnnotation(UpdateDate.class) == null || !SqlCommandType.INSERT.equals((Object)sqlCommandType) && !SqlCommandType.UPDATE.equals((Object)sqlCommandType)) continue;
            accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(parameter, DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss"));
            field.setAccessible(accessible);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }
}

