/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.web.exception;

import com.alibaba.fastjson.JSONObject;
import com.netflix.client.ClientException;
import com.yao2san.sim.framework.web.exception.BusiException;
import com.yao2san.sim.framework.web.exception.MessageException;
import com.yao2san.sim.framework.web.response.ResponseCode;
import com.yao2san.sim.framework.web.response.ResponseData;
import feign.RetryableException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class BusiExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(BusiExceptionHandler.class);
    @Value(value="${spring.application.name}")
    public String SERVICE_NAME;

    @ResponseBody
    @ExceptionHandler(value={BusiException.class})
    public ResponseData handlerBusiException(BusiException e, HttpServletRequest request) {
        log.error("", (Throwable)e);
        String params = JSONObject.toJSONString((Object)request.getParameterMap());
        ResponseData responseData = ResponseData.error(e.getCode(), e.getMessage());
        String method = request.getMethod();
        String serviceName = this.SERVICE_NAME;
        log.error("SERVICE:{};ERROR:{};METHOD:{}", new Object[]{serviceName, e.getMessage(), method});
        return responseData;
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResponseData handlerException(Exception e, HttpServletRequest request) throws IOException {
        log.error("", (Throwable)e);
        if (e instanceof BindException) {
            return this.handleBindException((BindException)e);
        }
        if (e instanceof MethodArgumentNotValidException) {
            return this.handleMethodArgumentNotValidException((MethodArgumentNotValidException)e);
        }
        if (e instanceof BadSqlGrammarException && e.getMessage().contains("command denied to user")) {
            return this.handleNotUpdateDeletePermissionException((BadSqlGrammarException)e);
        }
        if (e.getCause() instanceof ClientException && e.getMessage().contains("Load balancer does not have available server for client")) {
            return this.handleNotAvailableServerException((ClientException)e.getCause());
        }
        String method = request.getMethod();
        String serviceName = this.SERVICE_NAME;
        log.error("SERVICE:{};ERROR:{};METHOD:{}", new Object[]{serviceName, e.getMessage(), method});
        return ResponseData.error(ResponseCode.SERVER_ERROR, e.getMessage());
    }

    private ResponseData handleBindException(BindException e) {
        log.error("Rest service exception", (Throwable)e);
        List fieldErrorList = e.getBindingResult().getFieldErrors();
        String message = this.getMessage(fieldErrorList);
        return ResponseData.error(ResponseCode.ILLEGAL_ARGUMENT, message);
    }

    private ResponseData handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error("Rest service exception", (Throwable)e);
        List fieldErrorList = e.getBindingResult().getFieldErrors();
        String message = this.getMessage(fieldErrorList);
        return ResponseData.error(ResponseCode.ILLEGAL_ARGUMENT, message);
    }

    private ResponseData handleNotUpdateDeletePermissionException(BadSqlGrammarException e) {
        log.error("Rest service exception", (Throwable)e);
        return ResponseData.businessError("current user is view only");
    }

    private ResponseData handleNotAvailableServerException(ClientException e) {
        log.error("Service invoke exception", (Throwable)e);
        return ResponseData.error(ResponseCode.SERVICE_UNAVAILABLE, ResponseCode.SERVICE_UNAVAILABLE.getDesc());
    }

    @ExceptionHandler(value={RetryableException.class})
    @ResponseBody
    private ResponseData handleRetryableException(RetryableException e) {
        log.error("Service invoke error", (Throwable)e);
        return ResponseData.error(ResponseCode.READ_TIMEOUT, ResponseCode.READ_TIMEOUT.getDesc());
    }

    @ExceptionHandler(value={MessageException.class})
    @ResponseBody
    private ResponseData handleMessageException(MessageException e) {
        return ResponseData.error(ResponseCode.BUSINESS_EXCEPTION, e.getMessage());
    }

    private String getMessage(List<FieldError> fieldErrorList) {
        ArrayList<String> messages = new ArrayList<String>(8);
        if (!CollectionUtils.isEmpty(fieldErrorList)) {
            for (FieldError fieldError : fieldErrorList) {
                if (fieldError == null || fieldError.getDefaultMessage() == null) continue;
                messages.add(fieldError.getDefaultMessage());
            }
        }
        return String.join((CharSequence)",", messages);
    }
}

