/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils.json.serializer.desensitization;

import com.yao2san.sim.framework.utils.json.serializer.desensitization.DesensitizationHandler;
import com.yao2san.sim.framework.utils.json.serializer.desensitization.DesensitizationType;
import com.yao2san.sim.framework.utils.json.serializer.desensitization.handlers.MobileDesensitizationHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DesensitizationHandlerSupport {
    private static final Map<Class<? extends DesensitizationHandler>, DesensitizationHandler> CUSTOM_HANDLERS = new ConcurrentHashMap<Class<? extends DesensitizationHandler>, DesensitizationHandler>();

    public static DesensitizationHandler registerHandler(Class<? extends DesensitizationHandler> clazz) {
        try {
            DesensitizationHandler instance = CUSTOM_HANDLERS.get(clazz);
            if (instance == null) {
                instance = clazz.newInstance();
                instance = CUSTOM_HANDLERS.put(clazz, instance);
            }
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum DefaultHandler {
        MOBILE_PHONE(DesensitizationType.MOBILE_PHONE, new MobileDesensitizationHandler());

        private final DesensitizationType type;
        private final DesensitizationHandler handler;

        private DefaultHandler(DesensitizationType type, DesensitizationHandler handler) {
            this.type = type;
            this.handler = handler;
        }

        public static DesensitizationHandler ofHandler(DesensitizationType type) {
            for (DefaultHandler value : DefaultHandler.values()) {
                if (value.type != type) continue;
                return value.handler;
            }
            throw new IllegalArgumentException("Not supported handler type:" + type);
        }

        public DesensitizationType getType() {
            return this.type;
        }

        public DesensitizationHandler getHandler() {
            return this.handler;
        }
    }
}

