/*
 * Decompiled with CFR 0.152.
 */
package com.yao2san.sim.framework.utils.ftpUtil;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.yao2san.sim.framework.utils.ftpUtil.FtpConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SftpClient {
    private static final Logger logger = LoggerFactory.getLogger(SftpClient.class);
    private ChannelSftp sftp;
    private boolean isReady = false;
    private FtpConfig config;
    private String directory = null;
    private Session sshSession;

    @Autowired
    public SftpClient(FtpConfig config) {
        this.config = config;
        this.directory = config.getRootPath();
    }

    private void setReady() throws Exception {
        try {
            if (!this.isReady) {
                JSch jsch = new JSch();
                this.sshSession = jsch.getSession(this.config.getUsername(), this.config.getHost(), this.config.getPort());
                logger.info("Session created.");
                Properties sshConfig = new Properties();
                sshConfig.put("StrictHostKeyChecking", "no");
                this.sshSession.setPassword(this.config.getPassword());
                this.sshSession.setConfig(sshConfig);
                this.isReady = true;
            }
            if (this.sshSession != null && !this.sshSession.isConnected()) {
                this.sshSession.connect();
                Channel channel = this.config.getType() == FtpConfig.Type.sftp ? this.sshSession.openChannel("sftp") : this.sshSession.openChannel("ftp");
                channel.connect();
                this.sftp = (ChannelSftp)channel;
            }
        }
        catch (Exception e) {
            this.close();
            logger.error("sftp\u8fde\u63a5\u670d\u52a1\u5668\u51fa\u9519,host:" + this.config.getHost(), (Throwable)e);
            throw e;
        }
    }

    public boolean uploadFile(String uploadFile, String remoteName) throws Exception {
        try {
            this.setReady();
            if (remoteName.contains("/")) {
                String remotePath = remoteName.substring(0, remoteName.lastIndexOf("/"));
                this.sftp.cd(this.directory);
                this.sftp.mkdir(remotePath);
                this.sftp.cd(this.directory + "/" + remotePath);
                remoteName = remoteName.substring(remoteName.lastIndexOf("/") + 1);
            } else {
                this.sftp.cd(this.directory);
            }
            File file = new File(uploadFile);
            this.sftp.put((InputStream)new FileInputStream(file), remoteName);
            return true;
        }
        catch (Exception e) {
            logger.error("sftp\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519,directory:" + this.directory, (Throwable)e);
            throw e;
        }
    }

    public boolean uploadFile(String remoteName, InputStream inputStream) throws Exception {
        try {
            this.setReady();
            this.sftp.put(inputStream, remoteName);
            return true;
        }
        catch (Exception e) {
            logger.error("sftp\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519,directory:" + this.directory, (Throwable)e);
            throw e;
        }
    }

    public boolean downloadFile(String downloadFile, String saveFile) throws Exception {
        try {
            this.setReady();
            this.sftp.cd(this.directory);
            File localFile = new File(saveFile);
            if (!localFile.exists()) {
                if (localFile.getParentFile() != null && !localFile.getParentFile().exists()) {
                    localFile.getParentFile().mkdirs();
                }
                localFile.createNewFile();
            }
            this.sftp.get(downloadFile, (OutputStream)new FileOutputStream(localFile));
            return true;
        }
        catch (Exception e) {
            logger.error("sftp\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519,directory:{}", (Object)this.directory, (Object)e);
            throw e;
        }
    }

    public boolean removeFile(String deleteFile) throws Exception {
        try {
            this.setReady();
            this.sftp.cd(this.directory);
            this.sftp.rm(deleteFile);
            return true;
        }
        catch (Exception e) {
            logger.error("sftp\u5220\u9664\u6587\u4ef6\u51fa\u9519,directory:" + this.directory, (Throwable)e);
            throw e;
        }
    }

    public boolean copyFile(String src, String dst) throws Exception {
        try (ByteArrayInputStream bStreams = null;){
            this.setReady();
            if (!this.isFileExist(src)) {
                boolean bl = false;
                return bl;
            }
            String parentPath = dst.substring(0, dst.lastIndexOf("/"));
            if (!this.isDirExist(parentPath)) {
                this.createDir(parentPath);
            }
            byte[] srcFtpFileByte = this.inputStreamToByte(this.sftp.get(src));
            bStreams = new ByteArrayInputStream(srcFtpFileByte);
            this.sftp.put((InputStream)bStreams, dst);
            boolean bl = true;
            return bl;
        }
    }

    public boolean isFileExist(String remoteFile) throws SftpException {
        boolean isExitFlag = false;
        if (this.getFileSize(remoteFile) >= 0L) {
            isExitFlag = true;
        }
        return isExitFlag;
    }

    public long getFileSize(String remoteFile) throws SftpException {
        long filesize;
        block2: {
            try {
                SftpATTRS sftpATTRS = this.sftp.lstat(remoteFile);
                filesize = sftpATTRS.getSize();
            }
            catch (Exception e) {
                filesize = -1L;
                if (!e.getMessage().toLowerCase().equals("no such file")) break block2;
                filesize = -2L;
            }
        }
        return filesize;
    }

    public byte[] inputStreamToByte(InputStream inputStream) throws IOException {
        int ch;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) != -1) {
            byteArrayOutputStream.write(ch);
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return bytes;
    }

    public void createDir(String remoteFile) throws SftpException {
        String[] split;
        this.sftp.cd("/");
        for (String path : split = remoteFile.split("/")) {
            if (path.equals("")) continue;
            if (this.isDirExist(path)) {
                this.sftp.cd(path);
                continue;
            }
            this.sftp.mkdir(path);
            this.sftp.cd(path);
        }
        this.sftp.cd(this.directory);
    }

    public boolean isDirExist(String directory) throws SftpException {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.sftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    public List<?> listFiles() throws Exception {
        this.setReady();
        return this.sftp.ls(this.directory);
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public void close() throws IOException {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
        if (this.sshSession != null && this.sshSession.isConnected()) {
            this.sshSession.disconnect();
        }
        this.isReady = false;
        logger.info("JSCH session close");
    }

    public FtpConfig getConfig() {
        return this.config;
    }
}

